import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2020 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->


<style include="cr-shared-style oobe-dialog-host-styles">setup-pin-keyboard{margin-top:37px}</style>

<oobe-adaptive-dialog id="setup" role="dialog" for-step="start,confirm">
  <iron-icon slot="icon" icon="oobe-32:lock"></iron-icon>
  <h1 id="setupTitle" slot="title" for-step="start" aria-live="polite">
    <!-- REGULAR PIN SETUP -->
    <div hidden="[[isRecoveryMode]]">
      <div hidden="[[!usingPinAsMainSignInFactor]]">
        <!-- "Set a PIN to make it easier to sign in" -->
        [[i18nDynamic(locale, 'discoverPinSetupPinAsMainFactorTitle')]]
      </div>
      <div hidden="[[usingPinAsMainSignInFactor]]">
        <div hidden="[[isChildAccount]]">
          <!-- "Choose your PIN" -->
          [[i18nDynamic(locale, 'discoverPinSetupTitle1')]]
        </div>
        <div hidden="[[!isChildAccount]]">
          <!-- "Choose a PIN" -->
          [[i18nDynamic(locale, 'discoverPinSetupTitle1ForChild')]]
        </div>
      </div>
    </div>
    <!-- PIN RESET VIA RECOVERY -->
    <div hidden="[[!isRecoveryMode]]">
      <!-- "Reset your PIN"-->
      [[i18nDynamic(locale, 'discoverPinSetupResetTitle')]]
    </div>
  </h1>

  <div id="setupSubtitle" slot="subtitle" for-step="start">
    <!-- REGULAR PIN SETUP -->
    <div hidden="[[isRecoveryMode]]">
      <div hidden="[[!usingPinAsMainSignInFactor]]">
        <!-- "Instead of entering your Google Account password to sign in,
              you can create a PIN for this Chromebook" -->
        [[i18nDynamic(locale, 'discoverPinSetupPinAsMainFactorSubtitle')]]
      </div>
      <div hidden="[[usingPinAsMainSignInFactor]]">
        <div hidden="[[isChildAccount]]">
          <!-- "Use a number (PIN) instead of a password to unlock your device.
                To set your PIN later, go to Settings." -->
          [[i18nDynamic(locale, 'discoverPinSetupSubtitle1')]]
        </div>
        <div hidden="[[!isChildAccount]]">
          <!-- "Your child can use a number (PIN) instead of a password to unlock
                this device. To set a PIN later, go to Settings." -->
          [[i18nDynamic(locale, 'discoverPinSetupSubtitle1ForChild')]]
        </div>
      </div>
    </div>
    <!-- PIN RESET VIA RECOVERY -->
    <div hidden="[[!isRecoveryMode]]">
      <div hidden="[[isChildAccount]]">
        <!-- "You can use this PIN to sign in to your device" -->
        [[i18nDynamic(locale, 'discoverPinSetupResetSubtitle')]]
      </div>
      <div hidden="[[!isChildAccount]]">
        <!-- "Your child can use this PIN to sign in to their device" -->
        [[i18nDynamic(locale, 'discoverPinSetupResetSubtitle')]]
      </div>
    </div>
  </div>

  <!-- CONFIRMATION STEP - NO SUBTITLE  -->
  <h1 slot="title" for-step="confirm" aria-live="polite">
    <div hidden="[[isChildAccount]]">
      <!-- "Type your PIN again" -->
      [[i18nDynamic(locale, 'discoverPinSetupTitle2')]]
    </div>
    <div hidden="[[!isChildAccount]]">
      <!-- "Type the PIN again" -->
      [[i18nDynamic(locale, 'discoverPinSetupTitle2ForChild')]]
    </div>
  </h1>

  <div slot="content" class="flex-grow layout vertical center
      center-justified">
    <setup-pin-keyboard id="pinKeyboard"
        enable-submit="{{enableSubmit}}"
        is-confirm-step="{{isConfirmStep}}"
        use-recovery-mode-api="[[isRecoveryMode]]"
        on-pin-submit="onPinSubmit"
        on-set-pin-done="onSetPinDone"
        auth-token="[[authToken]]"
        quick-unlock-private="[[quickUnlockPrivate]]"
        class="focus-on-show"
        enable-visibility-icon
        enable-placeholder>
    </setup-pin-keyboard>
  </div>
  <div slot="back-navigation">
    <oobe-back-button id="backButton" for-step="confirm"
        on-click="onBackButton">
    </oobe-back-button>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="setupSkipButton" on-click="onSkipButton"
        disabled="[[isRecoveryMode]]" for-step="start, confirm"
        text-key="[[getSkipButtonLabel(usingPinAsMainSignInFactor)]]">
    </oobe-text-button>
    <oobe-next-button inverse
        id="nextButton"
        disabled="[[!enableSubmit]]"
        on-click="onNextButton" class="focus-on-show"
        for-step="start, confirm"></oobe-next-button>
  </div>
</oobe-adaptive-dialog>

<oobe-adaptive-dialog id="doneDialog" role="dialog" for-step="done"
    footer-shrinkable>
  <iron-icon slot="icon" icon="oobe-32:lock"></iron-icon>
  <h1 slot="title" aria-live="polite">
    <!-- REGULAR PIN SETUP -->
    <div hidden="[[isRecoveryMode]]">
      <div hidden="[[isChildAccount]]">
        <!-- "Your PIN has been added" -->
        [[i18nDynamic(locale, 'discoverPinSetupTitle3')]]
      </div>
      <div hidden="[[!isChildAccount]]">
        <!-- "Your child’s PIN has been added" -->
        [[i18nDynamic(locale, 'discoverPinSetupTitle3ForChild')]]
      </div>
    </div>
    <!-- PIN RESET VIA RECOVERY -->
    <div hidden="[[!isRecoveryMode]]">
      <div hidden="[[isChildAccount]]">
        <!-- "Your PIN has been updated" -->
      [[i18nDynamic(locale, 'discoverPinSetupResetDoneTitle')]]
      </div>
      <div hidden="[[!isChildAccount]]">
        <!-- "Your child’s PIN has been updated" -->
        [[i18nDynamic(locale, 'discoverPinSetupResetDoneTitleChild')]]
      </div>
    </div>
  </h1>
  <div slot="subtitle">
    <div hidden="[[hasLoginSupport]]">
      <div hidden="[[isChildAccount]]">
        <!-- "You can use your PIN to unlock your device." -->
        [[i18nDynamic(locale, 'discoverPinSetupSubtitle3NoLogin')]]
      </div>
      <div hidden="[[!isChildAccount]]">
        <!-- "Your child can use a PIN to unlock the device." -->
        [[i18nDynamic(locale, 'discoverPinSetupSubtitle3NoLoginForChild')]]
      </div>
    </div>
    <div hidden="[[!hasLoginSupport]]">
      <div hidden="[[isChildAccount]]">
        <!-- "You can use your PIN to sign in to or unlock your device." -->
        [[i18nDynamic(locale, 'discoverPinSetupSubtitle3WithLogin')]]
      </div>
      <div hidden="[[!isChildAccount]]">
        <!-- "Your child can use a PIN to sign in to or unlock the device." -->
        [[i18nDynamic(locale,
            'discoverPinSetupSubtitle3WithLoginForChild')]]
      </div>
    </div>
  </div>
  <div slot="content" class="flex layout vertical center
      center-justified">
    <iron-icon icon="oobe-illos:pin-illustration-illo"
        class="illustration-jelly">
    </iron-icon>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="doneButton" inverse on-click="onDoneButton"
        disabled="[[!isSetupDoneButtonEnabled]]"
        class="focus-on-show" text-key="discoverPinSetupDone">
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`}