// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cr_input/cr_input.js";import"//resources/ash/common/cr_elements/cr_shared_style.css.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"../../components/oobe_icons.html.js";import"../../components/common_styles/oobe_common_styles.css.js";import"../../components/common_styles/oobe_dialog_host_styles.css.js";import"../../components/dialogs/oobe_adaptive_dialog.js";import"../../components/buttons/oobe_back_button.js";import"../../components/buttons/oobe_next_button.js";import"../../components/buttons/oobe_text_button.js";import{SetupPinKeyboardElement}from"//resources/ash/common/quick_unlock/setup_pin_keyboard.js";import{assert}from"//resources/js/assert.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeUiState}from"../../components/display_manager_types.js";import{LoginScreenMixin}from"../../components/mixins/login_screen_mixin.js";import{MultiStepMixin}from"../../components/mixins/multi_step_mixin.js";import{OobeI18nMixin}from"../../components/mixins/oobe_i18n_mixin.js";import{getTemplate}from"./pin_setup.html.js";var PinSetupState;(function(PinSetupState){PinSetupState["START"]="start";PinSetupState["CONFIRM"]="confirm";PinSetupState["DONE"]="done"})(PinSetupState||(PinSetupState={}));const PinSetupBase=LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));class PinSetup extends PinSetupBase{static get is(){return"pin-setup-element"}static get template(){return getTemplate()}static get properties(){return{enableSubmit:{type:Boolean,value:false},isConfirmStep:{type:Boolean,value:false,observer:"onIsConfirmStepChanged"},authToken:{type:String},quickUnlockPrivate:{type:Object,value:chrome.quickUnlockPrivate},hasLoginSupport:{type:Boolean,value:false},usingPinAsMainSignInFactor:{type:Boolean,value:false},isChildAccount:{type:Boolean,value:false},isRecoveryMode:{type:Boolean,value:false},isSetupDoneButtonEnabled:{type:Boolean,value:false}}}get UI_STEPS(){return PinSetupState}getOobeUIInitialState(){return OobeUiState.ONBOARDING}ready(){super.ready();this.initializeLoginScreen("PinSetupScreen")}defaultUIStep(){return PinSetupState.START}getPinKeyboard(){const pinKeyboard=this.shadowRoot?.querySelector("#pinKeyboard");assert(pinKeyboard instanceof SetupPinKeyboardElement);return pinKeyboard}onBeforeShow(data){super.onBeforeShow(data);this.getPinKeyboard().resetState();this.authToken=data.authToken;this.isChildAccount=data.isChildAccount;this.hasLoginSupport=data.hasLoginSupport;this.usingPinAsMainSignInFactor=data.usingPinAsMainSignInFactor;this.isRecoveryMode=data.isRecoveryMode;this.isSetupDoneButtonEnabled=true}onIsConfirmStepChanged(){if(this.isConfirmStep){this.setUIStep(PinSetupState.CONFIRM)}}onPinSubmit(){this.getPinKeyboard().doSubmit()}onSetPinDone(){this.isSetupDoneButtonEnabled=true;this.setUIStep(PinSetupState.DONE)}getSkipButtonLabel(usingPinAsMainSignInFactor){return usingPinAsMainSignInFactor?"discoverPinSetupPinAsMainFactorSkip":"discoverPinSetupSkip"}onSkipButton(){this.authToken="";this.getPinKeyboard().resetState();if(this.uiStep===PinSetupState.CONFIRM){this.userActed("skip-button-in-flow")}else{this.userActed("skip-button-on-start")}}onBackButton(){this.getPinKeyboard().resetState();this.setUIStep(PinSetupState.START)}onNextButton(){this.onPinSubmit()}onDoneButton(){this.isSetupDoneButtonEnabled=false;this.authToken="";this.getPinKeyboard().resetState();this.userActed("done-button")}}customElements.define(PinSetup.is,PinSetup);