// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{CrRadioGroupElement}from"//resources/ash/common/cr_elements/cr_radio_group/cr_radio_group.js";import{CrToggleElement}from"//resources/ash/common/cr_elements/cr_toggle/cr_toggle.js";import{loadTimeData}from"//resources/ash/common/load_time_data.m.js";import{loginSyslog}from"//resources/ash/common/logging/webui_syslog_emitter.js";import{assert}from"//resources/js/assert.js";import{sendWithPromise}from"//resources/js/cr.js";import{afterNextRender}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeA11yOption}from"../components/oobe_a11y_option.js";import{Oobe}from"../cr_ui.js";class TestElementApi{element(){throw new Error("element() should be defined!")}isVisible(){const el=this.element();return!!el&&!el.hidden}isEnabled(){const el=this.element();if(!!el&&"disabled"in el){return!el.disabled}return true}}class ScreenElementApi extends TestElementApi{constructor(id){super();this.id=id;this.nextButton=undefined}element(){const el=document.getElementById(this.id);assert(el instanceof HTMLElement,this.id+" should be a valid HTMLElement");return el}clickNext(){assert(this.nextButton);this.nextButton.click()}shouldSkip(){return false}}class PolymerElementApi extends TestElementApi{constructor(parent,query){super();this.parent=parent;this.query=query}element(){const parentElement=this.parent.element();assert(parentElement instanceof HTMLElement,"Parent must be a valid HTMLElement");const polymerElement=parentElement.shadowRoot?.querySelector(this.query);return polymerElement instanceof HTMLElement?polymerElement:null}click(){assert(this.isVisible(),"Element must be visible before click");assert(this.isEnabled(),"Element must be enabled before click");const el=this.element();assert(el instanceof HTMLElement);el.click()}}class TextFieldApi extends PolymerElementApi{constructor(parent,query){super(parent,query)}typeInto(value){assert(this.isVisible(),"Text field must be visible");assert(this.isEnabled(),"Text field must be enabled");const el=this.element();assert(el instanceof HTMLElement&&"value"in el);el.value=value;el.dispatchEvent(new Event("input"));el.dispatchEvent(new Event("change"))}}class HidDetectionScreenTester extends ScreenElementApi{constructor(){super("hid-detection");this.nextButton=new PolymerElementApi(this,"#hid-continue-button")}touchscreenDetected(){const touchscreenRow=new PolymerElementApi(this,"#hid-touchscreen-entry");return touchscreenRow.isVisible()}mouseDetected(){const mouseTickIcon=new PolymerElementApi(this,"#mouse-tick");return mouseTickIcon.isVisible()}keyboardDetected(){const keyboardTickIcon=new PolymerElementApi(this,"#keyboard-tick");return keyboardTickIcon.isVisible()}getKeyboardNotDetectedText(){return loadTimeData.getString("hidDetectionKeyboardSearching")}getMouseNotDetectedText(){return loadTimeData.getString("hidDetectionMouseSearching")}getUsbKeyboardDetectedText(){return loadTimeData.getString("hidDetectionUSBKeyboardConnected")}getPointingDeviceDetectedText(){return loadTimeData.getString("hidDetectionPointingDeviceConnected")}getNextButtonName(){return loadTimeData.getString("hidDetectionContinue")}canClickNext(){assert(this.nextButton);return this.nextButton.isEnabled()}}class WelcomeScreenTester extends ScreenElementApi{constructor(){super("connect");this.demoModeConfirmationDialog=new PolymerElementApi(this,"#demoModeConfirmationDialog")}clickNext(){if(!this.nextButton){const mainStep=new PolymerElementApi(this,"#welcomeScreen");this.nextButton=new PolymerElementApi(mainStep,"#getStarted")}assert(this.nextButton);this.nextButton.click()}getDemoModeOkButtonName(){return loadTimeData.getString("enableDemoModeDialogConfirm")}}class NetworkScreenTester extends ScreenElementApi{constructor(){super("network-selection");this.nextButton=new PolymerElementApi(this,"#nextButton")}shouldSkip(){return loadTimeData.getBoolean("testapi_shouldSkipNetworkFirstShow")}}class UpdateScreenTester extends ScreenElementApi{constructor(){super("oobe-update")}}class EnrollmentScreenTester extends ScreenElementApi{constructor(){super("enterprise-enrollment")}}class UserCreationScreenTester extends ScreenElementApi{constructor(){super("user-creation");this.personalCrButton=new PolymerElementApi(this,"#selfButton");this.enrollCrButton=new PolymerElementApi(this,"#enrollButton");this.enrollTriageCrButton=new PolymerElementApi(this,"#triageEnrollButton");this.nextButton=new PolymerElementApi(this,"#nextButton");this.enrollNextButton=new PolymerElementApi(this,"#enrollTriageNextButton")}selectEnrollTriageButton(){this.enrollTriageCrButton.click()}selectPersonalUser(){this.personalCrButton.click()}selectForWork(){this.enrollCrButton.click()}clickEnrollNextButton(){this.enrollNextButton.click()}}class GaiaScreenTester extends ScreenElementApi{constructor(){super("gaia-signin");this.signinFrame=new PolymerElementApi(this,"#signin-frame-dialog");this.gaiaDialog=new PolymerElementApi(this.signinFrame,"#gaiaDialog");this.gaiaLoading=new PolymerElementApi(this,"#step-loading")}isReadyForTesting(){return this.isVisible()&&!this.gaiaLoading.isVisible()&&this.signinFrame.isVisible()&&this.gaiaDialog.isVisible()}}class SyncScreenTester extends ScreenElementApi{constructor(){super("sync-consent");this.loadedStep=new PolymerElementApi(this,"#syncConsentOverviewDialog")}isReadyForTesting(){return this.isVisible()&&this.loadedStep.isVisible()}}class PasswordSelectionScreenTester extends ScreenElementApi{constructor(){super("password-selection");this.localPasswordCrButton=new PolymerElementApi(this,"#localPasswordButton");this.gaiaPasswordCrButton=new PolymerElementApi(this,"#gaiaPasswordButton");this.nextButton=new PolymerElementApi(this,"#nextButton")}selectLocalPassword(){this.localPasswordCrButton.click()}selectGaiaPassword(){this.gaiaPasswordCrButton.click()}}class FingerprintScreenTester extends ScreenElementApi{constructor(){super("fingerprint-setup")}shouldSkip(){return!loadTimeData.getBoolean("testapi_isFingerprintSupported")}}class AiIntroScreenTester extends ScreenElementApi{constructor(){super("ai-intro")}shouldSkip(){return loadTimeData.getBoolean("testapi_shouldSkipAiIntro")}}class GeminiIntroScreenTester extends ScreenElementApi{constructor(){super("gemini-intro")}shouldSkip(){return loadTimeData.getBoolean("testapi_shouldSkipGeminiIntro")}}class MarketingOptInScreenTester extends ScreenElementApi{constructor(){super("marketing-opt-in");this.accessibilityButton=new PolymerElementApi(this,"#marketing-opt-in-accessibility-button");this.accessibilityStep=new PolymerElementApi(this,"#finalAccessibilityPage");this.accessibilityToggle=new PolymerElementApi(this,"#a11yNavButtonToggle");this.marketingOptInGameDeviceTitle=new PolymerElementApi(this,"#marketingOptInGameDeviceTitle")}shouldSkip(){return!loadTimeData.getBoolean("testapi_isBrandedBuild")}isAccessibilityStepReadyForTesting(){return this.accessibilityStep.isVisible()}isAccessibilityButtonVisible(){return this.accessibilityButton.isVisible()}isAccessibilityToggleOn(){const accessibilityToggle=this.accessibilityToggle.element();assert(accessibilityToggle instanceof OobeA11yOption);return accessibilityToggle.checked}isMarketingOptInGameDeviceTitleVisible(){return this.marketingOptInGameDeviceTitle.isVisible()}getAccessibilityButtonName(){return loadTimeData.getString("marketingOptInA11yButtonLabel")}getAccessibilityDoneButtonName(){return loadTimeData.getString("finalA11yPageDoneButtonTitle")}getGetStartedButtonName(){return loadTimeData.getString("marketingOptInScreenAllSet")}getCloudGamingDeviceTitle(){return loadTimeData.getString("marketingOptInScreenGameDeviceTitle")}}class ThemeSelectionScreenTester extends ScreenElementApi{constructor(){super("theme-selection");this.themeRadioButton=new PolymerElementApi(this,"#theme");this.lightThemeButton=new PolymerElementApi(this,"#lightThemeButton");this.darkThemeButton=new PolymerElementApi(this,"#darkThemeButton");this.autoThemeButton=new PolymerElementApi(this,"#autoThemeButton");this.textHeader=new PolymerElementApi(this,"#theme-selection-title")}isReadyForTesting(){return this.isVisible()&&this.lightThemeButton.isVisible()&&this.darkThemeButton.isVisible()&&this.autoThemeButton.isVisible()}selectLightTheme(){this.lightThemeButton.click()}selectDarkTheme(){this.darkThemeButton.click()}selectAutoTheme(){this.autoThemeButton.click()}getNameOfSelectedTheme(){const themeRadioButton=this.themeRadioButton.element();assert(themeRadioButton instanceof CrRadioGroupElement);return themeRadioButton.selected}getHeaderTextColor(){const el=this.textHeader.element();assert(el instanceof HTMLElement);return window.getComputedStyle(el).color}}class ConfirmSamlPasswordScreenTester extends ScreenElementApi{constructor(){super("saml-confirm-password");this.passwordInput=new TextFieldApi(this,"#passwordInput");this.confirmPasswordInput=new TextFieldApi(this,"#confirmPasswordInput");this.nextButton=new PolymerElementApi(this,"#next")}enterManualPasswords(password){this.passwordInput.typeInto(password);afterNextRender(assert(this.element()),(()=>{this.confirmPasswordInput.typeInto(password);afterNextRender(assert(this.element()),(()=>{this.clickNext()}))}))}}class PinSetupScreenTester extends ScreenElementApi{constructor(){super("pin-setup");this.skipButton=new PolymerElementApi(this,"#setupSkipButton");this.nextButton=new PolymerElementApi(this,"#nextButton");this.doneButton=new PolymerElementApi(this,"#doneButton");this.backButton=new PolymerElementApi(this,"#backButton");const pinSetupKeyboard=new PolymerElementApi(this,"#pinKeyboard");const pinKeyboard=new PolymerElementApi(pinSetupKeyboard,"#pinKeyboard");this.pinField=new TextFieldApi(pinKeyboard,"#pinInput");this.pinButtons={};for(let i=0;i<=9;i++){this.pinButtons[i.toString()]=new PolymerElementApi(pinKeyboard,"#digitButton"+i.toString())}}enterPin(pin){this.pinField.typeInto(pin)}pressPinDigit(digit){this.pinButtons[digit].click()}getSkipButtonName(){return loadTimeData.getString("discoverPinSetupSkip")}isInTabletMode(){return loadTimeData.getBoolean("testapi_isOobeInTabletMode")}}class EnrollmentSignInStep extends PolymerElementApi{constructor(parent){super(parent,"#step-signin");this.signInFrame=new PolymerElementApi(this,"#signin-frame");this.nextButton=new PolymerElementApi(this,"#primary-action-button");this.backButton=new PolymerElementApi(this,"#signin-back-button")}isReadyForTesting(){return this.isVisible()&&this.signInFrame.isVisible()&&this.nextButton.isVisible()}}class EnrollmentAttributeStep extends PolymerElementApi{constructor(parent){super(parent,"#step-attribute-prompt");this.skipButton=new PolymerElementApi(parent,"#attributesSkip")}isReadyForTesting(){return this.isVisible()&&this.skipButton.isVisible()}clickSkip(){this.skipButton.click()}}class EnrollmentSuccessStep extends PolymerElementApi{constructor(parent){super(parent,"#step-success");this.nextButton=new PolymerElementApi(parent,"#successDoneButton")}isReadyForTesting(){return this.isVisible()&&this.nextButton.isVisible()}clickNext(){this.nextButton.click()}}class EnrollmentErrorStep extends PolymerElementApi{constructor(parent){super(parent,"#step-error");this.retryButton=new PolymerElementApi(parent,"#errorRetryButton");this.errorMsgContainer=new PolymerElementApi(parent,"#errorMsg")}isReadyForTesting(){return this.isVisible()&&this.errorMsgContainer.isVisible()}canRetryEnrollment(){return this.retryButton.isVisible()&&this.retryButton.isEnabled()}clickRetryButton(){assert(this.canRetryEnrollment());this.retryButton.click()}getErrorMsg(){assert(this.isReadyForTesting());const el=this.errorMsgContainer.element();assert(el instanceof HTMLElement);return el.innerText}}class EnterpriseEnrollmentScreenTester extends ScreenElementApi{constructor(){super("enterprise-enrollment");this.signInStep=new EnrollmentSignInStep(this);this.attributeStep=new EnrollmentAttributeStep(this);this.successStep=new EnrollmentSuccessStep(this);this.errorStep=new EnrollmentErrorStep(this);this.enrollmentInProgressDlg=new PolymerElementApi(this,"#step-working")}isEnrollmentInProgress(){return this.enrollmentInProgressDlg.isVisible()}}class OfflineLoginScreenTester extends ScreenElementApi{constructor(){super("offline-login");this.nextButton=new PolymerElementApi(this,"#nextButton")}isReadyForTesting(){return this.isVisible()&&this.nextButton!==undefined&&this.nextButton.isVisible()}getEmailFieldName(){return loadTimeData.getString("offlineLoginEmail")}getPasswordFieldName(){return loadTimeData.getString("offlineLoginPassword")}getNextButtonName(){return loadTimeData.getString("offlineLoginNextBtn")}}class ErrorScreenTester extends ScreenElementApi{constructor(){super("error-message");this.offlineLink=new PolymerElementApi(this,"#error-offline-login-link");this.errorTitle=new PolymerElementApi(this,"#error-title");this.errorSubtitle=new PolymerElementApi(this,"#error-subtitle")}isReadyForTesting(){return this.isVisible()}isOfflineLinkVisible(){return this.offlineLink.isVisible()}getErrorTitle(){if(!this.isVisible()){return""}const el=this.errorTitle.element();assert(el instanceof HTMLElement);return el.innerText.trim()}getErrorReasons(){if(!this.isVisible()){return""}const el=this.errorSubtitle.element();assert(el instanceof HTMLElement);return el.innerText.trim()}clickSignInAsExistingUserLink(){this.offlineLink.click()}}class DemoPreferencesScreenTester extends ScreenElementApi{constructor(){super("demo-preferences")}getDemoPreferencesNextButtonName(){return loadTimeData.getString("demoPreferencesNextButtonLabel")}}class GuestTosScreenTester extends ScreenElementApi{constructor(){super("guest-tos");this.loadedStep=new PolymerElementApi(this,"#loaded");this.nextButton=new PolymerElementApi(this,"#acceptButton");this.googleEulaDialog=new PolymerElementApi(this,"#googleEulaDialog");this.crosEulaDialog=new PolymerElementApi(this,"#crosEulaDialog");this.googleEulaDialogLink=new PolymerElementApi(this,"#googleEulaLink");this.crosEulaDialogLink=new PolymerElementApi(this,"#crosEulaLink")}shouldSkip(){return loadTimeData.getBoolean("testapi_shouldSkipGuestTos")}isReadyForTesting(){return this.isVisible()&&this.loadedStep.isVisible()}getNextButtonName(){return loadTimeData.getString("guestTosAccept")}getEulaButtonName(){return loadTimeData.getString("guestTosOk")}isGoogleEulaDialogShown(){return this.googleEulaDialog.isVisible()}isCrosEulaDialogShown(){return this.crosEulaDialog.isVisible()}getGoogleEulaLinkName(){const googleEulaLink=this.googleEulaDialogLink.element();assert(googleEulaLink instanceof HTMLAnchorElement);return googleEulaLink.text.trim()}getCrosEulaLinkName(){const crosEulaLink=this.crosEulaDialogLink.element();assert(crosEulaLink instanceof HTMLAnchorElement);return crosEulaLink.text.trim()}}class GestureNavigationScreenTester extends ScreenElementApi{constructor(){super("gesture-navigation")}getNextButtonName(){return loadTimeData.getString("gestureNavigationIntroNextButton")}getSkipButtonName(){return loadTimeData.getString("gestureNavigationIntroSkipButton")}}class ConsolidatedConsentScreenTester extends ScreenElementApi{constructor(){super("consolidated-consent");this.loadedStep=new PolymerElementApi(this,"#loadedDialog");this.nextButton=new PolymerElementApi(this,"#acceptButton");this.readMoreButton=new PolymerElementApi(this.loadedStep,"#readMoreButton");this.recoveryToggle=new PolymerElementApi(this,"#recoveryOptIn");this.googleEulaDialog=new PolymerElementApi(this,"#googleEulaDialog");this.crosEulaDialog=new PolymerElementApi(this,"#crosEulaDialog");this.arcTosDialog=new PolymerElementApi(this,"#arcTosDialog");this.privacyPolicyDialog=new PolymerElementApi(this,"#privacyPolicyDialog");this.googleEulaLink=new PolymerElementApi(this,"#googleEulaLink");this.crosEulaLink=new PolymerElementApi(this,"#crosEulaLink");this.arcTosLink=new PolymerElementApi(this,"#arcTosLink");this.privacyPolicyLink=new PolymerElementApi(this,"#privacyPolicyLink")}shouldSkip(){return loadTimeData.getBoolean("testapi_shouldSkipConsolidatedConsent")}isReadyForTesting(){return this.isVisible()&&this.loadedStep.isVisible()}isReadMoreButtonShown(){return this.readMoreButton.element()!==null&&this.readMoreButton.isVisible()}getNextButtonName(){return loadTimeData.getString("consolidatedConsentAcceptAndContinue")}enableRecoveryToggle(){const recoveryToggle=this.recoveryToggle.element();assert(recoveryToggle instanceof CrToggleElement);recoveryToggle.checked=true}getEulaOkButtonName(){return loadTimeData.getString("consolidatedConsentOK")}isGoogleEulaDialogShown(){return this.googleEulaDialog.isVisible()}isCrosEulaDialogShown(){return this.crosEulaDialog.isVisible()}isArcTosDialogShown(){return this.arcTosDialog.isVisible()}isPrivacyPolicyDialogShown(){return this.privacyPolicyDialog.isVisible()}getGoogleEulaLinkName(){const googleEulaLink=this.googleEulaLink.element();assert(googleEulaLink instanceof HTMLAnchorElement);return googleEulaLink.text.trim()}getCrosEulaLinkName(){const crosEulaLink=this.crosEulaLink.element();assert(crosEulaLink instanceof HTMLAnchorElement);return crosEulaLink.text.trim()}getArcTosLinkName(){const arcTosLink=this.arcTosLink.element();assert(arcTosLink instanceof HTMLAnchorElement);return arcTosLink.text.trim()}getPrivacyPolicyLinkName(){const privacyPolicyLink=this.privacyPolicyLink.element();assert(privacyPolicyLink instanceof HTMLAnchorElement);return privacyPolicyLink.text.trim()}clickAcceptButton(){assert(this.nextButton);const el=this.nextButton.element();assert(el instanceof HTMLElement);el.click()}}class SmartPrivacyProtectionScreenTester extends ScreenElementApi{constructor(){super("smart-privacy-protection");this.noThanks=new PolymerElementApi(this,"#noThanksButton")}shouldSkip(){return!loadTimeData.getBoolean("testapi_isHPSEnabled")}isReadyForTesting(){return this.isVisible()&&this.noThanks.isVisible()}getNoThanksButtonName(){return loadTimeData.getString("smartPrivacyProtectionTurnOffButton")}}class CryptohomeRecoverySetupScreenTester extends ScreenElementApi{constructor(){super("cryptohome-recovery-setup")}}class LocalPasswordSetupScreenTester extends ScreenElementApi{constructor(){super("local-password-setup");this.passwordInput=new PolymerElementApi(this,"#passwordInput");this.firstInput=new TextFieldApi(this.passwordInput,"#firstInput");this.confirmInput=new TextFieldApi(this.passwordInput,"#confirmInput");this.nextButton=new PolymerElementApi(this,"#nextButton")}isReadyForTesting(){return this.isVisible()&&this.firstInput.isVisible()&&this.confirmInput.isVisible()}enterPassword(password){this.firstInput.typeInto(password);afterNextRender(assert(this.element()),(()=>{this.confirmInput.typeInto(password);afterNextRender(assert(this.element()),(()=>{assert(this.nextButton);this.nextButton.click()}))}))}enterPasswordToFirstInput(password){this.firstInput.typeInto(password)}enterPasswordToConfirmInput(password){this.confirmInput.typeInto(password)}isNextButtonEnabled(){return this.nextButton!==undefined&&this.nextButton.isEnabled()}}class PasswordFactorSuccessScreenTester extends ScreenElementApi{constructor(){super("factor-setup-success");this.doneButton=new PolymerElementApi(this,"#doneButton");this.nextButton=new PolymerElementApi(this,"#nextButton")}isDone(){assert(this.nextButton);return this.isVisible()&&(this.doneButton.isVisible()||this.nextButton.isVisible())}clickDone(){if(this.doneButton.isVisible()){this.doneButton.click();return}if(this.nextButton&&this.nextButton.isVisible()){this.nextButton.click()}}}class GaiaInfoScreenTester extends ScreenElementApi{constructor(){super("gaia-info");this.nextButton=new PolymerElementApi(this,"#nextButton");this.manualCredentialsButton=new PolymerElementApi(this,"#manualButton")}isCrossDeviceFeatureSuiteAllowed(){return loadTimeData.getBoolean("testapi_isCrossDeviceFeatureSuiteAllowed")}selectManualCredentials(){this.manualCredentialsButton.click()}}class ConsumerUpdateScreenTester extends ScreenElementApi{constructor(){super("consumer-update");this.skipButton=new PolymerElementApi(this,"#skipButton")}clickSkip(){this.skipButton.click()}}class ChoobeScreenTester extends ScreenElementApi{constructor(){super("choobe");this.skipButton=new PolymerElementApi(this,"#skipButton");this.nextButton=new PolymerElementApi(this,"#nextButton");this.choobeScreensList=new PolymerElementApi(this,"#screensList");this.touchpadScrollScreenButton=new PolymerElementApi(this.choobeScreensList,"#cr-button-touchpad-scroll");this.drivePinningScreenButton=new PolymerElementApi(this.choobeScreensList,"#cr-button-drive-pinning");this.displaySizeScreenButton=new PolymerElementApi(this.choobeScreensList,"#cr-button-display-size");this.themeSelectionScreenButton=new PolymerElementApi(this.choobeScreensList,"#cr-button-theme-selection");this.shouldSkipReceived=false;this.shouldBeSkipped=false}requestShouldSkip(){sendWithPromise("OobeTestApi.getShouldSkipChoobe").then((shouldBeSkipped=>this.setShouldBeSkipped(shouldBeSkipped)))}setShouldBeSkipped(shouldBeSkipped){this.shouldSkipReceived=true;this.shouldBeSkipped=shouldBeSkipped}isShouldSkipReceived(){return this.shouldSkipReceived}shouldSkip(){assert(this.isShouldSkipReceived(),"`shouldSkip()` should only be called after `requestShouldSkip()`"+"is called, and `isShouldSkippedReceived()` starts returning true");return this.shouldBeSkipped}isReadyForTesting(){return this.isVisible()}clickTouchpadScrollScreen(){this.touchpadScrollScreenButton.click()}clickDrivePinningScreen(){this.drivePinningScreenButton.click()}clickDisplaySizeScreen(){this.displaySizeScreenButton.click()}clickThemeSelectionScreen(){this.themeSelectionScreenButton.click()}isTouchpadScrollScreenVisible(){return this.touchpadScrollScreenButton.element()!==null&&this.touchpadScrollScreenButton.isVisible()}isDrivePinningScreenVisible(){return this.drivePinningScreenButton.element()!==null&&this.drivePinningScreenButton.isVisible()}isDisplaySizeScreenVisible(){return this.displaySizeScreenButton.element()!==null&&this.displaySizeScreenButton.isVisible()}isThemeSelectionScreenVisible(){return this.themeSelectionScreenButton.element()!==null&&this.themeSelectionScreenButton.isVisible()}isDrivePinningScreenChecked(){const el=this.drivePinningScreenButton.element();assert(el instanceof HTMLElement);return!!el.getAttribute("checked")}clickSkip(){this.skipButton.click()}}class ChoobeDrivePinningScreenTester extends ScreenElementApi{constructor(){super("drive-pinning");this.nextButton=new PolymerElementApi(this,"#nextButton");this.drivePinningToggle=new PolymerElementApi(this,"#drivePinningToggle");this.drivePinningSpaceInformation=new PolymerElementApi(this,"#spaceInformation")}isReadyForTesting(){return this.isVisible()&&this.drivePinningToggle.isVisible()&&this.drivePinningSpaceInformation.isVisible()}toggleFileSync(){this.drivePinningToggle.click()}isFileSyncEnabled(){const drivePinningToggle=this.drivePinningToggle.element();assert(drivePinningToggle instanceof CrToggleElement);return!!drivePinningToggle.checked}getSpaceInformationString(){const el=this.drivePinningSpaceInformation.element();assert(el instanceof HTMLElement);return el.innerText}}class ChoobeTouchpadScrollScreenTester extends ScreenElementApi{constructor(){super("touchpad-scroll");this.nextButton=new PolymerElementApi(this,"#nextButton");this.shouldSkipReceived=false;this.shouldBeSkipped=false}requestShouldSkip(){sendWithPromise("OobeTestApi.getShouldSkipTouchpadScroll").then((shouldBeSkipped=>this.setShouldBeSkipped(shouldBeSkipped)))}setShouldBeSkipped(shouldBeSkipped){this.shouldSkipReceived=true;this.shouldBeSkipped=shouldBeSkipped}isShouldSkipReceived(){return this.shouldSkipReceived}shouldSkip(){assert(this.isShouldSkipReceived(),"`shouldSkip()` should only be called after `requestShouldSkip()`"+"is called, and `isShouldSkippedReceived()` starts returning true");return this.shouldBeSkipped}isReadyForTesting(){return this.isVisible()}}class ChoobeDisplaySizeTester extends ScreenElementApi{constructor(){super("display-size");this.nextButton=new PolymerElementApi(this,"#nextButton")}shouldSkip(){return loadTimeData.getBoolean("testapi_shouldSkipDisplaySize")}isReadyForTesting(){return this.isVisible()}}class HwDataCollectionScreenTester extends ScreenElementApi{constructor(){super("hw-data-collection");this.nextButton=new PolymerElementApi(this,"#acceptButton")}shouldSkip(){return loadTimeData.getBoolean("testapi_shouldSkipHwDataCollection")}isReadyForTesting(){return this.isVisible()}}class DeviceUseCaseScreenTester extends ScreenElementApi{constructor(){super("categories-selection");this.loadingStep=new PolymerElementApi(this,"#progressDialog");this.overviewStep=new PolymerElementApi(this,"#categoriesDialog");this.skipButton=new PolymerElementApi(this,"#skipButton");this.nextButton=new PolymerElementApi(this,"#nextButton")}isReadyForTesting(){return this.isVisible()&&this.overviewStep.isVisible()}}class PersonalizedRecommendAppsScreenTester extends ScreenElementApi{constructor(){super("personalized-apps");this.loadingStep=new PolymerElementApi(this,"#progressDialog");this.overviewStep=new PolymerElementApi(this,"#personalizedRecommendDialog");this.skipButton=new PolymerElementApi(this,"#skipButton");this.nextButton=new PolymerElementApi(this,"#nextButton")}isReadyForTesting(){return this.isVisible()&&this.overviewStep.isVisible()}}class SplitModifierKeyboardInfoScreenTester extends ScreenElementApi{constructor(){super("split-modifier-keyboard-info");this.shouldSkipReceived=false;this.shouldBeSkipped=false}requestShouldSkip(){sendWithPromise("OobeTestApi.getShouldSkipSplitModifierScreen").then((shouldBeSkipped=>this.setShouldBeSkipped(shouldBeSkipped)))}setShouldBeSkipped(shouldBeSkipped){this.shouldSkipReceived=true;this.shouldBeSkipped=shouldBeSkipped}isShouldSkipReceived(){return this.shouldSkipReceived}shouldSkip(){return loadTimeData.getBoolean("testapi_shouldSkipSplitModifierKeyboardInfo")||this.shouldBeSkipped}isReadyForTesting(){return this.isVisible()}}export class OobeApiProvider{constructor(){this.screens={HIDDetectionScreen:new HidDetectionScreenTester,WelcomeScreen:new WelcomeScreenTester,NetworkScreen:new NetworkScreenTester,UpdateScreen:new UpdateScreenTester,EnrollmentScreen:new EnrollmentScreenTester,UserCreationScreen:new UserCreationScreenTester,GaiaScreen:new GaiaScreenTester,SyncScreen:new SyncScreenTester,PasswordSelectionScreen:new PasswordSelectionScreenTester,FingerprintScreen:new FingerprintScreenTester,AiIntroScreen:new AiIntroScreenTester,GeminiIntroScreen:new GeminiIntroScreenTester,MarketingOptInScreen:new MarketingOptInScreenTester,ConfirmSamlPasswordScreen:new ConfirmSamlPasswordScreenTester,PinSetupScreen:new PinSetupScreenTester,EnterpriseEnrollmentScreen:new EnterpriseEnrollmentScreenTester,GuestTosScreen:new GuestTosScreenTester,ErrorScreen:new ErrorScreenTester,OfflineLoginScreen:new OfflineLoginScreenTester,DemoPreferencesScreen:new DemoPreferencesScreenTester,ThemeSelectionScreen:new ThemeSelectionScreenTester,GestureNavigation:new GestureNavigationScreenTester,ConsolidatedConsentScreen:new ConsolidatedConsentScreenTester,SmartPrivacyProtectionScreen:new SmartPrivacyProtectionScreenTester,CryptohomeRecoverySetupScreen:new CryptohomeRecoverySetupScreenTester,LocalPasswordSetupScreen:new LocalPasswordSetupScreenTester,PasswordFactorSuccessScreen:new PasswordFactorSuccessScreenTester,GaiaInfoScreen:new GaiaInfoScreenTester,ConsumerUpdateScreen:new ConsumerUpdateScreenTester,ChoobeScreen:new ChoobeScreenTester,ChoobeDrivePinningScreen:new ChoobeDrivePinningScreenTester,ChoobeTouchpadScrollScreen:new ChoobeTouchpadScrollScreenTester,ChoobeDisplaySizeScreen:new ChoobeDisplaySizeTester,HWDataCollectionScreen:new HwDataCollectionScreenTester,DeviceUseCaseScreen:new DeviceUseCaseScreenTester,PersonalizedRecommendAppsScreen:new PersonalizedRecommendAppsScreenTester,SplitModifierKeyboardInfoScreen:new SplitModifierKeyboardInfoScreenTester};this.loginWithPin=function(username,pin){chrome.send("OobeTestApi.loginWithPin",[username,pin])};this.advanceToScreen=function(screen){chrome.send("OobeTestApi.advanceToScreen",[screen])};this.skipToLoginForTesting=function(){chrome.send("OobeTestApi.skipToLoginForTesting")};this.skipPostLoginScreens=function(){chrome.send("OobeTestApi.skipPostLoginScreens")};this.loginAsGuest=function(){chrome.send("OobeTestApi.loginAsGuest")};this.showGaiaDialog=function(){chrome.send("OobeTestApi.showGaiaDialog")};this.getBrowseAsGuestButtonName=function(){return loadTimeData.getString("testapi_browseAsGuest")};this.getCurrentScreenName=function(){const currentScreen=Oobe.getInstance().currentScreen;return currentScreen?currentScreen.id.trim():"none"};this.getCurrentScreenStep=function(){const currentScreen=Oobe.getInstance().currentScreen;if(currentScreen===null){return"none"}const step=currentScreen.getAttribute("multistep");if(step===null){return"default"}return step.trim()};this.getOobeActiveDialog=function(){const adaptiveDialogs=Oobe.getInstance().currentScreen?.shadowRoot?.querySelectorAll("oobe-adaptive-dialog");if(adaptiveDialogs){for(const dialog of adaptiveDialogs){if(!dialog.hidden){return dialog}}}const loadingDialogs=Oobe.getInstance().currentScreen?.shadowRoot?.querySelectorAll("oobe-loading-dialog");if(loadingDialogs){for(const dialog of loadingDialogs){if(!dialog.hidden){const activeDialog=dialog.shadowRoot?.querySelector("oobe-adaptive-dialog");return activeDialog?activeDialog:null}}}return null};this.findActiveOobeDialogSlotsByName=function(slotName){const dialog=this.getOobeActiveDialog();if(dialog===null){return[]}if(dialog.children===undefined||dialog.children===null){return[]}const result=[];for(const child of dialog.children){if(!(child instanceof HTMLElement)){continue}if(child.hidden){continue}const slot=child.slot;if(slot===undefined){continue}if(typeof slot!=="string"){continue}if(slot.toLowerCase().trim()===slotName.toLowerCase().trim()){result.push(child)}}return result};this.combineTextOfAdaptiveDialogSlots=function(slotName){const slots=this.findActiveOobeDialogSlotsByName(slotName);let result="";for(const slot of slots){result=result.concat(slot.innerText.trim().concat("\n"))}return result};this.getOobeActiveDialogTitleText=function(){return this.combineTextOfAdaptiveDialogSlots("title")};this.getOobeActiveDialogSubtitleText=function(){return this.combineTextOfAdaptiveDialogSlots("subtitle")};this.getOobeActiveDialogContentText=function(){return this.combineTextOfAdaptiveDialogSlots("content")};this.isMetricsClientIdAvailable=function(){return this.metricsClientID!==""};this.requestMetricsClientID=function(){sendWithPromise("OobeTestApi.getMetricsClientID").then((clientID=>this.onMetricsClientIdReceived(clientID)))};this.getMetricsClientID=function(){assert(this.isMetricsClientIdAvailable(),"`getMetricsClientID()` should only be called after "+"`requestMetricsClientID()` is called, and "+"`isMetricsClientIdAvailable()` starts returning true");const id=this.metricsClientID;this.metricsClientID="";return id};this.emitLoginSyslog=function(message){loginSyslog(message)}}onMetricsClientIdReceived(clientID){this.metricsClientID=clientID}}