import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2021 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="cr-shared-style oobe-common-styles cros-color-overrides">cr-button{--cr-button-height:var(--oobe-button-height);border-radius:var(--oobe-button-radius);margin:0 4px}:host ::slotted(*),.fallback{font-family:var(--oobe-button-font-family);font-size:var(--oobe-button-font-size);font-weight:var(--oobe-button-font-weight)}:host([disabled]){pointer-events:none}</style>
<cr-button id="button" on-click="onClick" disabled="[[disabled]]"
    inverse$="[[inverse]]" aria-label$="[[labelForAriaText_]]"
    border$="[[border]]">
  <div id="container"
      class="flex layout horizontal center center-justified self-stretch">
    <slot name="text">
      <template is="dom-if" if="[[textKey]]">
        <div class="fallback">[[i18nDynamic(locale, textKey)]]</div>
      </template>
    </slot>
  </div>
</cr-button>
<!--_html_template_end_-->`;
}
