import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2021 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<!--
  Simple OOBE dialog which should be used for OOBE UI elements.
  It has correct size and padding. It can display top left icon, and has
  several parts: content area; and buttons containers at the top for back
  navigation and for other buttons at the bottom.

  Please include oobe-dialog-host-styles shared style if you use oobe-content-dialog.

  Example:
    <style include="oobe-dialog-host-styles"></style>
    <oobe-content-dialog>
      <div slot="content">
        ...
      </div>
      <div slot="back-navigation">
        ...
      </div>
      <div slot="bottom-buttons">
        ...
      </div>
    </oobe-content-dialog>

  For single-DPI image |oobe-icon| class should be used. To select between two
  images of different DPI, |oobe-icon-1x| and |oobe-icon-2x| should be used
  instead. For example:

      <iron-icon icon="icon1" ... slot="oobe-icon" class="oobe-icon-1x">
      <iron-icon icon-"icon2" ... slot="oobe-icon" class="oobe-icon-2x">

  Attributes:
    no-lazy           - prevents lazy instantiation of the dialog.
-->

<style include="oobe-dialog-host-styles cr-shared-style">:host{color:var(--oobe-text-color);font-family:var(--oobe-default-font-family);font-size:var(--oobe-default-font-size);font-weight:var(--oobe-default-font-weight);height:var(--oobe-adaptive-dialog-height);line-height:var(--oobe-default-line-height);width:var(--oobe-adaptive-dialog-width);--oobe-adaptive-dialog-content-width:calc(var(--oobe-adaptive-dialog-width) - 2 * var(--oobe-adaptive-dialog-content-padding))}:host([isGaia]){--gaia-horizontal-padding-offset:20px}@media (orientation:portrait){:host{--oobe-adaptive-dialog-item-alignment:center}}@media (orientation:landscape){:host{--oobe-adaptive-dialog-item-alignment:unset}}#mainContainer{align-items:var(--oobe-adaptive-dialog-item-alignment);flex-direction:column;margin-inline-end:var(--oobe-adaptive-dialog-content-padding);margin-inline-start:var(--oobe-adaptive-dialog-content-padding)}:host([isGaia]) #mainContainer{--oobe-content-dialog-content-padding:calc(var(--oobe-adaptive-dialog-content-padding) - var(--gaia-horizontal-padding-offset));margin-inline-end:var(--oobe-content-dialog-content-padding);margin-inline-start:var(--oobe-content-dialog-content-padding)}:host-context(.jelly-enabled) #mainContainer{border-radius:var(--oobe-container-border-radius);overflow:hidden}:host([fullscreen]) #mainContainer{margin-inline-end:0;margin-inline-start:0;overflow:visible}#scrollContainer{overflow-y:auto;padding-bottom:0;padding-top:0}#contentContainer{width:var(--oobe-adaptive-dialog-content-width)}:host([isGaia]) #contentContainer{width:calc(var(--oobe-adaptive-dialog-content-width) + 2 * var(--gaia-horizontal-padding-offset))}:host([fullscreen]) #contentContainer{width:100%}.vertical-mode-centering{align-items:var(--oobe-adaptive-dialog-item-alignment);display:flex;flex-direction:column}.buttons-common{min-height:calc(var(--oobe-button-height) + 2px);z-index:1}:host([no-buttons]) .buttons-common{display:none}.bottom-buttons-container{padding-bottom:var(--oobe-adaptive-dialog-buttons-vertical-padding);padding-inline-end:var(--oobe-adaptive-dialog-buttons-horizontal-padding);padding-inline-start:var(--oobe-adaptive-dialog-buttons-horizontal-padding);padding-top:var(--oobe-adaptive-dialog-buttons-vertical-padding)}.back-button-container{padding-bottom:var(--oobe-adaptive-dialog-back-button-vertical-padding);padding-inline-end:var(--oobe-adaptive-dialog-back-button-horizontal-padding);padding-inline-start:var(--oobe-adaptive-dialog-back-button-horizontal-padding);padding-top:var(--oobe-adaptive-dialog-back-button-vertical-padding)}#oobe-icon-div ::slotted(hd-iron-icon),#oobe-icon-div ::slotted(iron-icon){--iron-icon-height:var(--oobe-adaptive-dialog-icon-size);--iron-icon-width:var(--oobe-adaptive-dialog-icon-size);--iron-icon-fill-color:var(--oobe-adaptive-dialog-icon-fill-color)}</style>
<cr-lazy-render id="lazy">
  <template>
    <div class="buttons-common back-button-container">
      <slot name="back-navigation"></slot>
    </div>
    <div id="mainContainer" class="layout vertical flex">
      <div id="scrollContainer" class="layout vertical flex scrollable">
        <div id="contentContainer" class="layout vertical flex">
          <slot name="content"></slot>
        </div>
      </div>
    </div>
    <div class="buttons-common bottom-buttons-container
        vertical-mode-centering">
      <slot class="layout horizontal end-justified" name="bottom-buttons">
      </slot>
    </div>
  </template>
</cr-lazy-render>
<!--_html_template_end_-->`;
}
