import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2015 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<!--
  Material design buttons that mimic GAIA's buttons.

  Example:
    <gaia-button link></gaia-button>

  Attributes:
    'link' - there are two kinds of button: regular blue button and a button
             that looks more like a link.
    'disabled' - button is disabled when the attribute is set.
-->
<style include="cros-color-overrides">:host{display:inline-block}cr-button#button{--cr-button-height:var(--oobe-button-height);border-radius:var(--oobe-button-radius);font-family:var(--oobe-button-font-family);font-size:var(--oobe-button-font-size);font-weight:var(--oobe-button-font-weight);line-height:var(--oobe-button-line-height)}:host([link]) cr-button:focus{background-color:var(--cros-button-active-shadow-color-ambient-primary)}:host-context(.focus-outline-visible):host([link]) cr-button:focus{font-weight:500}:host([link]) cr-button[disabled]{color:var(--cros-color-disabled)}</style>
<cr-button id="button" disabled="[[disabled]]" on-click="onClick"
    noink$="[[link]]">
  <slot></slot>
</cr-button>
<!--_html_template_end_-->`;
}
