import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2021 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles cr-shared-style">#saml-back-button{--cr-icon-button-margin-end:0;--cr-icon-button-margin-start:0}#saml-notice-container,#saml-footer-container{align-items:center;background:white;box-shadow:0 2px 2px 0 rgba(0,0,0,0.17);display:flex;min-height:0}#saml-notice-container{border-bottom:1px solid var(--cros-sys-separator);height:44px}#saml-footer-container{border-top:1px solid var(--cros-sys-separator);height:58px}#saml-notice-recording-indicator{padding-inline-end:10px;padding-inline-start:10px}#signin-frame{display:flex;overflow:hidden;position:relative}#signin-frame-container{z-index:10}#signin-frame-container:not([hideshadows]) #signin-frame.can-scroll:not(.is-scrolled):not(.scrolled-to-bottom)::before,#signin-frame-container:not([hideshadows]) #signin-frame.can-scroll.is-scrolled:not(.scrolled-to-bottom)::before,#signin-frame-container:not([hideshadows]) #signin-frame.is-scrolled.scrolled-to-bottom::before{content:'';height:100%;opacity:0.3;pointer-events:none;position:absolute;width:100%;--scroll-shadow-bottom-bg:linear-gradient(0deg,var(--google-grey-400) 0,transparent 8px);--scroll-shadow-top-bg:linear-gradient(180deg,var(--google-grey-400) 0,transparent 8px)}#signin-frame-container:not([hideshadows]) #signin-frame.can-scroll:not(.is-scrolled):not(.scrolled-to-bottom)::before{background:var(--scroll-shadow-bottom-bg)}#signin-frame-container:not([hideshadows]) #signin-frame.can-scroll.is-scrolled:not(.scrolled-to-bottom)::before{background:var(--scroll-shadow-bottom-bg),var(--scroll-shadow-top-bg)}#signin-frame-container:not([hideshadows]) #signin-frame.is-scrolled.scrolled-to-bottom::before{background:var(--scroll-shadow-top-bg)}#sshWarning{color:var(--cros-sys-error);text-align:center}#change-account{padding-inline-end:8px;padding-inline-start:8px}</style>
<link rel="stylesheet" href="oobe_popup_overlay.css">
<!-- As this dialog have pre-loading logic that require access to elements,
      dialog is marked as no-lazy. -->
<oobe-content-dialog role="dialog" id="gaiaDialog" no-lazy
    no-buttons$="[[isSamlSsoVisible]]" fullscreen$="[[isSamlSsoVisible]]"
    isGaia$="[[!isSamlSsoVisible]]">
  <div slot="content" id="signin-frame-container"
      hideshadows$="[[isPopUpOverlayVisible]]"
      class="flex layout vertical">
    <div id="saml-notice-container" class="layout horizontal center"
        hidden$="[[!isSamlSsoVisible]]">
      <cr-icon-button id="saml-back-button" iron-icon="cr:arrow-back"
          on-click="close" hidden="[[samlBackButtonHidden]]">
      </cr-icon-button>
      <div class="flex layout horizontal center-justified">
        <span id="saml-notice-recording-indicator"
            hidden$="[[!videoEnabled]]">
          <img src="chrome://theme/IDR_TAB_RECORDING_INDICATOR">
        </span>
        <span id="saml-notice-message">
          [[getSamlNoticeMessage(locale, videoEnabled, authDomain)]]
        </span>
      </div>
    </div>
    <h3 id="sshWarning" hidden>
      [[i18nDynamic(locale, 'sshWarningLogin')]]
    </h3>
    <webview id="signin-frame" class="flex" name="[[webviewName]]">
    </webview>
    <div id="saml-footer-container" hidden="[[!isDefaultSsoProvider]]"
        class="layout horizontal end-justified">
      <div>[[i18nDynamic(locale, 'samlChangeProviderMessage')]]</div>
      <oobe-text-button id="change-account"
          text-key="samlChangeProviderButton"
          on-click="onChangeSigninProviderClicked">
      </oobe-text-button>
    </div>
  </div>
  <div slot="back-navigation" hidden$="[[navigationHidden]]">
    <oobe-back-button id="signin-back-button"
        disabled="[[!navigationEnabled]]"
        hidden="[[isBackButtonHidden(navigationHidden,
                                     hideBackButtonIfCantGoBack, canGoBack)]]"
        on-click="onBackButtonClicked">
    </oobe-back-button>
  </div>
  <div slot="bottom-buttons" hidden$="[[navigationHidden]]"
      class="layout horizontal end-justified">
    <!-- Quick start button visibility is controlled by the corresponding
      feature flag -->
    <quick-start-entry-point
      id="quick-start-signin-button"
      on-click="onQuickStartClicked"
      hidden="[[!isQuickStartEnabled]]"
      quick-start-text-key="signinScreenQuickStart">
    </quick-start-entry-point>
    <!-- Secondary action button appearance is controlled by the corresponding
      info provided by GAIA -->
    <oobe-text-button id="secondary-action-button"
        label-for-aria="[[secondaryActionButtonLabel]]"
        on-click="onSecondaryActionButtonClicked"
        hidden$="[[!secondaryActionButtonLabel]]"
        disabled="[[!isButtonEnabled(navigationEnabled,
                                     secondaryActionButtonEnabled)]]">
      <div slot="text">[[secondaryActionButtonLabel]]</div>
    </oobe-text-button>
    <!-- Primary action button appearance is controlled by the corresponding
      info provided by GAIA. During the enrollment flow users on the client are
      able to choose between kiosk and enterprise enrollment. To address this
      case primary button text is updated locally and additional
      additional-primary-action-button button is shown. -->
    <oobe-text-button id="additional-primary-action-button"
        label-for-aria="[[clientAdditionalPrimaryActionButtonLabel]]"
        on-click="onAdditionalPrimaryActionButtonClicked"
        hidden$="[[!clientAdditionalPrimaryActionButtonLabel]]"
        disabled="[[!isButtonEnabled(navigationEnabled,
                                     primaryActionButtonEnabled)]]">
      <div slot="text">[[clientAdditionalPrimaryActionButtonLabel]]</div>
    </oobe-text-button>
    <oobe-text-button id="primary-action-button"
        label-for-aria="[[clientPrimaryActionButtonLabel]]"
        on-click="onPrimaryActionButtonClicked"
        hidden$="[[!clientPrimaryActionButtonLabel]]"
        disabled="[[!isButtonEnabled(navigationEnabled,
                                     primaryActionButtonEnabled)]]"
        inverse>
      <div slot="text">[[clientPrimaryActionButtonLabel]]</div>
    </oobe-text-button>
  </div>
</oobe-content-dialog>
<div class="popup-overlay"
    hidden="[[!isPopUpOverlayVisible]]">
</div>
<!--_html_template_end_-->`;
}
