// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { dedupingMixin } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { traceFirstScreenShown } from '../../oobe_trace.js';
import { OobeBaseMixin } from './oobe_base_mixin.js';
export const OobeDialogHostMixin = dedupingMixin((superClass) => {
    const superClassBase = OobeBaseMixin(superClass);
    class OobeDialogHostMixinInternal extends superClassBase {
        /**
         * Trigger onBeforeShow for all children.
         */
        onBeforeShow(...data) {
            super.onBeforeShow(data);
            traceFirstScreenShown();
            /* Triggers onBeforeShow for descendants. */
            const dialogs = this.shadowRoot?.querySelectorAll('oobe-dialog,oobe-adaptive-dialog,oobe-content-dialog,' +
                'gaia-dialog,oobe-loading-dialog') ||
                [];
            for (const dialog of dialogs) {
                // Trigger show() if element is an oobe-dialog
                if ('onBeforeShow' in dialog &&
                    typeof dialog.onBeforeShow === 'function') {
                    dialog.onBeforeShow(data);
                }
            }
        }
    }
    return OobeDialogHostMixinInternal;
});
