// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { I18nMixin } from '//resources/ash/common/cr_elements/i18n_mixin.js';
import { loadTimeData } from '//resources/js/load_time_data.js';
import { dedupingMixin } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export const OobeI18nMixin = dedupingMixin((superClass) => {
    const superClassBase = I18nMixin(superClass);
    class OobeI18nMixinInternal extends superClassBase {
        static get properties() {
            return {
                locale: {
                    type: String,
                    value: '',
                },
            };
        }
        ready() {
            super.ready();
            this.classList.add('i18n-dynamic');
        }
        /**
         * Similar to 'i18nAdvanced', with an unused |locale| parameter used to
         * trigger updates when |this.locale| changes.
         * @param locale The UI language used.
         * @param id The ID of the string to translate.
         * @return A translated, sanitized, substituted string.
         */
        i18nAdvancedDynamic(_locale, id, opts) {
            return this.i18nAdvanced(id, opts);
        }
        i18nUpdateLocale() {
            this.locale = loadTimeData.getString('app_locale');
            const matches = this.shadowRoot?.querySelectorAll('.i18n-dynamic');
            for (const child of matches || []) {
                if ('i18nUpdateLocale' in child &&
                    typeof (child.i18nUpdateLocale) === 'function') {
                    child.i18nUpdateLocale();
                }
            }
        }
    }
    return OobeI18nMixinInternal;
});
