// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { dedupingMixin } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export const OobeScrollableMixin = dedupingMixin((superClass) => {
    class OobeScrollableMixinInternal extends superClass {
        /**
         * Init observers to keep track of the scrollable element size changes.
         */
        initScrollableObservers(scrollableElementParam, ...sizeChangeObservableElements) {
            if (!(scrollableElementParam instanceof HTMLElement) ||
                this.scrollableElement) {
                return;
            }
            this.scrollableElement = scrollableElementParam;
            this.resizeObserver =
                new ResizeObserver(this.applyScrollClassTags.bind(this));
            this.scrollableElement.addEventListener('scroll', this.applyScrollClassTags.bind(this));
            this.resizeObserver.observe(this.scrollableElement);
            for (const elem of sizeChangeObservableElements) {
                this.resizeObserver.observe(elem);
            }
        }
        /**
         * Applies the class tags to topScrollContainer that control the
         * shadows.
         */
        applyScrollClassTags() {
            const el = this.scrollableElement;
            if (el instanceof HTMLElement) {
                el.classList.toggle('can-scroll', el.clientHeight < el.scrollHeight);
                el.classList.toggle('is-scrolled', el.scrollTop > 0);
                el.classList.toggle('scrolled-to-bottom', el.scrollTop + el.clientHeight >= el.scrollHeight);
            }
        }
        /**
         * Scroll to the bottom of scrollable element.
         */
        scrollToBottom() {
            if (this.scrollableElement instanceof HTMLElement) {
                this.scrollableElement.scrollTop =
                    this.scrollableElement.scrollHeight;
            }
        }
    }
    return OobeScrollableMixinInternal;
});
