import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2021 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-common-styles cros-color-overrides">:host{display:flex;min-height:0;width:100%}#elementBox{width:inherit}cr-toggle{align-self:center;margin-inline-end:12px}#titleContainer ::slotted(*){color:var(--cros-text-color-primary)}:host-context(.jelly-enabled) #titleContainer ::slotted(*){color:var(--oobe-text-color)}.display-value ::slotted(*){color:var(--cros-color-secondary)}:host-context(.jelly-enabled) .display-value ::slotted(*){color:var(--oobe-subheader-text-color)}</style>
<div id="elementBox" class="layout horizontal">
  <div class="flex layout vertical center-justified">
    <div id="titleContainer">
      <slot name="title"></slot>
    </div>
    <div class="display-value" hidden="[[!checked]]" aria-hidden="true">
      <slot name="checked-value"></slot>
    </div>
    <div class="display-value" hidden="[[checked]]" aria-hidden="true">
      <slot  name="unchecked-value"></slot>
    </div>
  </div>
  <cr-toggle id="button" checked="{{checked}}"
      aria-labelledby="titleContainer"
      aria-label$="[[labelForAria]]">
  </cr-toggle>
</div>
<!--_html_template_end_-->`;
}
