import '//resources/polymer/v3_0/iron-iconset-svg/iron-iconset-svg.js';
import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
const template = html `<!--
Copyright 2019 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<iron-iconset-svg name="oobe-16" size="16">
  <svg>
    <defs>
      <g id="positive" fill-rule="nonzero">
        <path d="M9.20078 0.799805H6.80078V6.7998H0.800781V9.19981H6.80078V15.1998H9.20078V9.19981H15.2008V6.7998H9.20078V0.799805Z">
        </path>
      </g>
      <g id="negative" fill-rule="nonzero">
        <rect width="14" height="2" x="1" y="7">
        </rect>
      </g>
    </defs>
  </svg>
</iron-iconset-svg>

<iron-iconset-svg name="oobe-20" size="20">
  <svg>
    <defs>
      <g id="button-arrow-forward" fill-rule="nonzero">
        <path d="M6.66669 13.825L10.7872 10L6.66669 6.175L7.93524 5L13.3334 10L7.93524 15L6.66669 13.825Z">
        </path>
      </g>
      <g id="quick-start-android-device" fill-rule="evenodd" viewBox="0 0 12 18">
        <path clip-rule="evenodd" d="M10 0.01L2 0C0.9 0 0 0.9 0 2V16C0 17.1 0.9 18 2 18H10C11.1 18 12 17.1 12 16V2C12 0.9 11.1 0.01 10 0.01ZM10 16H2V15H10V16ZM10 13H2V5H10V13ZM2 3V2H10V3H2Z"></path>
      </g>
      <g id="quick-start-camera-icon" fill-rule="evenodd" viewBox="0 0 15 14">
        <path d="M7.5 10.3684C8.88071 10.3684 10 9.24912 10 7.86841C10 6.4877 8.88071 5.36841 7.5 5.36841C6.11929 5.36841 5 6.4877 5 7.86841C5 9.24912 6.11929 10.3684 7.5 10.3684Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M9.5 0.368408H5.5L3.5 2.36841H1.5C0.947715 2.36841 0.5 2.81612 0.5 3.36841V12.3684C0.5 12.9207 0.947716 13.3684 1.5 13.3684H13.5C14.0523 13.3684 14.5 12.9207 14.5 12.3684V3.36841C14.5 2.81612 14.0523 2.36841 13.5 2.36841H11.5L9.5 0.368408ZM2.5 4.36841H12.5V11.3684H2.5V4.36841Z"></path>
      </g>
      <g id="quick-start-bluetooth-icon" fill-rule="evenodd" viewBox="0 0 21 21">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M11.0993 10.8236L14.2706 7.63955C14.6174 7.2905 14.6164 6.72954 14.2685 6.38165L10.4501 2.56335C10.0921 2.22908 9.53129 2.24871 9.19813 2.60794C9.04593 2.77224 8.96073 2.98826 8.96026 3.2118L8.96943 8.68535L5.53285 5.24888C5.18495 4.90099 4.63432 4.90191 4.28759 5.25097C3.94086 5.60002 3.94178 6.15248 4.28968 6.50036L8.60876 10.8278L4.30419 15.1612C3.95746 15.5102 3.95839 16.0627 4.30629 16.4106C4.65419 16.7584 5.20481 16.7575 5.55155 16.4085L8.97659 12.9605L8.98578 18.4426C8.9866 18.9313 9.38201 19.3258 9.86826 19.325C10.091 19.3246 10.3061 19.2393 10.4693 19.086L14.2834 15.2464C14.6301 14.8974 14.6292 14.3364 14.2813 13.9885L11.0993 10.8236ZM10.6621 12.7962L12.4864 14.6205L10.6682 16.4509L10.6621 12.7962ZM10.6493 5.18928L12.4737 7.01358L10.6554 8.84399L10.6493 5.18928Z"></path>
        <path d="M3.97359 9.51686L4.85374 10.3941C5.09679 10.6363 5.09744 11.0297 4.85521 11.2727L3.97801 12.1529C3.73577 12.3959 3.34237 12.3966 3.09933 12.1544L2.21918 11.2772C1.97613 11.0349 1.97547 10.6415 2.2177 10.3985L3.09491 9.51833C3.33714 9.27528 3.73054 9.27462 3.97359 9.51686Z"></path>
        <path d="M17.3537 10.3731L16.4736 9.49591C16.2305 9.25368 15.8371 9.25434 15.5949 9.49738L14.7177 10.3775C14.4755 10.6206 14.4761 11.014 14.7192 11.2562L15.5993 12.1334C15.8424 12.3757 16.2358 12.375 16.478 12.1319L17.3552 11.2518C17.5974 11.0087 17.5968 10.6154 17.3537 10.3731Z"></path>
      </g>
      <g id="quick-start-wifi" viewBox="0 0 28 24" fill-rule="evenodd">
        <path clip-rule="evenodd" d="M27.3327 6.82473C27.7768 6.25416 27.6543 5.41959 27.0693 5.00669C25.0427 3.57653 20.3461 0.800049 14.0004 0.800049C7.65585 0.800049 2.95812 3.57653 0.931461 5.00669C0.34652 5.41959 0.22395 6.25416 0.668116 6.82473L13.0526 22.7316C13.538 23.356 14.4591 23.356 14.9445 22.7329L27.3327 6.82473Z"></path>
      </g>
      <g id="quick-start-wifi-bars" viewBox="0 0 22 16" fill-rule="evenodd">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M0 5.00001L2 7.00001C6.97 2.03001 15.03 2.03001 20 7.00001L22 5.00001C15.93 -1.06999 6.08 -1.06999 0 5.00001ZM8 13L11 16L14 13C12.35 11.34 9.66 11.34 8 13ZM6 11L4 9.00001C7.87 5.14001 14.14 5.14001 18 9.00001L16 11C13.24 8.24001 8.76 8.24001 6 11Z" fill="#616161"></path>
      </g>
      <g id="hid-touchscreen" fill="none">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M4 6.288C4 8.343 5.22 10.125 7 11v1.071c-1.166-.379-2.162-.571-3-.571a1 1 0 00-.832.445l-1 1.5a1 1 0 00.08 1.213l3.5 4A1 1 0 006.5 19h7a1 1 0 00.894-.553l2.5-5A.999.999 0 0017 13c0-.734-.408-1.244-1.257-1.911a91.893 91.893 0 00-1.999-1.437A5.145 5.145 0 0015 6.288C15 3.368 12.538 1 9.5 1S4 3.368 4 6.288zm8 2.356V6.5a2.5 2.5 0 00-5 0V11 8.644a3.29 3.29 0 01-1-2.356C6 4.43 7.567 2.923 9.5 2.923S13 4.43 13 6.288a3.29 3.29 0 01-1 2.356zM9 13.5a1 1 0 01-1.371.928c-1.269-.507-2.312-.803-3.115-.896l-.257.386L6.954 17h5.928l2.006-4.012a4.803 4.803 0 00-.38-.327c-.285-.223-1.718-1.235-2.323-1.661H10V6.5a.5.5 0 00-1 0v7z" fill="#5F6368">
        </path>
      </g>
      <g id="hid-mouse" fill="none" fill-rule="evenodd">
        <path d="M0 0h20v20H0"></path>
        <path d="M10.833.892V7.5h5.834c0-3.4-2.546-6.2-5.834-6.608zM3.333 12.5c0 3.683 2.984 6.667 6.667 6.667s6.667-2.984 6.667-6.667V9.167H3.333V12.5zM9.167.892C5.88 1.3 3.333 4.1 3.333 7.5h5.834V.892z" fill="#5A5A5A">
        </path>
      </g>
      <g id="hid-keyboard" fill="none" fill-rule="evenodd">
        <path d="M16.667 4.167H3.333c-.92 0-1.658.745-1.658 1.666l-.008 8.334c0 .92.746 1.666 1.666 1.666h13.334c.92 0 1.666-.745 1.666-1.666V5.833c0-.92-.745-1.666-1.666-1.666zm-7.5 2.5h1.666v1.666H9.167V6.667zm0 2.5h1.666v1.666H9.167V9.167zm-2.5-2.5h1.666v1.666H6.667V6.667zm0 2.5h1.666v1.666H6.667V9.167zm-.834 1.666H4.167V9.167h1.666v1.666zm0-2.5H4.167V6.667h1.666v1.666zm7.5 5.834H6.667V12.5h6.666v1.667zm0-3.334h-1.666V9.167h1.666v1.666zm0-2.5h-1.666V6.667h1.666v1.666zm2.5 2.5h-1.666V9.167h1.666v1.666zm0-2.5h-1.666V6.667h1.666v1.666z" fill="#5A5A5A">
        </path>
        <path d="M0 0h20v20H0V0zm0 0h20v20H0V0z" fill="#D8D8D8">
        </path>
      </g>
      <g id="welcome-accessibility" fill-rule="evenodd">
        <defs>
          <path id="a" d="M17.556 4.6c-2.32.63-5.04.9-7.556.9s-5.236-.27-7.556-.9L2 6.4c1.653.45 3.722.747 5.5.9V19H9v-5.5h2V19h1.5V7.3c1.778-.153 3.847-.45 5.5-.9l-.444-1.8zM10 4.6c.978 0 1.778-.81 1.778-1.8S10.978 1 10 1s-1.778.81-1.778 1.8.8 1.8 1.778 1.8z">
          </path>
        </defs>
        <g fill="none" fill-rule="evenodd">
          <path d="M0 0h20v20H0z"></path>
          <use fill="var(--oobe-adaptive-dialog-icon-fill-color)" fill-rule="nonzero" xlink:href="#a"></use>
        </g>
      </g>
      <g id="welcome-language" fill="none" fill-rule="evenodd">
        <path d="M0 0h20v20H0z"></path>
        <path fill="var(--oobe-adaptive-dialog-icon-fill-color)" fill-rule="nonzero" d="M9.992 2C5.576 2 2 5.584 2 10s3.576 8 7.992 8C14.416 18 18 14.416 18 10s-3.584-8-8.008-8zm5.544 4.8h-2.36c-.256-1-.624-1.96-1.104-2.848A6.424 6.424 0 0 1 15.536 6.8zM10 3.632A11.27 11.27 0 0 1 11.528 6.8H8.472A11.27 11.27 0 0 1 10 3.632zM3.808 11.6A6.594 6.594 0 0 1 3.6 10c0-.552.08-1.088.208-1.6h2.704A13.212 13.212 0 0 0 6.4 10c0 .544.048 1.072.112 1.6H3.808zm.656 1.6h2.36c.256 1 .624 1.96 1.104 2.848A6.39 6.39 0 0 1 4.464 13.2zm2.36-6.4h-2.36a6.39 6.39 0 0 1 3.464-2.848A12.52 12.52 0 0 0 6.824 6.8zM10 16.368A11.27 11.27 0 0 1 8.472 13.2h3.056A11.27 11.27 0 0 1 10 16.368zm1.872-4.768H8.128A11.77 11.77 0 0 1 8 10c0-.544.056-1.08.128-1.6h3.744c.072.52.128 1.056.128 1.6s-.056 1.072-.128 1.6zm.2 4.448a12.52 12.52 0 0 0 1.104-2.848h2.36a6.424 6.424 0 0 1-3.464 2.848zm1.416-4.448c.064-.528.112-1.056.112-1.6s-.048-1.072-.112-1.6h2.704c.128.512.208 1.048.208 1.6s-.08 1.088-.208 1.6h-2.704z">
        </path>
      </g>
      <g id="selected">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M19 10C19 14.9706 14.9706 19 10 19C5.02944 19 1 14.9706 1 10C1 5.02944 5.02944 1 10 1C14.9706 1 19 5.02944 19 10ZM14.1705 6.9545C13.7312 6.51516 13.0188 6.51516 12.5795 6.9545L8.875 10.659L7.4205 9.2045C6.98116 8.76517 6.26884 8.76517 5.8295 9.2045C5.39016 9.64384 5.39016 10.3562 5.8295 10.7955L8.0795 13.0455C8.51884 13.4848 9.23116 13.4848 9.6705 13.0455L14.1705 8.5455C14.6098 8.10616 14.6098 7.39384 14.1705 6.9545Z"></path>
      </g>
      <g id="sync">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M8.99977 3.07092L8.9991 5.1002C6.71731 5.56382 5 7.58136 5 10C5 11.8507 6.00553 13.4666 7.50008 14.3311L7.5 12H9V17H4V15.5L5.6705 15.5009C4.04414 14.2191 3 12.2315 3 10C3 6.55562 5.48772 3.69227 8.76441 3.1087L8.99977 3.07092ZM16 3V4.5L14.3315 4.5007C15.9567 5.78256 17 7.76944 17 10C17 13.5264 14.3924 16.4438 11.0002 16.9291L11.0009 14.8998C13.2827 14.4362 15 12.4186 15 10C15 8.14968 13.9949 6.5341 12.5009 5.66945L12.5 8H11V3H16Z"></path>
      </g>
    </defs>
  </svg>
</iron-iconset-svg>

<iron-iconset-svg name="oobe-24" size="24">
  <svg>
    <defs>
      <g id="domain">
        <path d="M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z"></path>
      </g>
      <g id="os-trial-install" fill-rule="evenodd">
        <path fill="var(--oobe-card-radio-button-icon-color)" clip-rule="evenodd" d="M3.6 13.7904C3.6 15.7788 5.2116 17.3904 7.2 17.3904H18C19.3248 17.3904 20.4 16.3152 20.4 14.9904C20.4 13.6656 19.3248 12.5904 18 12.5904H16.1928V11.4C16.1928 9.08039 14.3124 7.19999 11.9928 7.19999C10.0968 7.19999 8.5128 8.46479 7.9908 10.1904H7.2C5.2116 10.1904 3.6 11.802 3.6 13.7904ZM6.4548 7.87439C7.6248 6.03479 9.6576 4.79999 12 4.79999C15.252 4.79999 17.9484 7.15319 18.4932 10.2492C20.9088 10.5 22.8 12.5172 22.8 15C22.8 17.6508 20.6508 19.8 18 19.8H7.2C3.8868 19.8 1.2 17.1144 1.2 13.8C1.2 10.7412 3.4968 8.24519 6.4548 7.87439ZM15.304 12.6L13.894 11.19L12.804 12.27V9.59999H10.804V12.27L9.71398 11.19L8.30398 12.6L11.094 15.39L11.804 16.1L12.514 15.39L15.304 12.6Z"></path>
      </g>
      <g id="os-trial-try" fill-rule="evenodd">
        <path fill="var(--oobe-card-radio-button-icon-color)" clip-rule="evenodd" d="M15.0507 11.4566h.8873v1.8113H13.2V6.02267h1.8507L12.3 2.40002 9.6 6.02267h1.8V13.2679H8.83944V11.3932C9.46056 11.0581 9.90422 10.4151 9.90422 9.64531 9.90422 8.54946 9.02577 7.65285 7.95211 7.65285 6.87845 7.65285 6 8.54946 6 9.64531c0 .76979.44366 1.41279 1.06479 1.74789v1.8747C7.06479 14.2732 7.71507 15 8.7 15h2.7v3C10.77 18.3351 10.4366 18.8378 10.4366 19.6076 10.4366 20.7125 11.3151 21.6 12.3887 21.6 13.4624 21.6 14.3408 20.7125 14.3408 19.6076c0-.7698-.5108-1.2725-1.1408-1.6076V15h2.738C16.923 15 17.7127 14.2732 17.7127 13.2679V11.4566H18.6V7.83399H15.0507V11.4566z"></path>
      </g>
      <g id="visibility-off">
        <path d="M12 7c2.76 0 5 2.24 5 5 0 .65-.13 1.26-.36 1.83l2.92 2.92c1.51-1.26 2.7-2.89 3.43-4.75-1.73-4.39-6-7.5-11-7.5-1.4 0-2.74.25-3.98.7l2.16 2.16C10.74 7.13 11.35 7 12 7zM2 4.27l2.28 2.28.46.46A11.804 11.804 0 0 0 1 12c1.73 4.39 6 7.5 11 7.5 1.55 0 3.03-.3 4.38-.84l.42.42L19.73 22 21 20.73 3.27 3 2 4.27zM7.53 9.8l1.55 1.55c-.05.21-.08.43-.08.65 0 1.66 1.34 3 3 3 .22 0 .44-.03.65-.08l1.55 1.55c-.67.33-1.41.53-2.2.53-2.76 0-5-2.24-5-5 0-.79.2-1.53.53-2.2zm4.31-.78l3.15 3.15.02-.16c0-1.66-1.34-3-3-3l-.17.01z"></path>
      </g>
      <g id="lock" viewBox="0 0 48 48">
        <path d="M0 0h48v48H0z" fill="none"></path>
        <path d="M36 16h-2v-4c0-5.52-4.48-10-10-10S14 6.48 14 12v4h-2c-2.21 0-4 1.79-4 4v20c0 2.21 1.79 4 4 4h24c2.21 0 4-1.79 4-4V20c0-2.21-1.79-4-4-4zM24 34c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4zm6.2-18H17.8v-4c0-3.42 2.78-6.2 6.2-6.2 3.42 0 6.2 2.78 6.2 6.2v4z"></path>
      </g>
      <g id="settings-gear">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M13.85 22.25h-3.7c-.74 0-1.36-.54-1.45-1.27l-.27-1.89c-.27-.14-.53-.29-.79-.46l-1.8.72c-.7.26-1.47-.03-1.81-.65L2.2 15.53c-.35-.66-.2-1.44.36-1.88l1.53-1.19c-.01-.15-.02-.3-.02-.46 0-.15.01-.31.02-.46l-1.52-1.19c-.59-.45-.74-1.26-.37-1.88l1.85-3.19c.34-.62 1.11-.9 1.79-.63l1.81.73c.26-.17.52-.32.78-.46l.27-1.91c.09-.7.71-1.25 1.44-1.25h3.7c.74 0 1.36.54 1.45 1.27l.27 1.89c.27.14.53.29.79.46l1.8-.72c.71-.26 1.48.03 1.82.65l1.84 3.18c.36.66.2 1.44-.36 1.88l-1.52 1.19c.01.15.02.3.02.46 0 .16-.01.31-.02.46l1.52 1.19c.56.45.72 1.23.37 1.86l-1.86 3.22c-.34.62-1.11.9-1.8.63l-1.8-.72c-.26.17-.52.32-.78.46l-.27 1.91c-.1.68-.72 1.22-1.46 1.22zm-3.23-2h2.76l.37-2.55.53-.22c.44-.18.88-.44 1.34-.78l.45-.34 2.38.96 1.38-2.4-2.03-1.58.07-.56c.03-.26.06-.51.06-.78s-.03-.53-.06-.78l-.07-.56 2.03-1.58-1.39-2.4-2.39.96-.45-.35c-.42-.32-.87-.58-1.33-.77l-.52-.22-.37-2.55h-2.76l-.37 2.55-.53.21c-.44.19-.88.44-1.34.79l-.45.33-2.38-.95-1.39 2.39 2.03 1.58-.07.56a7 7 0 0 0-.06.79c0 .26.02.53.06.78l.07.56-2.03 1.58 1.38 2.4 2.39-.96.45.35c.43.33.86.58 1.33.77l.53.22.38 2.55zM12 15.5a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7z"></path>
      </g>
      <g id="browser-sync">
        <path d="M17.26 6H19V4h-6v6h2V6.81c1.79 1.04 3 2.97 3 5.19 0 2.97-2.17 5.43-5 5.91v2.02c3.95-.49 7-3.85 7-7.93 0-2.4-1.07-4.54-2.74-6zM4 12c0 2.4 1.07 4.54 2.74 6H5v2h6v-6H9v3.19C7.21 16.15 6 14.22 6 12c0-2.97 2.17-5.43 5-5.91V4.07C7.05 4.56 4 7.92 4 12z"></path>
        <path d="M.01 0h24v24h-24V0z" fill="none"></path>
      </g>
      <g id="split-modifier-description-1" width="24" height="24" viewBox="0 0 24 24">
        <g id="insert" clip-path="url(#clip0_5648_5004)">
          <g id="2">
            <path id="Vector" d="M11.969 8.14502V16.088" stroke="var(--cros-sys-primary)" stroke-width="1.25" stroke-miterlimit="10" stroke-linecap="square"></path>
            <path id="Vector_2" d="M15.9328 12.1243H7.98975" stroke="var(--cros-sys-primary)" stroke-width="1.25" stroke-miterlimit="10" stroke-linecap="square"></path>
          </g>
            <path id="Vector_3" d="M12 2.73572L21.3264 11.9844L12 21.3109L2.67358 11.9844L12 2.73572ZM12 -6.29574e-07L0 11.9844L12 23.9378L24 11.9378L12 -0.0466309V-6.29574e-07Z" fill="var(--cros-sys-primary)"></path>
        </g>
        <defs>
          <clipPath id="clip0_5648_5004">
            <rect width="24" height="24" fill="white"></rect>
          </clipPath>
        </defs>
      </g>
      <g id="split-modifier-description-2" width="32" height="32" viewBox="0 0 32 32">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M15.515 18.948v-5.772h14.522c0.217 0.977 0.388 1.893 0.388 3.181 0 8.859 -5.942 15.158 -14.894 15.158C6.951 31.515 0 24.564 0 16S6.951 0.485 15.515 0.485c4.189 0 7.695 1.536 10.38 4.049L21.488 8.816C20.371 7.761 18.432 6.505 15.515 6.505c-5.135 0 -9.325 4.267 -9.325 9.495 0 5.229 4.189 9.495 9.325 9.495 5.942 0 8.13 -4.111 8.533 -6.547H15.515Z" fill="var(--cros-sys-primary)"></path>
      </g>
    </defs>
  </svg>
</iron-iconset-svg>

<iron-iconset-svg name="oobe-32" size="32">
  <svg>
    <defs>
      <!-- The Google "G" icon. -->
      <g id="googleg" fill="none" fill-rule="evenodd">
        <path d="M30.42 16.83c0-1.03-.092-2.017-.264-2.966H16.5v5.61h7.804c-.336 1.81-1.358 3.347-2.894 4.375v3.637h4.686c2.742-2.524 4.324-6.242 4.324-10.657z" fill="#4285F4"></path>
        <path d="M16.5 31c3.915 0 7.197-1.298 9.596-3.513L21.41 23.85c-1.298.87-2.96 1.383-4.91 1.383-3.777 0-6.973-2.55-8.113-5.978H3.542v3.757C5.928 27.752 10.832 31 16.5 31z" fill="#34A853"></path>
        <path d="M8.387 19.255c-.29-.87-.455-1.8-.455-2.755 0-.956.165-1.885.455-2.755V9.988H3.542C2.56 11.946 2 14.16 2 16.5s.56 4.554 1.542 6.512l4.845-3.757z" fill="#FBBC05"></path>
        <path d="M16.5 7.767c2.13 0 4.04.732 5.543 2.168l4.16-4.158C23.69 3.437 20.407 2 16.5 2 10.832 2 5.928 5.25 3.542 9.988l4.845 3.757c1.14-3.427 4.336-5.978 8.113-5.978z" fill="#EA4335"></path>
        <path d="M2 2h29v29H2"></path>
      </g>
      <g id="kiosk" fill-rule="evenodd" clip-rule="evenodd">
        <path d="M2.6665 5.33317C2.6665 3.86041 3.86041 2.6665 5.33317 2.6665H26.6665C28.1393 2.6665 29.3332 3.86041 29.3332 5.33317V17.3332C29.3332 18.8059 28.1393 19.9998 26.6665 19.9998H19.9998V26.6665H23.9998V29.3332H7.99984V26.6665H11.9998V19.9998H5.33317C3.86041 19.9998 2.6665 18.8059 2.6665 17.3332V5.33317ZM5.33317 5.33317H26.6665V17.3332H5.33317V5.33317ZM14.6665 26.6665H17.3332V19.9998H14.6665V26.6665Z"></path>
      </g>
      <g id="enterprise" fill-rule="evenodd">
        <path fill-rule="evenodd" d="M16 10V4H3v24h26V10H16zM8.2 25.3333333H5.6v-2.6666666h2.6v2.6666666zM8.2 20H5.6v-2.6666667h2.6V20zm0-5.3333333H5.6V12h2.6v2.6666667zm0-5.33333337H5.6V6.66666667h2.6v2.66666666zm5.2 15.99999997h-2.6v-2.6666666h2.6v2.6666666zM13.4 20h-2.6v-2.6666667h2.6V20zm0-5.3333333h-2.6V12h2.6v2.6666667zm0-5.33333337h-2.6V6.66666667h2.6v2.66666666zM27.0385742 25.3333333H16v-2.6666666h2.6V20H16v-2.6666667h2.6v-2.6666666H16V12h11.0385742v13.3333333zM23.8 14.6666667h-2.6v2.6666666h2.6v-2.6666666zM23.8 20h-2.6v2.6666667h2.6V20z"></path>
      </g>
      <!-- Theme color exclamation mark in circle -->
      <g id="alert" fill-rule="evenodd">
        <defs>
          <path id="a" d="M14.667 20h2.666v2.667h-2.666V20zm0-10.667h2.666v8h-2.666v-8zm1.32-6.666C8.627 2.667 2.667 8.64 2.667 16s5.96 13.333 13.32 13.333c7.373 0 13.346-5.973 13.346-13.333S23.36 2.667 15.987 2.667zm.013 24c-5.893 0-10.667-4.774-10.667-10.667S10.107 5.333 16 5.333 26.667 10.107 26.667 16 21.893 26.667 16 26.667z"></path>
        </defs>
        <g fill="none" fill-rule="evenodd">
          <path d="M0 0h32v32H0z"></path>
          <use fill="var(--oobe-adaptive-dialog-icon-fill-color)" fill-rule="nonzero" xlink:href="#a"></use>
        </g>
      </g>
      <!-- Red exclamation mark in circle -->
      <g id="warning" fill-rule="evenodd">
        <defs>
          <path id="a" d="M14.667 20h2.666v2.667h-2.666V20zm0-10.667h2.666v8h-2.666v-8zm1.32-6.666C8.627 2.667 2.667 8.64 2.667 16s5.96 13.333 13.32 13.333c7.373 0 13.346-5.973 13.346-13.333S23.36 2.667 15.987 2.667zm.013 24c-5.893 0-10.667-4.774-10.667-10.667S10.107 5.333 16 5.333 26.667 10.107 26.667 16 21.893 26.667 16 26.667z"></path>
        </defs>
        <g fill="none" fill-rule="evenodd">
          <path d="M0 0h32v32H0z"></path>
          <use fill="var(--cros-sys-error)" fill-rule="nonzero" xlink:href="#a"></use>
        </g>
      </g>
      <g id="game-controller">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M28.8 6.39999H3.2C1.44 6.39999 0 7.83999 0 9.59999V22.4C0 24.16 1.44 25.6 3.2 25.6H28.8C30.56 25.6 32 24.16 32 22.4V9.59999C32 7.83999 30.56 6.39999 28.8 6.39999ZM28.8 22.4H3.2V9.59999H28.8V22.4ZM8 20.8H11.2V17.6H14.4V14.4H11.2V11.2H8V14.4H4.8V17.6H8V20.8ZM20 20.8C21.3255 20.8 22.4 19.7255 22.4 18.4C22.4 17.0745 21.3255 16 20 16C18.6745 16 17.6 17.0745 17.6 18.4C17.6 19.7255 18.6745 20.8 20 20.8ZM24.8 16C26.1255 16 27.2 14.9255 27.2 13.6C27.2 12.2745 26.1255 11.2 24.8 11.2C23.4745 11.2 22.4 12.2745 22.4 13.6C22.4 14.9255 23.4745 16 24.8 16Z" fill="var(--cros-sys-primary)"></path>
      </g>
      <g id="lock">
        <defs>
          <path id="a" d="M24 12h-1.333V9.333A6.67 6.67 0 0 0 16 2.667a6.67 6.67 0 0 0-6.667 6.666V12H8a2.675 2.675 0 0 0-2.667 2.667V28c0 1.467 1.2 2.667 2.667 2.667h16c1.467 0 2.667-1.2 2.667-2.667V14.667C26.667 13.2 25.467 12 24 12zM12 9.333c0-2.213 1.787-4 4-4s4 1.787 4 4V12h-8V9.333zM24 28H8V14.667h16V28zm-8-4c1.467 0 2.667-1.2 2.667-2.667 0-1.466-1.2-2.666-2.667-2.666a2.675 2.675 0 0 0-2.667 2.666C13.333 22.8 14.533 24 16 24z">
          </path>
        </defs>
        <g fill="none" fill-rule="evenodd">
          <use fill="var(--oobe-adaptive-dialog-icon-fill-color)" fill-rule="nonzero" xlink:href="#a"></use>
          <path d="M0 0h32v32H0z"></path>
        </g>
      </g>
      <g id="fingerprint" fill-rule="evenodd" fill="none">
        <path d="M20.036 5.029a.603.603 0 0 1-.259-.062c-2.154-1.114-4.027-1.592-6.266-1.592-2.233 0-4.337.534-6.266 1.586a.565.565 0 0 1-.54-.99 14.08 14.08 0 0 1 6.806-1.721c2.397 0 4.489.529 6.784 1.716.276.14.382.483.242.759a.57.57 0 0 1-.5.304zM3.937 10.935a.56.56 0 0 1-.461-.883 11.717 11.717 0 0 1 4.225-3.684c3.538-1.829 8.06-1.834 11.604-.012 1.682.867 3.1 2.093 4.219 3.656a.559.559 0 0 1-.13.782.566.566 0 0 1-.787-.129 10.561 10.561 0 0 0-3.814-3.307c-3.229-1.66-7.352-1.654-10.575.01a10.564 10.564 0 0 0-3.82 3.336.573.573 0 0 1-.46.231zm7.037 13.573a.558.558 0 0 1-.399-.169c-.973-.984-1.502-1.608-2.261-2.964-.777-1.384-1.187-3.077-1.187-4.888 0-3.341 2.857-6.064 6.373-6.064s6.373 2.717 6.373 6.064c0 .31-.253.562-.562.562a.564.564 0 0 1-.563-.562c0-2.723-2.351-4.939-5.248-4.939-2.891 0-5.248 2.216-5.248 4.939 0 1.62.36 3.116 1.04 4.337.726 1.293 1.21 1.85 2.076 2.722.22.22.22.58-.005.793a.504.504 0 0 1-.389.17zm8.061-2.081c-1.339 0-2.514-.338-3.488-.996-1.67-1.136-2.671-2.981-2.671-4.939 0-.309.253-.562.562-.562.31 0 .563.253.563.563 0 1.58.815 3.076 2.182 4.005.793.54 1.727.804 2.852.804.27 0 .726-.028 1.176-.107a.565.565 0 0 1 .652.456.565.565 0 0 1-.456.652 8.055 8.055 0 0 1-1.372.124zm-2.267 2.323a.42.42 0 0 1-.146-.023c-1.794-.489-2.964-1.153-4.18-2.362a8.236 8.236 0 0 1-2.435-5.872c0-1.829 1.552-3.314 3.465-3.314 1.912 0 3.465 1.485 3.465 3.313 0 1.204 1.052 2.189 2.34 2.189 1.288 0 2.34-.98 2.34-2.189 0-4.24-3.656-7.689-8.15-7.689-3.201 0-6.12 1.778-7.437 4.534-.439.911-.658 1.974-.658 3.155 0 .878.079 2.262.748 4.056a.567.567 0 0 1-.332.726.567.567 0 0 1-.726-.332c-.55-1.48-.82-2.93-.82-4.45 0-1.35.258-2.576.77-3.639 1.502-3.139 4.82-5.17 8.449-5.17 5.113 0 9.275 3.955 9.275 8.815 0 1.828-1.558 3.313-3.465 3.313-1.907 0-3.465-1.485-3.465-3.313 0-1.204-1.052-2.188-2.34-2.188-1.288 0-2.34.979-2.34 2.188 0 1.918.748 3.724 2.104 5.074 1.063 1.057 2.098 1.642 3.684 2.076a.564.564 0 0 1 .394.691.559.559 0 0 1-.54.411z" fill="var(--oobe-adaptive-dialog-icon-fill-color)"></path>
        <path d="M0 0h27v27H0z"></path>
      </g>
      <g id="gear" fill="none" fill-rule="evenodd">
        <path d="M-3-3h32v32H-3z"></path>
        <path fill="var(--oobe-adaptive-dialog-icon-fill-color)" fill-rule="nonzero" d="M22.52 14.248c.048-.4.08-.816.08-1.248 0-.432-.032-.848-.096-1.248l2.704-2.112a.661.661 0 0 0 .16-.816l-2.56-4.432a.65.65 0 0 0-.784-.288l-3.184 1.28a9.374 9.374 0 0 0-2.16-1.248L16.2.744A.639.639 0 0 0 15.56.2h-5.12a.623.623 0 0 0-.624.544l-.48 3.392a9.625 9.625 0 0 0-2.16 1.248l-3.184-1.28a.633.633 0 0 0-.784.288L.648 8.824a.62.62 0 0 0 .16.816l2.704 2.112c-.064.4-.112.832-.112 1.248 0 .416.032.848.096 1.248L.792 16.36a.661.661 0 0 0-.16.816l2.56 4.432a.65.65 0 0 0 .784.288l3.184-1.28a9.374 9.374 0 0 0 2.16 1.248l.48 3.392a.65.65 0 0 0 .64.544h5.12c.32 0 .592-.224.624-.544l.48-3.392a9.625 9.625 0 0 0 2.16-1.248l3.184 1.28c.288.112.624 0 .784-.288l2.56-4.432a.62.62 0 0 0-.16-.816l-2.672-2.112zM13 17.8c-2.64 0-4.8-2.16-4.8-4.8 0-2.64 2.16-4.8 4.8-4.8 2.64 0 4.8 2.16 4.8 4.8 0 2.64-2.16 4.8-4.8 4.8z"></path>
      </g>
      <g id="chromebook">
        <path fill-rule="nonzero" d="M 26.667969 22.667969 C 28.132812 22.667969 29.320312 21.464844 29.320312 20 L 29.332031 6.667969 C 29.332031 5.199219 28.132812 4 26.667969 4 L 5.332031 4 C 3.867188 4 2.667969 5.199219 2.667969 6.667969 L 2.667969 20 C 2.667969 21.464844 3.867188 22.667969 5.332031 22.667969 Z M 5.332031 6.667969 L 26.667969 6.667969 L 26.667969 20 L 5.332031 20 Z M 6.226562 24 L 1.332031 24 L 1.332031 26.667969 L 30.667969 26.667969 L 30.667969 24 L 25.773438 24">
        </path>
      </g>
      <g id="computer" fill="none" fill-rule="evenodd">
        <path d="M0-4h32v32H0z"></path>
        <path fill="var(--oobe-adaptive-dialog-icon-fill-color)" fill-rule="nonzero"d="M29 20V0H3v20H0v3h32v-3h-3zm-10.333 0h-5.334v-1.333h5.334V20zM26 16H6V3h20v13z"></path>
        <path fill="var(--oobe-adaptive-dialog-icon-fill-color)" d="M16.97 8.129L16 5l-.97 3.129H12l2.47 1.836L13.53 13 16 11.123 18.47 13l-.94-3.035L20 8.129z"></path>
      </g>
      <g id="checkmark">
        <path d="M21.9314 11.6686c-.6249-.6248-1.6379-.6248-2.2628 0L14.4 16.9373l-2.0686-2.0687c-.6249-.6248-1.6379-.6248-2.2628 0-.6248.6249-.6248 1.6379 0 2.2628l3.2 3.2c.6249.6248 1.6379.6248 2.2628 0l6.4-6.4c.6248-.6249.6248-1.6379 0-2.2628z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M16 28.8c7.0693 0 12.8-5.7308 12.8-12.8 0-7.0693-5.7307-12.8-12.8-12.8C8.9308 3.2 3.2 8.9307 3.2 16c0 7.0692 5.7308 12.8 12.8 12.8zm0-3.2c5.3019 0 9.6-4.2981 9.6-9.6S21.3019 6.4 16 6.4 6.4 10.6981 6.4 16s4.2981 9.6 9.6 9.6z"></path>
      </g>
      <g id="checkcircle" fill="none" fill-rule="evenodd">
        <path fill="#5BB974" fill-rule="nonzero"  d="M 16,2.6667 C 8.6400184,2.6667 2.6667,8.640018 2.6667,16 2.6667,23.359982 8.6400184,29.3333 16,29.3333 23.359982,29.3333 29.3333,23.359982 29.3333,16 29.3333,8.640018 23.359982,2.6667 16,2.6667 Z m 0,23.99994 C 10.120015,26.66664 5.33336,21.879985 5.33336,16 5.33336,10.120015 10.120015,5.33336 16,5.33336 c 5.879985,0 10.66664,4.786655 10.66664,10.66664 0,5.879985 -4.786655,10.66664 -10.66664,10.66664 z M 13.33334,18.933326 9.866682,15.466668 8.00002,17.33333 13.33334,22.66665 23.99998,12.00001 22.133318,10.133348 Z"></path>
        <path d="M 0,8 H 24 V 32 H 0 Z"></path>
      </g>
      <g id="avatar" fill-rule="evenodd">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M16 2.667C8.64 2.667 2.667 8.64 2.667 16S8.64 29.333 16 29.333 29.333 23.36 29.333 16 23.36 2.667 16 2.667zm8.48 19.773c-1.907-2.32-6.533-3.107-8.48-3.107s-6.573.787-8.48 3.107A10.6 10.6 0 015.333 16C5.333 10.12 10.12 5.333 16 5.333S26.667 10.12 26.667 16a10.6 10.6 0 01-2.187 6.44zM16 8a4.655 4.655 0 00-4.667 4.667A4.655 4.655 0 0016 17.333a4.655 4.655 0 004.667-4.666A4.655 4.655 0 0016 8z"></path>
      </g>
      <g id="family" fill="none" fill-rule="evenodd">
        <path fill="#4285F4" d="M15.917 1.333c-.484 0-.967.184-1.35.534l-10.75 9.9c-.4.366-.617.85-.634 1.35l6.784 1.066L15.917 12l1.666-4.767-1.666-5.9z"></path>
        <path fill="#BDC1C6" d="M18.267 21.45l-7.034 9.217H14.9c.617 0 1.2-.284 1.583-.784l6.434-8.433h-4.65zM3.2 24.017c-.617 0-1.2.283-1.583.783l-.284.383 1.984.45 1.166 1.517 2.4-3.133H3.2z"></path>
        <path fill="#34A853" d="M15.917 12L3.183 13.117c-.033.466.1.933.4 1.333l3.734 4.883 1.016 1.334 4.284 1.283 3.3-1.95 1.666-4-1.666-4z"></path>
        <path fill="#FBBC04" d="M8.333 20.667l6.017 7.883c.4.517.983.783 1.583.783l1.667-4.8L15.933 20l-7.6.667z"></path>
        <path fill="#DADCE0" d="M14.9 30.667c-.617 0-1.2-.284-1.583-.784l-3.9-5.1A1.989 1.989 0 007.833 24H3.2c.617 0 1.2.283 1.583.783l3.9 5.1c.384.5.967.784 1.584.784H14.9z"></path>
        <path fill="#669DF6" d="M28.667 13.117a2.28 2.28 0 00-.15-.667c-.1-.25-.267-.483-.484-.683L17.283 1.85a2.06 2.06 0 00-1.366-.517V12l6.366 2.233 6.384-1.116z"></path>
        <path fill="#5BB974" d="M28.667 13.117L15.917 12v8l3.683 1.95 3.917-1.283 1.016-1.334 3.717-4.866c.317-.4.433-.884.417-1.35z"></path>
        <path fill="#FCC934" d="M15.917 29.333c.583 0 1.183-.266 1.583-.783l6.017-7.883-7.6-.667v9.333z"></path>
      </g>
      <g id="accessibility" fill-rule="evenodd">
        <path d="M16 2.667c1.467 0 2.667 1.184 2.667 2.633 0 1.448-1.2 2.632-2.667 2.632-1.467 0-2.667-1.184-2.667-2.632 0-1.45 1.2-2.633 2.667-2.633zm4 9.215v16.785h-3v-7.9h-2v7.9h-3V11.882H4V8.92h24v2.962h-8z"></path>
      </g>
      <g id="language" fill-rule="evenodd">
        <path d="M15.987 2.667C8.627 2.667 2.667 8.64 2.667 16s5.96 13.333 13.32 13.333c7.373 0 13.346-5.973 13.346-13.333S23.36 2.667 15.987 2.667zm9.24 8h-3.934C20.867 9 20.253 7.4 19.453 5.92c2.454.84 4.494 2.547 5.774 4.747zM16 5.387c1.107 1.6 1.973 3.373 2.547 5.28h-5.094c.574-1.907 1.44-3.68 2.547-5.28zM5.68 18.667c-.213-.854-.347-1.747-.347-2.667 0-.92.134-1.813.347-2.667h4.507C10.08 14.213 10 15.093 10 16c0 .907.08 1.787.187 2.667H5.68zm1.093 2.666h3.934c.426 1.667 1.04 3.267 1.84 4.747-2.454-.84-4.494-2.533-5.774-4.747zm3.934-10.666H6.773c1.28-2.214 3.32-3.907 5.774-4.747-.8 1.48-1.414 3.08-1.84 4.747zM16 26.613c-1.107-1.6-1.973-3.373-2.547-5.28h5.094c-.574 1.907-1.44 3.68-2.547 5.28zm3.12-7.946h-6.24c-.12-.88-.213-1.76-.213-2.667 0-.907.093-1.8.213-2.667h6.24c.12.867.213 1.76.213 2.667 0 .907-.093 1.787-.213 2.667zm.333 7.413c.8-1.48 1.414-3.08 1.84-4.747h3.934c-1.28 2.2-3.32 3.907-5.774 4.747zm2.36-7.413c.107-.88.187-1.76.187-2.667 0-.907-.08-1.787-.187-2.667h4.507c.213.854.347 1.747.347 2.667 0 .92-.134 1.813-.347 2.667h-4.507z"></path>
      </g>
      <g id="timezone" fill-rule="evenodd">
        <path d="M15.993 2.667C8.627 2.667 2.667 8.633 2.667 16s5.96 13.333 13.326 13.333c7.367 0 13.34-5.966 13.34-13.333S23.36 2.667 15.993 2.667zm.007 24c-5.893 0-10.667-4.774-10.667-10.667S10.107 5.333 16 5.333 26.667 10.107 26.667 16 21.893 26.667 16 26.667z"></path>
        <path d="M16.667 9.333h-2v8l6.993 4.2 1.007-1.64-6-3.56"></path>
      </g>
      <g id="wifi" fill-rule="evenodd">
        <path d="M1.333 12L4 14.667c6.627-6.627 17.373-6.627 24 0L30.667 12c-8.1-8.1-21.234-8.1-29.334 0zM12 22.667l4 4 4-4c-2.207-2.207-5.793-2.207-8 0zm-5.333-5.334L9.333 20c3.68-3.68 9.654-3.68 13.334 0l2.666-2.667c-5.153-5.153-13.513-5.153-18.666 0z"></path>
      </g>
      <g id="connect-devices">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M3 0h24c1.65 0 3 1.35 3 3v7.418a9.898 9.898 0 00-3-1.313V3H3v15h12.016v3H3c-1.65 0-3-1.35-3-3L.015 3C.015 1.35 1.35 0 3 0zm12.902 13.5a7.384 7.384 0 00-.87 3H9v-3h6.902zM21 9.332a9.636 9.636 0 00-3 1.648V9h3v.332zM13.5 4.5h3v3h-3v-3zm3 4.5h-3v3h3V9zM9 4.5h3v3H9v-3zM12 9H9v3h3V9zM4.5 9h3v3h-3V9zm3-4.5h-3v3h3v-3zm10.5 0h3v3h-3v-3zm4.5 0h3v3h-3v-3z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M24.5 11c-4.146 0-7.5 3.13-7.5 7v6c0 3.87 3.354 7 7.5 7s7.5-3.13 7.5-7v-6c0-3.87-3.354-7-7.5-7zm5 6.875v.625h-3.75v-5c2.5 0 3.75 2.5 3.75 4.375zM23.25 13.5v5H19.5V18c0-2 1.25-4.5 3.75-4.5zm1.25 15c-2.957 0-5-1.74-5-4.5v-3h10v3c0 2.76-2.043 4.5-5 4.5z"></path>
      </g>
      <g id="stars">
        <path d="M25.333 12L26.9997 8.33337L30.6663 6.66671L26.9997 5.00004L25.333 1.33337L23.6663 5.00004L19.9997 6.66671L23.6663 8.33337L25.333 12ZM15.333 12.6667L11.9997 5.33337L8.66634 12.6667L1.33301 16L8.66634 19.3334L11.9997 26.6667L15.333 19.3334L22.6663 16L15.333 12.6667ZM25.333 20L23.6663 23.6667L19.9997 25.3334L23.6663 27L25.333 30.6667L26.9997 27L30.6663 25.3334L26.9997 23.6667L25.333 20Z"></path>
      </g>
      <g id="gestures" fill="none" fill-rule="evenodd">
        <path d="M-.5 0h29.5385v29.5385H-.5z"></path>
        <path fill="var(--oobe-adaptive-dialog-icon-fill-color)" d="M16.115.0125a3.053 3.053 0 012.536 1.3415 3.0255 3.0255 0 011.1565-.2215 3.078 3.078 0 013.077 3.0765v.345a3.078 3.078 0 013.6925 3.015v7.2h-2.462v-7.2c0-.3445-.271-.615-.6155-.615-.345 0-.615.2705-.615.615v7.2h-2.462V4.209c0-.3445-.2705-.615-.615-.615-.345 0-.6155.2705-.6155.615v10.56h-2.4615V3.089c0-.3445-.271-.615-.6155-.615-.345 0-.6155.2705-.6155.615v11.68H13.038V5.8955c0-.345-.271-.6155-.615-.6155-.345 0-.616.283-.616.615v15.84l-6.5845-3.4825-.6275.5535 7.212 7.508c.468.48 1.108.763 1.7725.763H15.5v2.4615h-1.9075a4.974 4.974 0 01-3.557-1.514L1.05 18.6585l2.548-2.2525a2.464 2.464 0 012.7815-.332l2.966 1.575V5.8955a3.078 3.078 0 013.077-3.077c.2095 0 .4185.025.628.0615.1105-1.6 1.44-2.8675 3.0645-2.8675z"></path>
        <path fill="var(--oobe-adaptive-dialog-icon-fill-color)" d="M25.651 20.849l1.1565 2.5355 1.157-2.535L30.5 19.692l-2.535-1.157L26.807 16l-1.1565 2.535-2.5355 1.1575 2.535 1.1565zm-5.54 7.771L21.6545 32l1.5425-3.3805 3.38-1.5425-3.38-1.5425-1.5425-3.3805-1.5425 3.38-3.3805 1.543 3.38 1.5425z"></path>
      </g>
      <g id="gesture-overview" fill="none" >
        <path fill="var(--oobe-adaptive-dialog-icon-fill-color)" fill-rule="evenodd" d="M2 7.6h16.8v16.8H2zm14 2.8H4.8v11.2H16z" clip-rule="evenodd"></path>
        <path fill="var(--oobe-adaptive-dialog-icon-fill-color)" d="M24.4 7.6h-2.8v16.8h2.8zm5.6 0h-2.8v16.8H30z"></path>
      </g>
      <g id="gesture-back" fill="none" >
        <defs>
          <path id="a" d="M32 14H7.66L18.84 2.82 16 0 0 16l16 16 2.82-2.82L7.66 18H32z"></path>
        </defs>
        <g fill="none" fill-rule="evenodd" transform="translate(5.33328 5.33328) scale(.66667)">
          <mask id="b" fill="#fff">
            <use xlink:href="#a" width="100%" height="100%"></use>
          </mask>
          <g fill="var(--oobe-adaptive-dialog-icon-fill-color)" mask="url(#b)">
            <path d="M -8,-8 H 40 V 40 H -8 Z"></path>
          </g>
        </g>
      </g>
      <g id="drive">
        <path fill-rule="evenodd" d="M18.313 18.607a7.993 7.993 0 0 1 6.502-3.605L18.524 4h-8.55v.013l8.338 14.594Zm-.828 1.643h-6.072l-4.288 7.5h11.437A7.964 7.964 0 0 1 17 23c0-.966.171-1.892.485-2.75Zm-16.797 0 8.2-14.35s4.28 7.5 4.287 7.5l-8.2 14.338L.688 20.25Z" clip-rule="evenodd"></path>
        <path d="M26.91 19.26a.797.797 0 0 1 1.18 0 .931.931 0 0 1 0 1.257l-3.334 3.556a.797.797 0 0 1-1.179 0l-1.666-1.778a.931.931 0 0 1 0-1.257.797.797 0 0 1 1.178 0l1.078 1.15 2.744-2.928Zm-5.16 6.14c-.414 0-.75.358-.75.8 0 .442.336.8.75.8h6.5c.414 0 .75-.358.75-.8 0-.442-.336-.8-.75-.8h-6.5Z"></path>
      </g>
      <g id="work">
        <path d="M4.46667 29.1333C3.4 29.1333 2.48889 28.7667 1.73333 28.0333C1 27.2778 0.633333 26.3556 0.633333 25.2667V10.9C0.633333 9.83333 1 8.93333 1.73333 8.2C2.48889 7.44444 3.4 7.06667 4.46667 7.06667H8.73333V4.66667C8.73333 3.57778 9.1 2.66666 9.83333 1.93333C10.5889 1.17778 11.5 0.799999 12.5667 0.799999H17.4333C18.5 0.799999 19.4 1.17778 20.1333 1.93333C20.8889 2.66666 21.2667 3.57778 21.2667 4.66667V7.06667H25.5333C26.6 7.06667 27.5 7.44444 28.2333 8.2C28.9889 8.93333 29.3667 9.83333 29.3667 10.9V25.2667C29.3667 26.3556 28.9889 27.2778 28.2333 28.0333C27.5 28.7667 26.6 29.1333 25.5333 29.1333H4.46667ZM4.46667 25.2667H25.5333V10.9H4.46667V25.2667ZM12.5667 7.06667H17.4333V4.66667H12.5667V7.06667ZM4.46667 25.2667V10.9V25.2667Z" fill="var(--oobe-adaptive-dialog-icon-fill-color)"></path>
      </g>
      <g id="gesture-home" fill="none" >
        <defs>
          <path id="c" d="M16 0L0 12v24h32V12L16 0zm12 32h-6V20H10v12H4V14l12-9 12 9v18z"></path>
        </defs>
        <g fill="none" fill-rule="evenodd" transform="matrix(.66667 0 0 .66667 5.333333 4)">
          <mask id="d" fill="#fff">
            <use xlink:href="#c" width="100%" height="100%"></use>
          </mask>
          <g fill="var(--oobe-adaptive-dialog-icon-fill-color)" mask="url(#d)">
            <path d="M -8,-6 H 40 V 42 H -8 Z"></path>
          </g>
        </g>
      </g>
      <g id="update-progress">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M19.2 14.4V11.2H24.3166C22.6573 8.32999 19.5551 6.39995 16 6.39995C10.696 6.39995 6.39995 10.696 6.39995 16C6.39995 21.3039 10.696 25.5999 16 25.5999C20.7581 25.5999 24.7051 22.1426 25.4671 17.6018L28.7007 17.6008C27.9121 23.9117 22.5225 28.7999 15.9872 28.7999C8.92155 28.7999 3.19995 23.0655 3.19995 16C3.19995 8.93435 8.92155 3.19995 15.9872 3.19995C19.8171 3.19995 23.2536 4.87876 25.6011 7.53889L25.5999 4.79995H28.7999V14.4H19.2ZM16.8 9.59995V16L20.7999 20L18.4 22.4L13.6 17.6V9.59995H16.8Z"></path>
      </g>
      <!-- CHOOBE and optional screens Icons -->
      <g id="theme-light">
        <path d="M6 4C4.89543 4 4 4.89543 4 6V26C4 27.1046 4.89543 28 6 28H16V22C12.6863 22 10 19.3137 10 16C10 12.6863 12.6863 10 16 10V4H6Z"></path>
        <path d="M16 22C19.3137 22 22 19.3137 22 16C22 12.6863 19.3137 10 16 10V22Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M25 6H16V4H25C26.6569 4 28 5.34315 28 7V25C28 26.6569 26.6569 28 25 28H16V26H25C25.5523 26 26 25.5523 26 25V7C26 6.44772 25.5523 6 25 6Z"></path>
      </g>
      <g id="scroll-direction">
        <path d="M6 13C6 11.8954 6.89543 11 8 11H24C25.1046 11 26 11.8954 26 13V19C26 20.1046 25.1046 21 24 21H8C6.89543 21 6 20.1046 6 19V13Z"></path>
        <path d="M15.6558 2.32919C16.0487 1.71066 16.9513 1.71066 17.3441 2.32919L20.2876 6.96389C20.7104 7.62965 20.2321 8.5 19.4434 8.5H13.5566C12.7679 8.5 12.2896 7.62965 12.7124 6.96389L15.6558 2.32919Z"></path>
        <path d="M17.3441 29.6708C16.9513 30.2893 16.0487 30.2893 15.6558 29.6708L12.7124 25.0361C12.2896 24.3703 12.7679 23.5 13.5566 23.5L19.4434 23.5C20.2321 23.5 20.7104 24.3703 20.2876 25.0361L17.3441 29.6708Z"></path>
      </g>
      <g id="display">
        <rect x="4" y="18" width="10" height="10" rx="2"></rect>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M8 20H6V22H8V26H10V22H12V20H10H8Z" fill="var(--cros-bg-color)"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M9 6C9 4.89543 9.89543 4 11 4H26C27.1046 4 28 4.89543 28 6V21C28 22.1046 27.1046 23 26 23H15V19C15 17.8954 14.1046 17 13 17H9V6ZM17 8H13V11H17V18H20V11H24V8H20H17Z"></path>
      </g>
      <g id="choobe-icon">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M4.7998 4.80005H14.3998V14.4H4.7998V4.80005ZM7.9998 8.00005V11.2H11.1998V8.00005H7.9998ZM4.7998 17.6H14.3998V27.2H4.7998V17.6ZM7.9998 20.8V24H11.1998V20.8H7.9998ZM17.5998 4.80005H27.1998V14.4H17.5998V4.80005ZM20.7998 8.00005V11.2H23.9998V8.00005H20.7998ZM22.3998 15.6118L29.188 22.4L22.3998 29.1883L15.6116 22.4L22.3998 15.6118ZM22.3998 20.1373L20.1371 22.4L22.3998 24.6628L24.6625 22.4L22.3998 20.1373Z"></path>
      </g>
      <!-- OS Sync Consent Icons -->
      <g id="sync-app">
        <path d="M21.985 13.5C23.085 13.5 23.985 12.6 23.985 11.5C23.985 10.4 23.085 9.5 21.985 9.5C20.885 9.5 19.985 10.4 19.985 11.5C19.985 12.6 20.885 13.5 21.985 13.5Z"></path>
        <path d="M11.985 23.5C13.085 23.5 13.985 22.6 13.985 21.5C13.985 20.4 13.085 19.5 11.985 19.5C10.885 19.5 9.98499 20.4 9.98499 21.5C9.98499 22.6 10.885 23.5 11.985 23.5Z"></path>
        <path d="M21.985 23.5C23.085 23.5 23.985 22.6 23.985 21.5C23.985 20.4 23.085 19.5 21.985 19.5C20.885 19.5 19.985 20.4 19.985 21.5C19.985 22.6 20.885 23.5 21.985 23.5Z"></path>
        <path d="M18.985 21.5C18.985 22.6 18.085 23.5 16.985 23.5C15.885 23.5 14.985 22.6 14.985 21.5C14.985 20.4 15.885 19.5 16.985 19.5C18.085 19.5 18.985 20.4 18.985 21.5Z"></path>
        <path d="M13.985 11.5C13.985 12.6 13.085 13.5 11.985 13.5C10.885 13.5 9.98499 12.6 9.98499 11.5C9.98499 10.4 10.885 9.5 11.985 9.5C13.085 9.5 13.985 10.4 13.985 11.5Z"></path>
        <path d="M16.985 13.5C18.085 13.5 18.985 12.6 18.985 11.5C18.985 10.4 18.085 9.5 16.985 9.5C15.885 9.5 14.985 10.4 14.985 11.5C14.985 12.6 15.885 13.5 16.985 13.5Z"></path>
        <path d="M23.985 16.5C23.985 17.6 23.085 18.5 21.985 18.5C20.885 18.5 19.985 17.6 19.985 16.5C19.985 15.4 20.885 14.5 21.985 14.5C23.085 14.5 23.985 15.4 23.985 16.5Z"></path>
        <path d="M11.985 18.5C13.085 18.5 13.985 17.6 13.985 16.5C13.985 15.4 13.085 14.5 11.985 14.5C10.885 14.5 9.98499 15.4 9.98499 16.5C9.98499 17.6 10.885 18.5 11.985 18.5Z"></path>
        <path d="M18.985 16.5C18.985 17.6 18.085 18.5 16.985 18.5C15.885 18.5 14.985 17.6 14.985 16.5C14.985 15.4 15.885 14.5 16.985 14.5C18.085 14.5 18.985 15.4 18.985 16.5Z"></path>
      </g>
      <g id="sync-settings">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M18.4631 24.5H15.504C14.9122 24.5 14.4163 24.0783 14.3443 23.5083L14.1284 22.0325C13.9125 21.9231 13.7045 21.806 13.4966 21.6733L12.057 22.2355C11.4972 22.4385 10.8814 22.2121 10.6095 21.7279L9.14591 19.2526C8.86599 18.7372 8.98595 18.1281 9.43382 17.7845L10.6574 16.8553C10.6494 16.7382 10.6415 16.621 10.6415 16.4961C10.6415 16.379 10.6494 16.254 10.6574 16.1369L9.44182 15.2077C8.96996 14.8563 8.85 14.2238 9.14591 13.7396L10.6255 11.2487C10.8974 10.7645 11.5132 10.5459 12.057 10.7567L13.5046 11.3267C13.7125 11.194 13.9205 11.0769 14.1284 10.9675L14.3443 9.47609C14.4163 8.92948 14.9122 8.5 15.496 8.5H18.4551C19.0469 8.5 19.5428 8.92167 19.6147 9.4917L19.8307 10.9675C20.0466 11.0769 20.2545 11.194 20.4625 11.3267L21.902 10.7645C22.4699 10.5615 23.0857 10.7879 23.3576 11.2721L24.8291 13.7552C25.1171 14.2706 24.9891 14.8797 24.5412 15.2233L23.3256 16.1525C23.3336 16.2696 23.3416 16.3868 23.3416 16.5117C23.3416 16.6367 23.3336 16.7538 23.3256 16.8709L24.5412 17.8001C24.9891 18.1515 25.1171 18.7606 24.8371 19.2526L23.3496 21.767C23.0777 22.2511 22.4619 22.4697 21.91 22.2589L20.4705 21.6967C20.2625 21.8294 20.0546 21.9466 19.8467 22.0559L19.6307 23.5473C19.5507 24.0783 19.0549 24.5 18.4631 24.5ZM15.932 22.5H18.0456L18.329 20.6455L18.7348 20.4855C19.0718 20.3545 19.4087 20.1655 19.761 19.9182L20.1056 19.6709L21.9282 20.3691L22.985 18.6236L21.4304 17.4745L21.484 17.0673C21.507 16.8782 21.53 16.6964 21.53 16.5C21.53 16.3036 21.507 16.1145 21.484 15.9327L21.4304 15.5255L22.985 14.3764L21.9205 12.6309L20.0903 13.3291L19.7457 13.0745C19.424 12.8418 19.0794 12.6527 18.7272 12.5145L18.329 12.3545L18.0456 10.5H15.932L15.6487 12.3545L15.2428 12.5073C14.9059 12.6455 14.5689 12.8273 14.2166 13.0818L13.872 13.3218L12.0494 12.6309L10.985 14.3691L12.5395 15.5182L12.4859 15.9255C12.463 16.1145 12.44 16.3109 12.44 16.5C12.44 16.6891 12.4553 16.8855 12.4859 17.0673L12.5395 17.4745L10.985 18.6236L12.0418 20.3691L13.872 19.6709L14.2166 19.9255C14.5459 20.1655 14.8752 20.3473 15.2351 20.4855L15.641 20.6455L15.932 22.5ZM16.985 19C18.3657 19 19.485 17.8807 19.485 16.5C19.485 15.1193 18.3657 14 16.985 14C15.6043 14 14.485 15.1193 14.485 16.5C14.485 17.8807 15.6043 19 16.985 19Z"></path>
      </g>
      <g id="sync-wifi">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M25.3177 13.2654C25.5953 12.9088 25.5187 12.3872 25.1531 12.1291C23.8864 11.2353 20.9511 9.5 16.985 9.5C13.0196 9.5 10.0836 11.2353 8.8169 12.1291C8.45132 12.3872 8.37471 12.9088 8.65231 13.2654L16.3926 23.2072C16.696 23.5975 17.2717 23.5975 17.5751 23.208L25.3177 13.2654Z"></path>
      </g>
      <g id="sync-wallpaper">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M10.985 9.5H22.985C24.0896 9.5 24.985 10.3954 24.985 11.5V21.5C24.985 22.6046 24.0896 23.5 22.985 23.5H10.985C9.88042 23.5 8.98499 22.6046 8.98499 21.5V11.5C8.98499 10.3954 9.88042 9.5 10.985 9.5ZM10.985 11.5V21.5H22.985V11.5H10.985ZM12.985 19.5L15.985 13.5L17.985 17.5L18.985 16L20.985 19.5H12.985Z"></path>
      </g>
      <g id="sync-tooltip">
        <path d="M13.7748 19.098H15.277V17.7043H13.7748V19.098Z" fill="var(--cros-sys-on_surface)"></path>
        <path d="M11.5177 12.9005C11.5177 11.3521 12.8602 10.098 14.5177 10.098C16.1752 10.098 17.5177 11.3521 17.5177 12.9005C17.5177 13.7994 16.9276 14.2712 16.3531 14.7305C15.808 15.1662 15.277 15.5908 15.277 16.3583H13.7748C13.7748 15.0822 14.4791 14.5905 15.0984 14.1583C15.5842 13.8191 16.0177 13.5166 16.0177 12.9005C16.0177 12.1298 15.3427 11.4993 14.5177 11.4993C13.6927 11.4993 13.0177 12.1298 13.0177 12.9005H11.5177Z" fill="var(--cros-sys-on_surface)"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M6.5177 14.5C6.5177 10.084 10.1017 6.5 14.5177 6.5C18.9337 6.5 22.5177 10.084 22.5177 14.5C22.5177 18.916 18.9337 22.5 14.5177 22.5C10.1017 22.5 6.5177 18.916 6.5177 14.5ZM8.5177 14.5C8.5177 17.8075 11.2102 20.5 14.5177 20.5C17.8252 20.5 20.5177 17.8075 20.5177 14.5C20.5177 11.1925 17.8252 8.5 14.5177 8.5C11.2102 8.5 8.5177 11.1925 8.5177 14.5Z" fill="var(--cros-sys-on_surface)"></path>
      </g>
      <g id="sync-chrome">
        <path d="M9.61346 19.6886L3.22771 8.62723C1.93237 10.869 1.2503 13.4125 1.25012 16.0016C1.24994 18.5908 1.93167 21.1344 3.22669 23.3763C4.52079 25.6193 6.38284 27.4817 8.62542 28.7761C10.868 30.0706 13.412 30.7515 16.0013 30.7502L22.387 19.6888V19.6869C21.7414 20.8098 20.8101 21.7419 19.6876 22.3882C18.8489 22.8725 17.923 23.1868 16.9628 23.3133C16.0026 23.4397 15.027 23.3757 14.0915 23.125C13.156 22.8744 12.2791 22.4418 11.5107 21.8522C10.7424 21.2626 10.0977 20.5274 9.61346 19.6886V19.6886Z" fill="#34A853"></path>
        <path d="M22.3865 19.6883L16.0008 30.7497C18.5898 30.7507 21.1333 30.0697 23.3755 28.7753C25.6177 27.4809 27.4794 25.6187 28.7733 23.3761C30.0685 21.1338 30.7502 18.5898 30.7498 16.0003C30.7495 13.4108 30.067 10.8671 28.7712 8.62517H15.9998L15.9982 8.62616C17.2934 8.6238 18.5662 8.96439 19.6872 9.61335C21.381 10.5914 22.617 12.2023 23.1233 14.0917C23.6295 15.9812 23.3645 17.9943 22.3865 19.6883V19.6883Z" fill="#FCC934"></path>
        <path d="M16 23.375C20.0731 23.375 23.375 20.0731 23.375 16C23.375 11.9269 20.0731 8.625 16 8.625C11.9269 8.625 8.625 11.9269 8.625 16C8.625 20.0731 11.9269 23.375 16 23.375Z" fill="white"></path>
        <path d="M16.0003 21.8398C19.2247 21.8398 21.8386 19.2256 21.8386 16.0009C21.8386 12.7762 19.2247 10.162 16.0003 10.162C12.7758 10.162 10.1619 12.7762 10.1619 16.0009C10.1619 19.2256 12.7758 21.8398 16.0003 21.8398Z" fill="#1A73E8"></path>
        <path d="M16.0003 8.62545H28.7718C27.4782 6.38266 25.6167 4.52018 23.3747 3.22544C21.1327 1.9307 18.5893 1.24936 16.0003 1.25C13.411 1.2494 10.8672 1.93093 8.62503 3.226C6.38281 4.52108 4.52128 6.38401 3.22778 8.62727L9.61351 19.6886L9.61517 19.6895C8.96549 18.5689 8.62404 17.2962 8.6255 16.0009C8.6255 14.0448 9.40248 12.1688 10.7855 10.7857C12.1686 9.40249 14.0444 8.62545 16.0003 8.62545V8.62545Z" fill="#EA4335"></path>
      </g>
      <g id="arc-vm-data-migration-icon">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M3.799805 3.800049H13.3998V13.4H3.799805V3.800049ZM6.9998 7.00005V10.20005H10.1998V7.00005H6.9998ZM3.799805 16.6H13.3998V26.2H3.799805V16.6ZM6.9998 19.8V23H10.1998V19.8H6.9998ZM16.5998 3.800049H26.1998V13.4H16.5998V3.800049ZM19.7998 7.00005V10.20005H22.9998V7.00005H19.7998ZM21.3998 14.6118L28.188 21.4L21.3998 28.1883L14.6116 21.4L21.3998 14.6118ZM21.3998 19.1373L19.1371 21.4L21.3998 23.6628L23.6625 21.4L21.3998 19.1373Z"></path>
      </g>
      <g id="google-g">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M15.515 18.948v-5.772h14.522c0.217 0.977 0.388 1.893 0.388 3.181 0 8.859 -5.942 15.158 -14.894 15.158C6.951 31.515 0 24.564 0 16S6.951 0.485 15.515 0.485c4.189 0 7.695 1.536 10.38 4.049L21.488 8.816C20.371 7.761 18.432 6.505 15.515 6.505c-5.135 0 -9.325 4.267 -9.325 9.495 0 5.229 4.189 9.495 9.325 9.495 5.942 0 8.13 -4.111 8.533 -6.547H15.515Z" fill="var(--oobe-card-radio-button-icon-color)"></path>
      </g>
      <g id="password" viewBox="0 -8 32 32">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M4.772 6.414 3.579 8.491l-1.825 -1.053L2.947 5.362H0.562v-2.105H2.947l-1.193 -2.063L3.579 0.141l1.193 2.063L5.965 0.141l1.825 1.053 -1.193 2.063h2.387v2.105H6.596L7.789 7.438l-1.825 1.053 -1.192 -2.077Zm-2.808 7.761v2.808h28.071v-2.808H1.965Zm11.018 -6.737 1.824 1.053L16 6.414l1.193 2.077 1.824 -1.053 -1.192 -2.077H20.211v-2.105h-2.386l1.192 -2.063 -1.824 -1.053L16 2.204 14.807 0.141l-1.824 1.053 1.192 2.063H11.789v2.105h2.386l-1.192 2.077Zm17.263 -6.245L29.053 3.256h2.386v2.105H29.053l1.193 2.077 -1.825 1.053 -1.193 -2.077 -1.192 2.077 -1.825 -1.053 1.193 -2.077h-2.387v-2.105h2.387l-1.193 -2.063 1.825 -1.053 1.192 2.063L28.421 0.141l1.825 1.053Z" fill="var(--oobe-card-radio-button-icon-color)"></path>
      </g>
    </defs>
  </svg>
</iron-iconset-svg>

<iron-iconset-svg name="oobe-40" size="40">
  <svg>
    <defs>
      <g id="welcome-accessibility" fill-rule="evenodd">
        <defs>
          <path id="a" d="M35.111 9.2C30.471 10.46 25.031 11 20 11c-5.031 0-10.471-.54-15.111-1.8L4 12.8c3.307.9 7.444 1.494 11 1.8V38h3V27h4v11h3V14.6c3.556-.306 7.693-.9 11-1.8l-.889-3.6zM20 9.2c1.956 0 3.556-1.62 3.556-3.6S21.956 2 20 2s-3.556 1.62-3.556 3.6 1.6 3.6 3.556 3.6z">
          </path>
        </defs>
        <g fill="none" fill-rule="evenodd">
          <path d="M0 0h40v40H0z"></path>
          <use fill="var(--oobe-adaptive-dialog-icon-fill-color)" fill-rule="nonzero" xlink:href="#a"></use>
        </g>
      </g>
      <g id="hid-touchscreen" fill="none">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M8 12.577c0 4.11 2.438 7.672 6 9.423v2.143C11.669 23.384 9.676 23 8 23a2 2 0 00-1.664.89l-2 3a2 2 0 00.159 2.427l7 8A2 2 0 0013 38h14a2 2 0 001.789-1.106l5-10A2 2 0 0034 26c0-1.468-.816-2.489-2.514-3.823-.524-.411-2.594-1.881-3.998-2.873C29.058 17.476 30 15.132 30 12.577 30 6.735 25.075 2 19 2S8 6.735 8 12.577zm16 4.71V13a5 5 0 00-10 0v9-4.713c-1.237-1.214-2-2.876-2-4.71 0-3.718 3.134-6.73 7-6.73 3.866-.001 7 3.012 7 6.73 0 1.834-.763 3.496-2 4.71zM18 27a2 2 0 01-2.743 1.857c-2.536-1.015-4.624-1.607-6.23-1.793l-.514.771L13.908 34h11.856l4.012-8.025a9.567 9.567 0 00-.762-.652c-.568-.447-3.435-2.472-4.645-3.323h-4.37L20 13a1 1 0 00-2 0v14z" fill="#5F6368">
        </path>
      </g>
      <g id="hid-mouse" fill="none" fill-rule="evenodd">
        <path d="M0 0h40v40H0"></path>
        <path d="M21 1.783V15h11.667c0-6.8-5.092-12.4-11.667-13.217zm-1 35.55c7.183 0 13-5.966 13-13.333v-7H7v7c0 7.367 5.818 13.333 13 13.333zM19 1.78C12.237 2.597 7 8.198 7 15h12V1.78z" fill="#5A5A5A">
        </path>
      </g>
      <g id="hid-keyboard" fill="none" fill-rule="evenodd">
        <path d="M33.333 8.333H6.667c-1.842 0-3.317 1.492-3.317 3.334l-.017 16.666c0 1.842 1.492 3.334 3.334 3.334h26.666c1.842 0 3.334-1.492 3.334-3.334V11.667c0-1.842-1.492-3.334-3.334-3.334zm-15 5h3.334v3.334h-3.334v-3.334zm0 5h3.334v3.334h-3.334v-3.334zm-5-5h3.334v3.334h-3.334v-3.334zm0 5h3.334v3.334h-3.334v-3.334zm-1.666 3.334H8.333v-3.334h3.334v3.334zm0-5H8.333v-3.334h3.334v3.334zm15 11.666H13.333V25h13.334v3.333zm0-6.666h-3.334v-3.334h3.334v3.334zm0-5h-3.334v-3.334h3.334v3.334zm5 5h-3.334v-3.334h3.334v3.334zm0-5h-3.334v-3.334h3.334v3.334z" fill="#5A5A5A">
        </path>
        <path d="M0 0h40v40H0V0zm0 0h40v40H0V0z" fill="#D8D8D8">
        </path>
      </g>
      <g id="welcome-language" fill="none" fill-rule="evenodd">
        <path d="M0 0h40v40H0z"></path>
        <path fill="var(--oobe-adaptive-dialog-icon-fill-color)" fill-rule="nonzero" d="M19.984 4C11.152 4 4 11.168 4 20s7.152 16 15.984 16C28.832 36 36 28.832 36 20S28.832 4 19.984 4zm11.088 9.6h-4.72c-.512-2-1.248-3.92-2.208-5.696a12.847 12.847 0 0 1 6.928 5.696zM20 7.264a22.539 22.539 0 0 1 3.056 6.336h-6.112A22.539 22.539 0 0 1 20 7.264zM7.616 23.2A13.187 13.187 0 0 1 7.2 20c0-1.104.16-2.176.416-3.2h5.408c-.128 1.056-.224 2.112-.224 3.2s.096 2.144.224 3.2H7.616zm1.312 3.2h4.72c.512 2 1.248 3.92 2.208 5.696A12.779 12.779 0 0 1 8.928 26.4zm4.72-12.8h-4.72a12.779 12.779 0 0 1 6.928-5.696 25.039 25.039 0 0 0-2.208 5.696zM20 32.736a22.539 22.539 0 0 1-3.056-6.336h6.112A22.539 22.539 0 0 1 20 32.736zm3.744-9.536h-7.488C16.112 22.144 16 21.088 16 20s.112-2.16.256-3.2h7.488c.144 1.04.256 2.112.256 3.2s-.112 2.144-.256 3.2zm.4 8.896a25.039 25.039 0 0 0 2.208-5.696h4.72a12.847 12.847 0 0 1-6.928 5.696zm2.832-8.896c.128-1.056.224-2.112.224-3.2s-.096-2.144-.224-3.2h5.408c.256 1.024.416 2.096.416 3.2s-.16 2.176-.416 3.2h-5.408z">
        </path>
      </g>
      <g id="theme-choobe">
        <path d="M7.86667 7C6.83574 7 6 7.89543 6 9V31C6 32.1046 6.83574 33 7.86667 33H20V27C16.3917 27 13.4667 23.866 13.4667 20C13.4667 16.134 16.3917 13 20 13V7H7.86667Z" fill="var(--oobe-duotone-primary)"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M31 9H20V7H31C32.6569 7 34 8.34315 34 10V30C34 31.6569 32.6569 33 31 33H20V31H31C31.5523 31 32 30.5523 32 30V10C32 9.44772 31.5523 9 31 9Z" fill="var(--oobe-duotone-secondary)" fill-opacity="var(--oobe-duotone-secondary-opacity)"></path>
        <path d="M20 27C23.866 27 27 23.866 27 20C27 16.134 23.866 13 20 13V27Z"  fill="var(--oobe-duotone-secondary)" fill-opacity="var(--oobe-duotone-secondary-opacity)"></path>
      </g>
      <g id="scroll-choobe">
        <path d="M8 16C8 14.8954 8.89543 14 10 14H30C31.1046 14 32 14.8954 32 16V24C32 25.1046 31.1046 26 30 26H10C8.89543 26 8 25.1046 8 24V16Z" fill="var(--oobe-duotone-primary)"></path>
        <path d="M19.134 3.5C19.5189 2.83333 20.4811 2.83333 20.866 3.5L24.3301 9.5C24.715 10.1667 24.2339 11 23.4641 11H16.5359C15.7661 11 15.285 10.1667 15.6699 9.5L19.134 3.5Z" fill="var(--oobe-duotone-secondary)" fill-opacity="var(--oobe-duotone-secondary-opacity)"></path>
        <path d="M20.866 36.5C20.4811 37.1667 19.5189 37.1667 19.134 36.5L15.6699 30.5C15.285 29.8333 15.7661 29 16.5359 29L23.4641 29C24.2339 29 24.715 29.8333 24.3301 30.5L20.866 36.5Z" fill="var(--oobe-duotone-secondary)" fill-opacity="var(--oobe-duotone-secondary-opacity)"></path>
      </g>
      <g id="display-size-choobe">
        <rect x="6" y="23" width="10" height="10" rx="2" fill="var(--oobe-duotone-secondary)" fill-opacity="var(--oobe-duotone-secondary-opacity)"></rect>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M10 8C10 6.89543 10.8954 6 12 6H32C33.1046 6 34 6.89543 34 8V28C34 29.1046 33.1046 30 32 30H18V23C18 21.8954 17.1046 21 16 21H10V8ZM17 11H21H24H28V14H24V24H21V14H17V11Z" fill="var(--oobe-duotone-primary)"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M10 25H8V27H10V31H12V27H14V25H12H10Z" fill="var(--oobe-duotone-cut-out)"></path>
      </g>
      <g id="drive-pinning-choobe">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M21.2225 20.9654C22.8642 18.8141 25.3591 17.3488 28.2021 17.0742L22.2143 6.60001H13.0231V6.61344L21.2225 20.9654ZM19.6218 24.0688H14.5685L9.95941 32.1313H20.5781C19.6885 30.6368 19.1775 28.8906 19.1775 27.025C19.1775 25.9959 19.333 25.0031 19.6218 24.0688ZM3.03906 24.0688L11.8541 8.6426C11.8541 8.6426 16.4555 16.7051 16.4631 16.7051L7.64813 32.1179L3.03906 24.0688Z" fill="var(--oobe-duotone-primary)"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M37.2375 27.025C37.2375 31.4778 33.6278 35.0875 29.175 35.0875C24.7222 35.0875 21.1125 31.4778 21.1125 27.025C21.1125 22.5722 24.7222 18.9625 29.175 18.9625C33.6278 18.9625 37.2375 22.5722 37.2375 27.025Z" fill="var(--oobe-duotone-secondary)" fill-opacity="var(--oobe-duotone-secondary-opacity)"></path>
        <path d="M31.2291 23.0049C31.5789 22.6317 32.1461 22.6317 32.496 23.0049C32.8458 23.378 32.8458 23.9831 32.496 24.3562L28.9126 28.1784C28.5628 28.5516 27.9956 28.5516 27.6457 28.1784L25.8541 26.2673C25.5042 25.8942 25.5042 25.2891 25.8541 24.916C26.2039 24.5428 26.7711 24.5428 27.121 24.916L28.2792 26.1514L31.2291 23.0049Z" fill="var(--oobe-duotone-cut-out)"></path>
        <path d="M25.6812 29.605C25.236 29.605 24.875 29.99 24.875 30.465C24.875 30.94 25.236 31.325 25.6812 31.325H32.6687C33.114 31.325 33.475 30.94 33.475 30.465C33.475 29.99 33.114 29.605 32.6687 29.605H25.6812Z" fill="var(--oobe-duotone-bg)"></path>
      </g>
      <g id="category-selected">
        <rect width="40" height="40" rx="20" fill="var(--cros-sys-primary)"></rect>
        <path d="M18 24.4L14 20.4L15.4 19L18 21.6L24.6 15L26 16.4L18 24.4Z" fill="var(--cros-sys-primary_container)"></path>
      </g>
    </defs>
  </svg>
</iron-iconset-svg>

<iron-iconset-svg name="oobe-48" size="48">
  <svg>
    <defs>
      <g id="avatar" fill-rule="evenodd">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M24 13.2C20.508 13.2 17.7 16.008 17.7 19.5C17.7 22.992 20.508 25.8 24 25.8C27.492 25.8 30.3 22.992 30.3 19.5C30.3 16.008 27.492 13.2 24 13.2ZM21.3 19.5C21.3 20.994 22.506 22.2 24 22.2C25.494 22.2 26.7 20.994 26.7 19.5C26.7 18.006 25.494 16.8 24 16.8C22.506 16.8 21.3 18.006 21.3 19.5Z" fill="var(--oobe-card-radio-button-icon-color)"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M24 4.8C13.4016 4.8 4.8 13.4016 4.8 24C4.8 34.5984 13.4016 43.2 24 43.2C34.5984 43.2 43.2 34.5984 43.2 24C43.2 13.4016 34.5984 4.8 24 4.8ZM15.126 35.304C15.9 33.684 20.616 32.1 24 32.1C27.384 32.1 32.118 33.684 32.874 35.304C30.426 37.248 27.348 38.4 24 38.4C20.652 38.4 17.574 37.248 15.126 35.304ZM24 28.5C26.628 28.5 32.874 29.562 35.448 32.694C37.284 30.282 38.4 27.276 38.4 24C38.4 16.062 31.938 9.6 24 9.6C16.062 9.6 9.6 16.062 9.6 24C9.6 27.276 10.716 30.282 12.552 32.694C15.126 29.562 21.372 28.5 24 28.5Z" fill="var(--oobe-card-radio-button-icon-color)"></path>
      </g>
      <g id="child-user" fill-rule="evenodd">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M24 3.55566C27.3 3.55566 30 6.25566 30 9.55566C30 12.8557 27.3 15.5557 24 15.5557C20.7 15.5557 18 12.8557 18 9.55566C18 6.25566 20.7 3.55566 24 3.55566ZM11 24.7757C11 20.6757 17.84 17.5557 24 17.5557C30.16 17.5557 37 20.6757 37 24.7757V36.3157C37 38.6357 34.82 40.6557 31.8 41.9557V37.4957C31.8 35.6157 29.38 34.0757 26.6 33.4557C25.74 33.2557 24.86 33.1557 24 33.1557C20.66 33.1557 16.98 34.6957 16.32 36.8157C18.62 37.7757 21.36 38.3557 24 38.3557C24.66 38.3557 25.34 38.2957 26 38.2157V43.4157C25.34 43.4957 24.66 43.5557 24 43.5557C21.32 43.5557 18.52 42.9557 16.2 41.9557C13.18 40.6357 11 38.6357 11 36.3157V24.7757ZM28 25.5557C28 27.7648 26.2091 29.5557 24 29.5557C21.7909 29.5557 20 27.7648 20 25.5557C20 23.3465 21.7909 21.5557 24 21.5557C26.2091 21.5557 28 23.3465 28 25.5557Z" fill="var(--oobe-card-radio-button-icon-color)"></path>
      </g>
      <g id="add-work">
        <path d="M10.4107 41C9.17853 41 8.12835 40.5843 7.26021 39.753C6.42007 38.8939 6 37.8547 6 36.6354V18.3646C6 17.1453 6.42007 16.12 7.26021 15.2886C8.12835 14.4295 9.17853 14 10.4107 14H16V10.3646C16 9.14529 16.4201 8.11995 17.2602 7.2886C18.1284 6.42953 19.1785 6 20.4107 6H27.5893C28.8215 6 29.8576 6.42953 30.6978 7.2886C31.5659 8.11995 32 9.14529 32 10.3646V14H37.5473C38.7795 14 39.8296 14.4295 40.6978 15.2886C41.5659 16.12 42 17.1453 42 18.3646V36.6354C42 37.8547 41.5659 38.8939 40.6978 39.753C39.8296 40.5843 38.7795 41 37.5473 41H10.4107ZM10 37H38V18H10V37ZM20 14H28V10H20V14Z" fill="var(--oobe-card-radio-button-icon-color)"/>
      </g>
      <g id="school-account">
        <path d="M23.95 42.1L9.35 34.1V22.1L1.75 18L23.95 5.85L46.25 18V34H43V19.9L38.6 22.1V34.1L23.95 42.1ZM23.95 26.4L39.35 18L23.95 9.75L8.65 18L23.95 26.4ZM23.95 38.4L35.3 32.15V24.1L23.95 30.15L12.6 24V32.15L23.95 38.4Z" fill="var(--oobe-card-radio-button-icon-color)"/>
      </g>
      <g id="child-account">
        <path d="M25.05 37.1L38.4 18.6L25.05 5.6L11.7 18.6L25.05 37.1ZM19.4 46.6C17.6667 46.6 16.1167 46.0833 14.75 45.05C13.4167 43.9833 12.5 42.6333 12 41C11.8 40.2 11.3667 39.5667 10.7 39.1C10.0333 38.6333 9.31667 38.4 8.55 38.4C7.98333 38.4 7.45 38.5167 6.95 38.75C6.48333 38.95 6.08333 39.25 5.75 39.65L2.6 37.05C3.33333 36.15 4.21667 35.4667 5.25 35C6.28333 34.5333 7.38333 34.3 8.55 34.3C10.2833 34.3 11.8333 34.8167 13.2 35.85C14.5667 36.8833 15.4833 38.2167 15.95 39.85C16.1833 40.65 16.6167 41.3 17.25 41.8C17.8833 42.2667 18.6 42.5 19.4 42.5C20.1 42.5 20.7167 42.3333 21.25 42C21.8167 41.6667 22.25 41.2167 22.55 40.65L8.35 21C7.78333 20.2 7.53333 19.3 7.6 18.3C7.7 17.2667 8.11667 16.3833 8.85 15.65L22.35 2.55C22.7167 2.15 23.1333 1.86667 23.6 1.7C24.1 1.5 24.5833 1.4 25.05 1.4C25.55 1.4 26.0333 1.5 26.5 1.7C26.9667 1.86667 27.4 2.15 27.8 2.55L41.3 15.65C42.0333 16.35 42.4333 17.2167 42.5 18.25C42.6 19.2833 42.35 20.2 41.75 21L26.1 42.7C25.4 43.9 24.4667 44.85 23.3 45.55C22.1667 46.25 20.8667 46.6 19.4 46.6Z" fill="var(--oobe-card-radio-button-icon-color)"/>
      </g>
      <g id="managed">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M4.80005 40.7999V7.19995H28.8V16.8H43.2001V40.7999H4.80005ZM19.2 21.6H24V26.4H19.2V21.6ZM28.8 26.4H33.6V31.1999H28.8V36H38.4001V21.6H28.8V26.4ZM19.2 31.1999H24V36H19.2V31.1999ZM14.4 31.1999H9.60005V36H14.4V31.1999ZM14.4 21.6H9.60005V26.4H14.4V21.6ZM19.2 12H24V16.8H19.2V12ZM14.4 12H9.60005V16.8H14.4V12Z" fill="var(--oobe-card-radio-button-icon-color)"></path>
      </g>
      <g id="person-add" fill-rule="evenodd">
        <path fill="var(--oobe-card-radio-button-icon-color)" fill-rule="evenodd" d="M18 24c4.42 0 8-3.58 8-8s-3.58-8-8-8-8 3.58-8 8 3.58 8 8 8zm0-12c2.2 0 4 1.8 4 4s-1.8 4-4 4-4-1.8-4-4 1.8-4 4-4zM2 34c0-5.32 10.66-8 16-8s16 2.68 16 8v6H2v-6zm4 2v-1.98C6.4 32.58 12.6 30 18 30s11.6 2.58 12 4v2H6zm30-14v6h4v-6h6v-4h-6v-6h-4v6h-6v4h6z"></path>
      </g>
      <g id="supervised-user" fill-rule="evenodd">
        <path fill="var(--oobe-card-radio-button-icon-color)" fill-rule="evenodd" d="M24 4C12.96 4 4 12.96 4 24s8.96 20 20 20 20-8.96 20-20S35.04 4 24 4zm-5.28 8c-3.88 0-7 3.12-7 7s3.12 7 7 7 7-3.12 7-7-3.12-7-7-7zm0 10c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3zM37 25a5 5 0 11-10 0 5 5 0 0110 0zm-5 6.24c1.52 0 3.7.36 5.66 1.04C39.14 29.86 40 27.04 40 24c0-8.82-7.18-16-16-16S8 15.18 8 24c0 2.54.6 4.94 1.66 7.08 3.18-1.48 7.06-2.06 9.06-2.06.98 0 2.44.14 4.04.46-1.64.88-3.08 2.02-3.92 3.54h-.12c-2.16 0-4.8.58-6.82 1.42 2.52 2.92 6.08 4.92 10.1 5.42v-3.62c0-.98.6-1.82 1.5-2.52.34-.26.72-.48 1.12-.7.01 0 .015-.005.02-.01.005-.005.01-.01.02-.01.4-.2.84-.4 1.3-.58.92-.36 1.92-.62 2.88-.82 1.16-.24 2.28-.36 3.16-.36z"></path>
      </g>
      <g id="os-trial-install" fill-rule="evenodd">
        <path fill="var(--oobe-card-radio-button-icon-color)" clip-rule="evenodd" d="M7.20002 27.5808c0 3.9768 3.22318 7.2 7.19998 7.2H36c2.6496.0 4.8-2.1504 4.8-4.8.0-2.6496-2.1504-4.8-4.8-4.8H32.3856V22.8c0-4.6392-3.7608-8.4-8.4-8.4-3.792.0-6.96 2.5296-8.004 5.9808H14.4c-3.9768.0-7.19998 3.2232-7.19998 7.2zm5.70958-11.832C15.2496 12.0696 19.3152 9.59998 24 9.59998c6.504.0 11.8968 4.70642 12.9864 10.89842C41.8176 21 45.6 25.0344 45.6 30c0 5.3016-4.2984 9.6-9.6 9.6H14.4c-6.62638.0-11.99998-5.3712-11.99998-12 0-6.1176 4.5936-11.1096 10.50958-11.8512zM30.608 25.2l-2.82-2.82-2.18 2.16V19.2h-4v5.34l-2.18-2.16-2.82 2.82 5.58 5.58 1.42 1.42 1.42-1.42 5.58-5.58z"></path>
      </g>
      <g id="os-trial-try" fill-rule="evenodd">
        <path fill="var(--oobe-card-radio-button-icon-color)" clip-rule="evenodd" d="M30.1014 22.9133h1.7747v3.6226H26.4V12.0453h3.7014L24.6 4.80005 19.2 12.0453h3.6V26.5359H17.6789V22.7865C18.9211 22.1163 19.8084 20.8302 19.8084 19.2906c0-2.1917-1.7569-3.9849-3.9042-3.9849-2.1473.0-3.9042 1.7932-3.9042 3.9849.0 1.5396.8873 2.8257 2.1296 3.4959v3.7494C14.1296 28.5465 15.4301 30 17.4 30h5.4v6C21.54 36.6702 20.8732 37.6755 20.8732 39.2151c0 2.2099 1.7569 3.9849 3.9043 3.9849C26.9248 43.2 28.6817 41.425 28.6817 39.2151c0-1.5396-1.0217-2.5449-2.2817-3.2151V30h5.4761c1.9698.0 3.5492-1.4535 3.5492-3.4641V22.9133H37.2V15.668H30.1014v7.2453z"></path>
      </g>
      <g id="pause" opacity="0.6">
        <g style="mix-blend-mode:multiply">
          <circle cx="24" cy="24" r="22" fill="#202124"></circle>
        </g>
        <path d="M22.4 16H17.6V32H22.4V16Z" fill="white"></path>
        <path d="M30.4 16H25.6V32H30.4V16Z" fill="white"></path>
      </g>
      <g id="play" opacity="0.6">
        <g style="mix-blend-mode:multiply">
          <circle cx="24" cy="24" r="22" fill="#202124"></circle>
        </g>
        <path fill-rule="evenodd" clip-rule="evenodd"
            d="M17.6 33.5999L33.6 23.9999L17.6 14.3999V33.5999Z" fill="white">
        </path>
      </g>
      <g id="spark">
        <path d="M24 43.6032C24 40.884 23.496 38.3448 22.4712 35.9712C21.4736 33.6473 20.0416 31.5351 18.252 29.7481C16.465 27.9585 14.3528 26.5264 12.0288 25.5289C9.617 24.4998 7.01887 23.9794 4.3968 24C7.116 24 9.6552 23.496 12.0288 22.4712C16.7271 20.4542 20.4671 16.7039 22.4712 12.0001C23.496 9.61925 24 7.08005 24 4.39685C24 7.07765 24.504 9.61925 25.5288 12.0001C27.532 16.7144 31.2856 20.4681 36 22.4712C38.3808 23.4936 40.92 24 43.6032 24C40.9224 24 38.3808 24.5041 36 25.5289C31.2958 27.5335 27.5453 31.2745 25.5288 35.9737C24.5004 38.384 23.98 40.9828 24 43.6032Z"></path>
      </g>
      <g id="personalized-apps-icon">
        <path d="M11.3 40C10.3667 40 9.58333 39.6833 8.95 39.05C8.31667 38.4167 8 37.6333 8 36.7C8 35.7667 8.31667 34.9833 8.95 34.35C9.58333 33.7167 10.3667 33.4 11.3 33.4C12.2333 33.4 13.0167 33.7167 13.65 34.35C14.2833 34.9833 14.6 35.7667 14.6 36.7C14.6 37.6333 14.2833 38.4167 13.65 39.05C13.0167 39.6833 12.2333 40 11.3 40ZM24 40C23.0667 40 22.2833 39.6833 21.65 39.05C21.0167 38.4167 20.7 37.6333 20.7 36.7C20.7 35.7667 21.0167 34.9833 21.65 34.35C22.2833 33.7167 23.0667 33.4 24 33.4C24.9333 33.4 25.7167 33.7167 26.35 34.35C26.9833 34.9833 27.3 35.7667 27.3 36.7C27.3 37.6333 26.9833 38.4167 26.35 39.05C25.7167 39.6833 24.9333 40 24 40ZM36.7 40C35.7667 40 34.9833 39.6833 34.35 39.05C33.7167 38.4167 33.4 37.6333 33.4 36.7C33.4 35.7667 33.7167 34.9833 34.35 34.35C34.9833 33.7167 35.7667 33.4 36.7 33.4C37.6333 33.4 38.4167 33.7167 39.05 34.35C39.6833 34.9833 40 35.7667 40 36.7C40 37.6333 39.6833 38.4167 39.05 39.05C38.4167 39.6833 37.6333 40 36.7 40ZM11.3 27.3C10.3667 27.3 9.58333 26.9833 8.95 26.35C8.31667 25.7167 8 24.9333 8 24C8 23.0667 8.31667 22.2833 8.95 21.65C9.58333 21.0167 10.3667 20.7 11.3 20.7C12.2333 20.7 13.0167 21.0167 13.65 21.65C14.2833 22.2833 14.6 23.0667 14.6 24C14.6 24.9333 14.2833 25.7167 13.65 26.35C13.0167 26.9833 12.2333 27.3 11.3 27.3ZM24 27.3C23.0667 27.3 22.2833 26.9833 21.65 26.35C21.0167 25.7167 20.7 24.9333 20.7 24C20.7 23.0667 21.0167 22.2833 21.65 21.65C22.2833 21.0167 23.0667 20.7 24 20.7C24.9333 20.7 25.7167 21.0167 26.35 21.65C26.9833 22.2833 27.3 23.0667 27.3 24C27.3 24.9333 26.9833 25.7167 26.35 26.35C25.7167 26.9833 24.9333 27.3 24 27.3ZM36.7 27.3C35.7667 27.3 34.9833 26.9833 34.35 26.35C33.7167 25.7167 33.4 24.9333 33.4 24C33.4 23.0667 33.7167 22.2833 34.35 21.65C34.9833 21.0167 35.7667 20.7 36.7 20.7C37.6333 20.7 38.4167 21.0167 39.05 21.65C39.6833 22.2833 40 23.0667 40 24C40 24.9333 39.6833 25.7167 39.05 26.35C38.4167 26.9833 37.6333 27.3 36.7 27.3ZM11.3 14.6C10.3667 14.6 9.58333 14.2833 8.95 13.65C8.31667 13.0167 8 12.2333 8 11.3C8 10.3667 8.31667 9.58333 8.95 8.95C9.58333 8.31667 10.3667 8 11.3 8C12.2333 8 13.0167 8.31667 13.65 8.95C14.2833 9.58333 14.6 10.3667 14.6 11.3C14.6 12.2333 14.2833 13.0167 13.65 13.65C13.0167 14.2833 12.2333 14.6 11.3 14.6ZM24 14.6C23.0667 14.6 22.2833 14.2833 21.65 13.65C21.0167 13.0167 20.7 12.2333 20.7 11.3C20.7 10.3667 21.0167 9.58333 21.65 8.95C22.2833 8.31667 23.0667 8 24 8C24.9333 8 25.7167 8.31667 26.35 8.95C26.9833 9.58333 27.3 10.3667 27.3 11.3C27.3 12.2333 26.9833 13.0167 26.35 13.65C25.7167 14.2833 24.9333 14.6 24 14.6ZM36.7 14.6C35.7667 14.6 34.9833 14.2833 34.35 13.65C33.7167 13.0167 33.4 12.2333 33.4 11.3C33.4 10.3667 33.7167 9.58333 34.35 8.95C34.9833 8.31667 35.7667 8 36.7 8C37.6333 8 38.4167 8.31667 39.05 8.95C39.6833 9.58333 40 10.3667 40 11.3C40 12.2333 39.6833 13.0167 39.05 13.65C38.4167 14.2833 37.6333 14.6 36.7 14.6Z"></path>
      </g>
      <g id="keyboard" viewBox="0 0 48 48">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M43.2 7.19995H4.8C2.16 7.19995 0.024 9.35995 0.024 12L0 36C0 38.6399 2.16 40.7999 4.8 40.7999H43.2C45.84 40.7999 48 38.6399 48 36V12C48 9.35995 45.84 7.19995 43.2 7.19995ZM43.2 12V36H4.8V12H43.2ZM26.4 14.4H21.6V19.2H26.4V14.4ZM21.6 21.6H26.4V26.4H21.6V21.6ZM19.2 14.4H14.4V19.2H19.2V14.4ZM14.4 21.6H19.2V26.4H14.4V21.6ZM12 21.6H7.2V26.4H12V21.6ZM7.2 14.4H12V19.2H7.2V14.4ZM33.6 28.7999H14.4V33.5999H33.6V28.7999ZM28.8 21.6H33.6V26.4H28.8V21.6ZM33.6 14.4H28.8V19.2H33.6V14.4ZM36 21.6H40.8V26.4H36V21.6ZM40.8 14.4H36V19.2H40.8V14.4Z"></path>
      </g>
    </defs>
    </svg>
</iron-iconset-svg>

<iron-iconset-svg name="oobe-96" size="96">
  <svg>
    <defs>
      <g id="avatar" fill-rule="evenodd">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M48 26.4C41.016 26.4 35.4 32.016 35.4 39C35.4 45.984 41.016 51.6 48 51.6C54.984 51.6 60.6 45.984 60.6 39C60.6 32.016 54.984 26.4 48 26.4ZM42.6 39C42.6 41.988 45.012 44.4 48 44.4C50.988 44.4 53.4 41.988 53.4 39C53.4 36.012 50.988 33.6 48 33.6C45.012 33.6 42.6 36.012 42.6 39Z" fill="var(--oobe-card-radio-button-icon-color)"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M48 9.6C26.8032 9.6 9.59998 26.8032 9.59998 48C9.59998 69.1968 26.8032 86.4 48 86.4C69.1968 86.4 86.4 69.1968 86.4 48C86.4 26.8032 69.1968 9.6 48 9.6ZM30.2519 70.608C31.7999 67.368 41.2319 64.2 47.9999 64.2C54.7679 64.2 64.2359 67.368 65.7479 70.608C60.8519 74.496 54.6959 76.8 47.9999 76.8C41.3039 76.8 35.1479 74.496 30.2519 70.608ZM48 57C53.256 57 65.748 59.124 70.896 65.388C74.568 60.564 76.8 54.552 76.8 48C76.8 32.124 63.876 19.2 48 19.2C32.124 19.2 19.2 32.124 19.2 48C19.2 54.552 21.432 60.564 25.104 65.388C30.252 59.124 42.744 57 48 57Z" fill="var(--oobe-card-radio-button-icon-color)"></path>
      </g>
      <g id="child-user" fill-rule="evenodd">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M48 7.55566C54.6 7.55566 60 12.9557 60 19.5557C60 26.1557 54.6 31.5557 48 31.5557C41.4 31.5557 36 26.1557 36 19.5557C36 12.9557 41.4 7.55566 48 7.55566ZM22 49.9957C22 41.7957 35.68 35.5557 48 35.5557C60.32 35.5557 74 41.7957 74 49.9957V73.0757C74 77.7157 69.64 81.7557 63.6 84.3557V75.4357C63.6 71.6757 58.76 68.5957 53.2 67.3557C51.48 66.9557 49.72 66.7557 48 66.7557C41.32 66.7557 33.96 69.8357 32.64 74.0757C37.24 75.9957 42.72 77.1557 48 77.1557C49.32 77.1557 50.68 77.0357 52 76.8757V87.2757C50.68 87.4357 49.32 87.5557 48 87.5557C42.64 87.5557 37.04 86.3557 32.4 84.3557C26.36 81.7157 22 77.7157 22 73.0757V49.9957ZM56 51.5557C56 55.9739 52.4183 59.5557 48 59.5557C43.5817 59.5557 40 55.9739 40 51.5557C40 47.1374 43.5817 43.5557 48 43.5557C52.4183 43.5557 56 47.1374 56 51.5557Z" fill="var(--oobe-card-radio-button-icon-color)"></path>
      </g>
      <g id="person-add" fill-rule="evenodd">
        <path fill="var(--oobe-card-radio-button-icon-color)" fill-rule="evenodd" d="M36 48c8.84 0 16-7.16 16-16s-7.16-16-16-16-16 7.16-16 16 7.16 16 16 16zm0-24c4.4 0 8 3.6 8 8s-3.6 8-8 8-8-3.6-8-8 3.6-8 8-8zM4 68c0-10.64 21.32-16 32-16s32 5.36 32 16v12H4V68zm8 4v-3.96C12.8 65.16 25.2 60 36 60s23.2 5.16 24 8v4H12zm60-28v12h8V44h12v-8H80V24h-8v12H60v8h12z"></path>
      </g>
      <g id="supervised-user" fill-rule="evenodd">
        <path fill="var(--oobe-card-radio-button-icon-color)" fill-rule="evenodd" d="M48 8C25.92 8 8 25.92 8 48s17.92 40 40 40 40-17.92 40-40S70.08 8 48 8zM37.44 24c-7.76 0-14 6.24-14 14s6.24 14 14 14 14-6.24 14-14-6.24-14-14-14zm0 20c-3.32 0-6-2.68-6-6s2.68-6 6-6 6 2.68 6 6-2.68 6-6 6zM74 50c0 5.523-4.477 10-10 10s-10-4.477-10-10 4.477-10 10-10 10 4.477 10 10zM64 62.48c3.04 0 7.4.72 11.32 2.08C78.28 59.72 80 54.08 80 48c0-17.64-14.36-32-32-32S16 30.36 16 48c0 5.08 1.2 9.88 3.32 14.16 6.36-2.96 14.12-4.12 18.12-4.12 1.96 0 4.88.28 8.08.92-3.28 1.76-6.16 4.04-7.84 7.08h-.24c-4.32 0-9.6 1.16-13.64 2.84 5.04 5.84 12.16 9.84 20.2 10.84v-7.24c0-1.96 1.2-3.64 3-5.04.68-.52 1.44-.96 2.24-1.4.02 0 .03-.01.04-.02.01-.01.02-.02.04-.02.8-.4 1.68-.8 2.6-1.16 1.84-.72 3.84-1.24 5.76-1.64 2.32-.48 4.56-.72 6.32-.72z"></path>
      </g>
      <g id="add-work">
        <path d="M20.8215 83C18.3571 83 16.2567 82.1686 14.5204 80.5059C12.8401 78.7878 12 76.7094 12 74.2708V37.7292C12 35.2906 12.8401 33.2399 14.5204 31.5772C16.2567 29.8591 18.3571 29 20.8215 29H32V21.7292C32 19.2906 32.8401 17.2399 34.5204 15.5772C36.2567 13.8591 38.3571 13 40.8215 13H55.1785C57.6429 13 59.7153 13.8591 61.3956 15.5772C63.1319 17.2399 64 19.2906 64 21.7292V29H75.0945C77.5589 29 79.6593 29.8591 81.3956 31.5772C83.1319 33.2399 84 35.2906 84 37.7292V74.2708C84 76.7094 83.1319 78.7878 81.3956 80.5059C79.6593 82.1686 77.5589 83 75.0945 83H20.8215ZM20 75H76V37H20V75ZM40 29H56V21H40V29Z" fill="var(--oobe-card-radio-button-icon-color)"/>
      </g>
      <g id="school-account">
        <path d="M47.9 84.2L18.7 68.2V44.2L3.5 36L47.9 11.7L92.5 36V68H86V39.8L77.2 44.2V68.2L47.9 84.2ZM47.9 52.8L78.7 36L47.9 19.5L17.3 36L47.9 52.8ZM47.9 76.8L70.6 64.3V48.2L47.9 60.3L25.2 48V64.3L47.9 76.8Z" fill="var(--oobe-card-radio-button-icon-color)"/>
      </g>
      <g id="child-account">
        <path d="M50.1 74.2L76.8 37.2L50.1 11.2L23.4 37.2L50.1 74.2ZM38.8 93.2C35.3333 93.2 32.2333 92.1667 29.5 90.1C26.8333 87.9667 25 85.2667 24 82C23.6 80.4 22.7333 79.1333 21.4 78.2C20.0667 77.2667 18.6333 76.8 17.1 76.8C15.9667 76.8 14.9 77.0333 13.9 77.5C12.9667 77.9 12.1667 78.5 11.5 79.3L5.2 74.1C6.66666 72.3 8.43333 70.9333 10.5 70C12.5667 69.0667 14.7667 68.6 17.1 68.6C20.5667 68.6 23.6667 69.6333 26.4 71.7C29.1333 73.7667 30.9667 76.4333 31.9 79.7C32.3667 81.3 33.2333 82.6 34.5 83.6C35.7667 84.5333 37.2 85 38.8 85C40.2 85 41.4333 84.6667 42.5 84C43.6333 83.3333 44.5 82.4333 45.1 81.3L16.7 42C15.5667 40.4 15.0667 38.6 15.2 36.6C15.4 34.5333 16.2333 32.7667 17.7 31.3L44.7 5.1C45.4333 4.3 46.2667 3.73334 47.2 3.4C48.2 3 49.1667 2.8 50.1 2.8C51.1 2.8 52.0667 3 53 3.4C53.9333 3.73334 54.8 4.3 55.6 5.1L82.6 31.3C84.0667 32.7 84.8667 34.4333 85 36.5C85.2 38.5667 84.7 40.4 83.5 42L52.2 85.4C50.8 87.8 48.9333 89.7 46.6 91.1C44.3333 92.5 41.7333 93.2 38.8 93.2Z" fill="var(--oobe-card-radio-button-icon-color)"/>
      </g>
      <g id="managed">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M9.60001 81.6V14.4H57.6V33.6H86.4V81.6H9.60001ZM38.4 43.2H48V52.8H38.4V43.2ZM57.6 52.8H67.2V62.4H57.6V72H76.8V43.2H57.6V52.8ZM38.4 62.4H48V72H38.4V62.4ZM28.8 62.4H19.2V72H28.8V62.4ZM28.8 43.2H19.2V52.8H28.8V43.2ZM38.4 24H48V33.6H38.4V24ZM28.8 24H19.2V33.6H28.8V24Z" fill="var(--oobe-card-radio-button-icon-color)"></path>
      </g>
    </defs>
    </svg>
</iron-iconset-svg>
`;
document.head.appendChild(template.content);
