import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2020 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles">:host{--oobe-slide-horizontal-padding:24px}#slide-container{align-items:center;display:flex;flex-direction:column;justify-content:start}#illustration-container{max-height:200px;max-width:calc(380px - 2 * var(--oobe-slide-horizontal-padding))}#context-container{align-items:center;flex-direction:column;justify-content:start}#slide-title{padding-top:8px}:host-context(.jelly-enabled) #slide-title{padding-top:16px}#slide-title ::slotted(*){color:var(--cros-text-color-prominent);font-family:var(--oobe-header-font-family);font-size:22px;font-weight:500;line-height:28px}:host-context(.jelly-enabled) #slide-title ::slotted(*){color:var(--cros-sys-on_surface);font-family:var(--cros-display-7-font-family);font-size:var(--cros-display-7-font-size);font-weight:var(--cros-display-7-font-weight);line-height:var(--cros-display-7-line-height)}#slide-title[is-warning] ::slotted(*){color:var(--cros-text-color-alert)}:host-context(.jelly-enabled) #slide-title[is-warning] ::slotted(*){color:var(--cros-sys-error)}#slide-text{padding-top:8px}:host-context(.jelly-enabled) #slide-text{padding-top:16px}#slide-text ::slotted(*){color:var(--cros-text-color-secondary);font-family:var(--oobe-default-font-family);font-size:14px;font-weight:400;line-height:20px}:host-context(.jelly-enabled) #slide-text ::slotted(*){color:var(--cros-sys-on_surface_variant);font-family:var(--cros-body-2-font-family);font-size:var(--cros-body-2-font-size);font-weight:var(--cros-body-2-font-weight);line-height:var(--cros-body-2-line-height)}#context-container ::slotted(*){padding-inline-end:var(--oobe-slide-horizontal-padding);padding-inline-start:var(--oobe-slide-horizontal-padding);text-align:center}.multiline{white-space:normal}</style>
<div id="slide-container" class="flex layout">
  <div id="illustration-container" class="oobe-illustration">
    <slot name="slide-img"></slot>
  </div>
  <div id="context-container" class="flex layout vertical">
    <div id="slide-title" is-warning$="[[isWarning]]">
      <slot name="title" class="multiline"></slot>
    </div>
    <div id="slide-text">
      <slot name="text" class="multiline"></slot>
    </div>
  </div>
</div>
<!--_html_template_end_-->`;
}
