// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * This file contains typedefs for chromeOS OOBE properties.
 */
export var OobeTypes;
(function (OobeTypes) {
    /**
     * Fatal Error Codes from SignInFatalErrorScreen
     */
    let FatalErrorCode;
    (function (FatalErrorCode) {
        FatalErrorCode[FatalErrorCode["UNKNOWN"] = 0] = "UNKNOWN";
        FatalErrorCode[FatalErrorCode["SCRAPED_PASSWORD_VERIFICATION_FAILURE"] = 1] = "SCRAPED_PASSWORD_VERIFICATION_FAILURE";
        FatalErrorCode[FatalErrorCode["INSECURE_CONTENT_BLOCKED"] = 2] = "INSECURE_CONTENT_BLOCKED";
        FatalErrorCode[FatalErrorCode["MISSING_GAIA_INFO"] = 3] = "MISSING_GAIA_INFO";
        FatalErrorCode[FatalErrorCode["CUSTOM"] = 4] = "CUSTOM";
    })(FatalErrorCode = OobeTypes.FatalErrorCode || (OobeTypes.FatalErrorCode = {}));
    /**
     * Screen steps used by EnterpriseEnrollmentElement. Defined here to
     * avoid circular dependencies since it is needed by cr_ui.js
     */
    let EnrollmentStep;
    (function (EnrollmentStep) {
        EnrollmentStep["LOADING"] = "loading";
        EnrollmentStep["SIGNIN"] = "signin";
        EnrollmentStep["WORKING"] = "working";
        EnrollmentStep["ATTRIBUTE_PROMPT"] = "attribute-prompt";
        EnrollmentStep["ERROR"] = "error";
        EnrollmentStep["SUCCESS"] = "success";
        EnrollmentStep["CHECKING"] = "checking";
        EnrollmentStep["TPM_CHECKING"] = "tpm-checking";
        EnrollmentStep["KIOSK_ENROLLMENT"] = "kiosk-enrollment";
        EnrollmentStep["ATTRIBUTE_PROMPT_ERROR"] = "attribute-prompt-error";
    })(EnrollmentStep = OobeTypes.EnrollmentStep || (OobeTypes.EnrollmentStep = {}));
    /**
     * Bottom buttons type of GAIA dialog.
     */
    let GaiaDialogButtonsType;
    (function (GaiaDialogButtonsType) {
        GaiaDialogButtonsType["DEFAULT"] = "default";
        GaiaDialogButtonsType["ENTERPRISE_PREFERRED"] = "enterprise-preferred";
        GaiaDialogButtonsType["KIOSK_PREFERRED"] = "kiosk-preferred";
    })(GaiaDialogButtonsType = OobeTypes.GaiaDialogButtonsType || (OobeTypes.GaiaDialogButtonsType = {}));
    /**
     * Type of license used for enrollment.
     * Numbers for supported licenses should be in sync with
     * `LicenseType` from enrollment_config.h.
     */
    let LicenseType;
    (function (LicenseType) {
        LicenseType[LicenseType["NONE"] = 0] = "NONE";
        LicenseType[LicenseType["ENTERPRISE"] = 1] = "ENTERPRISE";
        LicenseType[LicenseType["EDUCATION"] = 2] = "EDUCATION";
        LicenseType[LicenseType["KIOSK"] = 3] = "KIOSK";
    })(LicenseType = OobeTypes.LicenseType || (OobeTypes.LicenseType = {}));
})(OobeTypes || (OobeTypes = {}));
