import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2023 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->
<style>:host{position:absolute;font-family:"Google Sans";top:5%;left:10px}#iconHolder{width:30px;height:30px;border-radius:50%;display:flex;justify-content:center;align-items:center;background-color:#E8F0FE}#debug-window{width:300px;height:600px;background-color:#E8F0FE;border-radius:5%;margin-top:5px;padding:5px}#title{text-align:center;margin-top:3px;margin-bottom:15px;font-size:larger;color:#1A73E8}.section{border:1px dashed #5F6368;padding:5px;color:#5F6368;margin-top:3px;border-radius:3px}.info-field{display:flex;flex-direction:row;justify-content:space-between;align-items:center;margin-top:5px}cr-input{height:50px}
</style>

<!-- DEBUGGER BUTTON -->
<div id="iconHolder" on-click="toggleVisibility">
  <svg class="icon" width="12" height="18" viewBox="0 0 12 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path fill-rule="evenodd" clip-rule="evenodd"
      d="M10 0.01L2 0C0.9 0 0 0.9 0 2V16C0 17.1 0.9 18 2 18H10C11.1 18 12 17.1 12 16V2C12 0.9 11.1 0.01 10 0.01ZM10 16H2V15H10V16ZM10 13H2V5H10V13ZM2 3V2H10V3H2Z"
      fill="#1A73E8" />
  </svg>
</div>

<!-- DEBUGGER PANEL -->
<div id="debug-window" hidden$=[[mainWindowHidden]]>
  <div id="title">QuickStart Debugger</div>
  <!-- ACTIONS -->
  <div class="section">
    <div>Actions</div>
    <button type="button" disabled$="[[!startAdvertisingPending]]" on-click="onStartAdvertisingTrueClicked"
      class="info-field">
      <span>OnStartAdvertisingCallback(success=true)</span>
    </button>
    <button type="button" disabled$="[[!startAdvertisingPending]]" on-click="onStartAdvertisingFalseClicked"
      class="info-field">
      <span>OnStartAdvertisingCallback(success=false)</span>
    </button>
    <button type="button" disabled$="[[!stopAdvertisingPending]]" on-click="onStopAdvertisingFalseClicked"
      class="info-field">
      <span>OnStopAdvertisingCallback()</span>
    </button>
    <button type="button" on-click="onInitiateConnectionClicked" class="info-field">
      <span>InitiateConnection</span>
    </button>
    <button type="button" on-click="onAuthenticateConnectionClicked" class="info-field">
      <span>AuthenticateConnection</span>
    </button>
    <button type="button" on-click="onVerifyUserClicked" class="info-field">
      <span>VerifyUser</span>
    </button>
    <button type="button" on-click="onSendWifiCredentialsClicked" class="info-field">
      <span>Send WiFi Credentials</span>
    </button>
    <button type="button" on-click="onSendFidoAssertionClicked" class="info-field">
      <span>Send FIDO Assertion</span>
    </button>
    <button type="button" on-click="onRejectConnectionClicked" class="info-field">
      <span>RejectConnection</span>
    </button>
    <button type="button" on-click="onCloseConnectionClicked" class="info-field">
      <span>CloseConnection</span>
    </button>
    <!-- <oobe-i18n-dropdown id="closeReason" items="[[connCloseReasons]]"
                          on-select-item="onCloseReasonSelected">
      </oobe-i18n-dropdown> -->
    <cr-checkbox checked="{{usePinForAuth}}" on-change="onUsePinChanged" class="info-field">
      <div>Use PIN</div>
    </cr-checkbox>
  </div>

  <!-- VARIABLES -->
  <div class="section">
    <div>Variables</div>
    <cr-input type="text" value="{{deviceId}}" label="DeviceID" class="info-field"></cr-input>
    <cr-input type="text" value="{{username}}" label="Username" class="info-field"></cr-input>
    <cr-input type="text" value="{{wifi_ssid}}" label="WiFi SSID" class="info-field"></cr-input>
    <cr-input type="password" value="{{wifi_pwd}}" label="WiFi PWD" class="info-field"></cr-input>
  </div>
</div>
<!--_html_template_end_-->`;
}
