// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/polymer/v3_0/iron-icon/iron-icon.js';
import '../../components/oobe_icons.html.js';
import '../../components/common_styles/oobe_common_styles.css.js';
import '../../components/common_styles/oobe_dialog_host_styles.css.js';
import '../../components/dialogs/oobe_adaptive_dialog.js';
import '../../components/dialogs/oobe_loading_dialog.js';
import '../../components/buttons/oobe_back_button.js';
import '../../components/buttons/oobe_next_button.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { LoginScreenMixin } from '../../components/mixins/login_screen_mixin.js';
import { MultiStepMixin } from '../../components/mixins/multi_step_mixin.js';
import { OobeDialogHostMixin } from '../../components/mixins/oobe_dialog_host_mixin.js';
import { OobeI18nMixin } from '../../components/mixins/oobe_i18n_mixin.js';
import { getTemplate } from './account_selection.html.js';
/**
 * Choices a user can make.
 */
var AccountSelectionOptions;
(function (AccountSelectionOptions) {
    AccountSelectionOptions["REUSE_ACCOUNT"] = "reuseAccountFromEnrollment";
    AccountSelectionOptions["SIGNIN_AGAIN"] = "signinAgain";
})(AccountSelectionOptions || (AccountSelectionOptions = {}));
/**
 * UI mode for the dialog.
 */
var AccountSelectionState;
(function (AccountSelectionState) {
    AccountSelectionState["SELECTION"] = "selection";
    AccountSelectionState["PROGRESS"] = "progress";
})(AccountSelectionState || (AccountSelectionState = {}));
const AccountSelectionBase = OobeDialogHostMixin(LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement))));
export class AccountSelection extends AccountSelectionBase {
    static get is() {
        return 'account-selection-element';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            /**
             * Option chosen during account selection stpe.
             */
            selectedAccountOption: {
                type: String,
            },
            /**
             * Options for the account selections step.
             */
            accountSelectionEnum: {
                readOnly: true,
                type: Object,
                value: AccountSelectionOptions,
            },
            /**
             * Email used during enrollment, used for the account selection step.
             */
            enrollmentEmail: {
                type: String,
            },
        };
    }
    ready() {
        super.ready();
        this.initializeLoginScreen('AccountSelectionScreen');
    }
    get EXTERNAL_API() {
        return [
            'showStepProgress',
            'setUserEmail',
        ];
    }
    get UI_STEPS() {
        return AccountSelectionState;
    }
    // eslint-disable-next-line @typescript-eslint/naming-convention
    defaultUIStep() {
        return AccountSelectionState.SELECTION;
    }
    // Invoked just before being shown. Contains all the data for the screen.
    onBeforeShow() {
        super.onBeforeShow();
        this.selectedAccountOption = AccountSelectionOptions.REUSE_ACCOUNT;
    }
    showStepProgress() {
        this.setUIStep(AccountSelectionState.PROGRESS);
    }
    setUserEmail(emailAddress) {
        this.enrollmentEmail = emailAddress;
    }
    onNextClicked() {
        this.userActed(this.selectedAccountOption);
    }
}
customElements.define(AccountSelection.is, AccountSelection);
