import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2019 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles"></style>

<!-- Dialog for normal confirmation -->
<oobe-adaptive-dialog id="enableAdbSideloadDialog" role="dialog"
    for-step="setup" footer-shrinkable
    aria-label$="[[i18nDynamic(locale, 'enableAdbSideloadingSetupTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:alert"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'enableAdbSideloadingSetupTitle')]]
  </h1>
  <p slot="subtitle" id="confirmationSubtitle">
    [[i18nDynamic(locale, 'enableAdbSideloadingSetupMessage')]]
    <a on-click="onLearnMoreClick" class="oobe-local-link"
        is="action-link" aria-describedby="confirmationSubtitle">
      [[i18nDynamic(locale, 'enableAdbSideloadingLearnMore')]]
    </a>
  </p>
  <div slot="content" class="flex layout vertical center center-justified">
    <iron-icon icon="oobe-illos:arc-sideloading" class="illustration-jelly">
    </iron-icon>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button border on-click="onCancelClick"
        text-key="enableAdbSideloadingCancelButton"
        id="enable-adb-sideloading-cancel-button"></oobe-text-button>
    <oobe-text-button inverse on-click="onEnableClick" class="focus-on-show"
        text-key="enableAdbSideloadingConfirmButton"
        id="enable-adb-sideloading-ok-button"></oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<!-- Dialog for error -->
<oobe-adaptive-dialog id="enableAdbSideloadErrorDialog" role="dialog"
    for-step="error" footer-shrinkable
    aria-label$="[[i18nDynamic(locale, 'enableAdbSideloadingSetupTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:warning"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'enableAdbSideloadingErrorTitle')]]
  </h1>
  <p slot="subtitle" id="errorSubtitle">
    [[i18nDynamic(locale, 'enableAdbSideloadingErrorMessage')]]
    <a on-click="onLearnMoreClick" class="oobe-local-link" is="action-link"
        aria-describedby="errorSubtitle">
      [[i18nDynamic(locale, 'enableAdbSideloadingLearnMore')]]
    </a>
  </p>
  <div slot="content" class="flex layout vertical center center-justified">
    <iron-icon icon="oobe-illos:error-illo" class="illustration-jelly">
    </iron-icon>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button inverse on-click="onCancelClick" class="focus-on-show"
        text-key="enableAdbSideloadingOkButton"></oobe-text-button>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`;
}
