import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2023 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->
<style include="oobe-dialog-host-styles cros-color-overrides"></style>

<oobe-adaptive-dialog id="displaySizeDialog" role="presentation"
    for-step="overview">
  <iron-icon slot="icon" icon="oobe-32:display"></iron-icon>
  <h1 slot="title" id="display-size-title" aria-live="polite">
    [[i18nDynamic(locale, 'displaySizeTitle')]]
  </h1>
  <div slot="subtitle" id="display-size-subtitle">
    [[i18nDynamic(locale, 'displaySizeDescription')]]
  </div>

  <div slot="content" class="flex layout vertical center center-justified">
    <oobe-display-size-selector id="sizeSelector">
      <p slot="slider-title">
        [[i18nDynamic(locale,'displaySizeSliderTitle')]]
      </p>
      <p slot="slider-description">
        [[i18nDynamic(locale,'displaySizeSliderDescription')]]
      </p>
    </oobe-display-size-selector>
  </div>

  <div slot="bottom-buttons">
    <oobe-text-button id="returnButton" text-key="choobeReturnButton"
      hidden="[[!shouldShowReturn_]]" on-click="onReturnClicked_">
    </oobe-text-button>
    <oobe-next-button id="nextButton" class="focus-on-show"
      on-click="onNextClicked_">
    </oobe-next-button>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`;
}
