import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2023 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->
<style include="oobe-dialog-host-styles cros-color-overrides">#toggleRow{border-top:1px solid var(--cros-sys-separator);color:var(--cros-bg-color);margin-top:24px}.toggle-subtitle{color:var(--cros-text-color-secondary)}:host-context(.jelly-enabled) .toggle-subtitle{color:var(--oobe-subheader-text-color);font-family:var(--oobe-drive-pinning-subtitle-font-family);font-size:var(--oobe-drive-pinning-subtitle-font-size);font-weight:var(--oobe-drive-pinning-subtitle-font-weight);line-height:var(--oobe-drive-pinning-subtitle-line-height)}.toggle-title{color:var(--cros-text-color-primary)}:host-context(.jelly-enabled) .toggle-title{color:var(--oobe-subheader-text-color);font-family:var(--oobe-drive-pinning-title-font-family);font-size:var(--oobe-drive-pinning-title-font-size);font-weight:var(--oobe-drive-pinning-title-font-weight);line-height:var(--oobe-drive-pinning-title-line-height)}#drivePinningToggle{margin-left:16px;margin-right:24px}#drivePinningOptionLabel,#drivePinningToggle{margin-top:16px}#deviceDescription{margin-top:0px}</style>
<oobe-adaptive-dialog id="drivePinningDialogue" role="dialog"
    for-step="overview">
    <iron-icon slot="icon" icon="oobe-32:drive"></iron-icon>
    <h1 slot="title" aria-live="polite">
        [[i18nDynamic(locale, 'DevicePinningScreenTitle')]]
    </h1>
    <div slot="subtitle">
        <p id="deviceDescription">
            [[i18nDynamic(locale, 'DevicePinningScreenDescription')]]
        </p>
         <!-- Toggle row -->
        <div class="layout horizontal center"
            id="toggleRow">
            <div id="drivePinningOptionLabel" class="flex layout vertical"
                    aria-hidden="true">
                <div class="toggle-title">
                    [[i18nDynamic(locale, 'DevicePinningScreenToggleTitle')]]
                </div>
                <div id="spaceInformation" class="toggle-subtitle">
                    [[getSpaceDescription_(locale, requiredSpace_, freeSpace_)]]
                </div>
            </div>
            <cr-toggle id="drivePinningToggle"
                    checked="{{enableDrivePinning_}}"
                    aria-checked="[[enableDrivePinning_]]"
                    aria-labelledby="DrivePinningOptionLabel">
            </cr-toggle>
        </div>
    </div>
    <div slot="content"  class="flex layout vertical center-justified center">
        <iron-icon icon="oobe-illos:drive-sync-illo"
            class="illustration-jelly">
        </iron-icon>
    </div>
    <div slot="bottom-buttons">
        <oobe-text-button id="returnButton" text-key="choobeReturnButton"
                hidden="[[!shouldShowReturn_]]" on-click="onReturnClicked_">
        </oobe-text-button>
        <oobe-next-button id="nextButton" class="focus-on-show"
                on-click="onNextButtonClicked_">
        </oobe-next-button>
    </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`;
}
