import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2020 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles"></style>
<oobe-adaptive-dialog id="familyLinkDialog" role="dialog"
    aria-label$="[[getDialogTitle_(locale, email_, domain_)]]">
  <iron-icon slot="icon" icon="oobe-32:family"></iron-icon>
  <h1 slot="title">[[getDialogTitle_(locale, email_, domain_)]]</h1>
  <div slot="subtitle">
    [[getDialogSubtitle_(locale, isNewGaiaAccount_, email_, domain_)]]
  </div>
  <div slot="content" class="flex layout vertical center center-justified">
    <iron-icon icon="oobe-illos:parental-control-illo"
        class="illustration-jelly">
    </iron-icon>
  </div>
  <div slot="bottom-buttons">
    <oobe-next-button id="continueButton"
        text-key="familyLinkContinueButton" class="focus-on-show"
        inverse on-click="onContinueButtonPressed_"></oobe-next-button>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`;
}
