import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2023 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->
<style include="oobe-dialog-host-styles cr-card-radio-group-styles
 cros-color-overrides">#quickstart-subtitle{padding-top:8px}#gaiaInfoAnimation{width:100%;height:100%;overflow-y:hidden}.card-icon,:host-context(.jelly-enabled) .card-icon{--iron-icon-height:96px;--iron-icon-width:120px}</style>

<oobe-adaptive-dialog id="gaiaInfoDialog" role="dialog"
    for-step="overview">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title" id="gaia-info-title" aria-live="polite">
    [[i18nDynamic(locale, 'gaiaInfoScreenTitle')]]
  </h1>
  <div slot="subtitle">
    <div hidden="[[isQuickStartVisible]]">
      [[i18nAdvancedDynamic(locale, 'gaiaInfoScreenDescription')]]
    </div>
    <div hidden="[[!isQuickStartVisible]]">
      [[i18nAdvancedDynamic(locale, 'gaiaInfoScreenDescriptionQuickStartP1')]]
    </div>
    <div id="quickstart-subtitle" hidden="[[!isQuickStartVisible]]">
      [[i18nAdvancedDynamic(locale, 'gaiaInfoScreenDescriptionQuickStartP2')]]
    </div>
  </div>
  <div slot="content" class="flex layout vertical center center-justified">
    <template is="dom-if" if="[[!isQuickStartVisible]]">
      <oobe-cr-lottie id="gaiaInfoAnimation"
          animation-url="animations/gaia_info.json">
      </oobe-cr-lottie>
    </template>
    <template is="dom-if" if="[[isQuickStartVisible]]">
      <cr-radio-group id="flowType" selected="{{selectedFlowType}}">
        <cr-card-radio-button id="manualButton" class="flex focus-on-show"
            name="manual">
          <div class="card-container">
            <iron-icon class="card-icon"
                icon="oobe-illos:quickstart-account-fresh-gaia">
            </iron-icon>
            <div class="card-content">
              <div class="card-label">
                [[i18nAdvancedDynamic(locale, 'gaiaInfoScreenManualFlow')]]
              </div>
            </div>
          </div>
        </cr-card-radio-button>
        <cr-card-radio-button id="quickstartButton" class="flex"
            name="quickstart">
          <div class="card-container">
            <iron-icon class="card-icon"
                icon="oobe-illos:quickstart-account-quickstart">
            </iron-icon>
            <div class="card-content">
              <div class="card-label">
                [[i18nAdvancedDynamic(locale, 'gaiaInfoScreenQuickStartFlow')]]
              </div>
            </div>
          </div>
        </cr-card-radio-button>
      </cr-radio-group>
    </template>
  </div>
  <div slot="back-navigation">
    <oobe-back-button id="backButton" on-click="onBackClicked">
    </oobe-back-button>
  </div>
  <div slot="bottom-buttons">
    <oobe-next-button id="nextButton" class="focus-on-show"
      on-click="onNextClicked"
      disabled="[[!isNextButtonEnabled(isQuickStartVisible,
          selectedFlowType)]]">
    </oobe-next-button>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`;
}
