import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2021 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles cros-color-overrides">#termsTitle{color:var(--oobe-text-color);font-family:var(--oobe-guest-tos-terms-title-font-family);font-size:var(--oobe-guest-tos-terms-title-font-size);font-weight:var(--oobe-guest-tos-terms-title-font-weight);line-height:var(--oobe-guest-tos-terms-title-line-height);margin-bottom:4px}.tos-webview{display:flex;height:470px}</style>

<!-- LOADING DIALOG -->
<oobe-loading-dialog id="loading" for-step="loading" role="dialog"
    title-key="guestTosLoading"
    aria-label$="[[i18nDynamic(locale, 'guestTosLoading')]]">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
</oobe-loading-dialog>

<!-- Google EULA Dialog -->
<oobe-adaptive-dialog id="googleEulaDialog" for-step="google-eula"
    role="dialog"
    aria-label$="[[i18nDynamic(locale, 'guestTosGoogleEulaTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'guestTosGoogleEulaTitle')]]
  </h1>
  <div slot="content" class="flex layout vertical">
    <webview id="guestTosGoogleEulaWebview" role="document"
        class="oobe-tos-webview tos-webview"
        on-contentload="onGoogleEulaContentLoad">
    </webview>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="googleEulaOkButton"
        class="focus-on-show" inverse on-click="onTermsStepOkClick"
        text-key="guestTosOk"></oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<!-- CrOS EULA Dialog -->
<oobe-adaptive-dialog id="crosEulaDialog" for-step="cros-eula"
role="dialog"
aria-label$="[[i18nDynamic(locale, 'guestTosCrosEulaTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'guestTosCrosEulaTitle')]]
  </h1>
  <div slot="content" class="flex layout vertical">
    <webview id="guestTosCrosEulaWebview" role="document"
        class="oobe-tos-webview tos-webview"
        on-contentload="onCrosEulaContentLoad">
    </webview>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="crosEulaOkButton"
        class="focus-on-show" inverse on-click="onTermsStepOkClick"
        text-key="guestTosOk"></oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<!-- Overview Dialog -->
<oobe-adaptive-dialog id="overview" for-step="overview" role="dialog"
aria-label$="[[i18nDynamic(locale, 'guestTosTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:avatar"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'guestTosTitle')]]
  </h1>
  <div slot="content" class="landscape-header-aligned">
    <div id="termsTitle">
      [[i18nDynamic(locale, 'guestTosTermsTitle')]]
    </div>
    <div id="terms">
      <div inner-h-t-m-l="[[getTerms(locale)]]">
      </div>
    </div>

    <!-- Usage stats toggle row -->
    <div id="usageStats" class="layout horizontal center oobe-optin-row">
      <div class="oobe-optin-content">
        <span id="usageTitle" class="oobe-optin-title">
          [[i18nDynamic(locale, 'guestTosUsageOptinTitle')]]
        </span>
        [[i18nDynamic(locale, 'guestTosUsageOptin')]]
        <a id="usageLearnMore" on-click="onUsageLearnMoreClick"
            class="oobe-local-link" is="action-link">
          [[i18nDynamic(locale, 'guestTosLearnMore')]]
        </a>
      </div>
      <cr-toggle id="usageOptin" checked="{{usageChecked}}"
          aria-describedby="usageTitle">
      </cr-toggle>
    </div>
  </div>
  <div slot="back-navigation">
    <oobe-back-button on-click="onBackClick"></oobe-back-button>
  </div>
  <div slot="bottom-buttons">
    <oobe-next-button id="acceptButton" inverse on-click="onAcceptClick"
        text-key="guestTosAccept" class="focus-on-show">
    </oobe-next-button>
  </div>
</oobe-adaptive-dialog>

<oobe-modal-dialog id="usageLearnMorePopUp">
  <div slot="content">
    <span inner-h-t-m-l="[[getUsageLearnMoreText(locale)]]"></span>
  </div>
</oobe-modal-dialog>
<!--_html_template_end_-->`;
}
