import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2019 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles"></style>
<link rel="stylesheet" href="throbber.css">

<!-- ERROR DIALOG -->
<oobe-adaptive-dialog id="step-error" role="dialog"
    aria-label$="[[i18nDynamic(locale, 'termsOfServiceError')]]"
    for-step="error">
  <iron-icon slot="icon" icon="oobe-32:warning"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'termsOfServiceError')]]
  </h1>
  <p slot="subtitle">
    [[i18nDynamic(locale, 'termsOfServiceTryAgain')]]
  </p>
  <div slot="back-navigation">
    <oobe-back-button id="errorBackButton"
        disabled="[[backButtonDisabled]]"
        on-click="onTosBackButtonPressed"></oobe-back-button>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="retryButton" inverse
        class="focus-on-show"
        text-key="termsOfServiceRetryButton"
        disabled="[[retryButtonDisabled]]"
        on-click="onTosRetryButtonPressed"></oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<!-- LOADING DIALOG -->
<oobe-loading-dialog title-key="termsOfServiceLoading" for-step="loading">
  <iron-icon slot="icon" icon="oobe-32:enterprise"></iron-icon>
</oobe-loading-dialog>

<!-- NORMAL DIALOG -->
<!-- As this dialog have pre-loading logic that require access to elements,
     dialog is marked as no-lazy. -->
<oobe-adaptive-dialog id="step-loaded" role="dialog"
    aria-labelledby="title" for-step="loaded" no-lazy>
  <iron-icon slot="icon" icon="oobe-32:enterprise"></iron-icon>

  <h1 id="tosHeading" slot="title">[[i18nDynamic(locale,
    'termsOfServiceScreenHeading', tosManager)]]</h1>
  <p id="tosSubheading" slot="subtitle">[[i18nDynamic(locale,
    'termsOfServiceScreenSubheading', tosManager)]]</p>
  <div slot="content" class="flex layout center-justified vertical">
    <webview id="termsOfServiceFrame"
        role="document" allowTransparency
        class="focus-on-show flex oobe-tos-webview">
    </webview>
  </div>
  <div slot="back-navigation">
    <oobe-back-button id="backButton" disabled="[[backButtonDisabled]]"
        on-click="onTosBackButtonPressed"></oobe-back-button>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="acceptButton" inverse
        text-key="termsOfServiceAcceptButton"
        disabled="[[acceptButtonDisabled]]"
        on-click="onTermsOfServiceAccepted"></oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<!--_html_template_end_-->`;
}
