import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2017 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->


<style include="oobe-dialog-host-styles cros-color-overrides">#reset-revert-spinner{padding-inline-end:5px}#tpmFirmwareUpdate{margin-top:20px}.illustration{max-height:80%;max-width:100%;object-fit:contain}#tpmFirmwareUpdateContainer{cursor:default;line-height:var(--oobe-reset-firmware-update-line-height);pointer-events:auto}:host-context(.jelly-enabled) .throbber{background:none;background-color:var(--cros-sys-primary);-webkit-mask:url(chrome://resources/images/throbber_small.svg) no-repeat}</style>
<link rel="stylesheet" href="throbber.css">
<oobe-adaptive-dialog id="resetDialog" role="dialog"
    aria-label$="[[i18nDynamic(locale, 'resetScreenAccessibleTitle')]]"
    for-step="restart-required,revert-promise,powerwash-proposal"
    footer-shrinkable>
  <iron-icon slot="icon" icon="oobe-32:alert"></iron-icon>
  <h1 slot="title" aria-live="polite">
    [[i18nDynamic(locale, 'resetWarningTitle')]]
  </h1>
  <div slot="subtitle" id="powerwash-warning">
    <!-- Subtitle:  Restart required  -->
    <span for-step="restart-required">
      [[i18nDynamic(locale, 'resetRestartMessage')]]
    </span>
    <!-- Subtitle: Powerwash state (depends on powerwash mode) -->
    <span for-step="powerwash-proposal">
      <span>[[powerwashStateSubtitle_]]</span>
      <span>
        [[i18nDynamic(locale, 'resetWarningDataDetails')]]
      </span>
    </span>
    <!-- Help Link - Hidden when reverting/rolling back. -->
    
    <!-- Spinner - Shown when the revert process is ongoing -->
    <div for-step="revert-promise">
      <div>
        [[i18nDynamic(locale, 'resetRevertPromise')]]
      </div>
      <div class="flex horizontal layout">
        <div id="reset-revert-spinner" class="throbber"></div>
        <div>
          [[i18nDynamic(locale, 'resetRevertSpinnerMessage')]]
        </div>
      </div>
    </div>
  </div>
  <div slot="content" class="flex layout vertical center center-justified">
    <!-- Reset screen illustration -->
    <iron-icon icon="oobe-illos:powerwash-illo" class="illustration-jelly">
    </iron-icon>
    <!-- TPM Update - Only shown during powerwash state -->
    <div id="tpmFirmwareUpdate" class="layout horizontal"
        for-step="powerwash-proposal">
      <cr-checkbox id="tpmFirmwareUpdateCheckbox"
          checked="{{tpmUpdateChecked_}}"
          disabled="[[!tpmUpdateEditable_]]"
          hidden="[[!tpmUpdateAvailable_]]"
          on-change="onTpmFirmwareUpdateChanged">
        <div id="tpmFirmwareUpdateContainer">
          <span>
            [[i18nDynamic(locale, 'resetTPMFirmwareUpdate')]]
          </span>
          
        </div>
      </cr-checkbox>
    </div>
  </div>
  <div slot="bottom-buttons">
    <!-- Cancel button, only disabled when reverting -->
    <oobe-text-button border on-click="onCancelClick" text-key="cancelButton"
        id="resetCancel" disabled="[[inRevertState_]]"></oobe-text-button>
    <!-- Restart button -->
    <oobe-text-button inverse on-click="onRestartClick" class="focus-on-show"
        id="restart" text-key="resetButtonRestart"
        for-step="restart-required">
    </oobe-text-button>
    <!-- Powerwash button (depends on powerwash mode) -->
    <oobe-text-button inverse on-click="onPowerwashClick"
        class="focus-on-show" id="powerwash"
        for-step="powerwash-proposal"
        text-key="[[powerwashButtonTextKey_]]"
        disabled="[[powerwashButtonDisabled_]]">
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<!-- Powerwash confirmation dialog (depends on powerwash mode) -->
<oobe-modal-dialog should-hide-backdrop id="confirmationDialog"
    on-close="onDialogClosed" role="dialog">
  <div slot="title" aria-label="[[confirmationDialogTitle_]]"
      aria-live="polite">[[confirmationDialogTitle_]]</div>
  <div slot="content">[[confirmationDialogText_]]</div>
  <div slot="buttons">
    <oobe-text-button id="cancelButton" border on-click="onDialogCancelClick"
        class="focus-on-show" text-key="cancel"></oobe-text-button>
    <oobe-text-button inverse on-click="onDialogContinueClick"
        id="confirmPowerwash"
        text-key="confirmResetButton"></oobe-text-button>
  </div>
</oobe-modal-dialog>

<!-- Rollback attempt error -->
<oobe-adaptive-dialog id="rollbackError" role="dialog"
    for-step="error">
  <iron-icon slot="icon" icon="oobe-32:warning"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'resetRollbackErrorTitle')]]
  </h1>
  <div slot="subtitle">
    [[i18nDynamic(locale, 'resetRollbackErrorMessageBody')]]
  </div>
  <div slot="content" class="flex layout vertical center center-justified">
    <iron-icon icon="oobe-illos:error-illo" class="illustration-jelly">
    </iron-icon>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="okButton" on-click="onCancelClick"
        text-key="okButton" class="focus-on-show">
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`;
}
