import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2020 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles"></style>
<oobe-adaptive-dialog id="signinFatalErrorDialog" role="dialog">
  <iron-icon slot="icon" icon="oobe-32:alert"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'errorGenericFatalErrorTitle')]]
  </h1>
  <p id="subtitle" slot="subtitle">
    [[errorSubtitle]]
  </p>
  <div slot="subtitle" hidden="[[!keyboardHint]]">[[keyboardHint]]</div>
  <div slot="subtitle" hidden="[[!details]]">[[details]]</div>
  <a slot="subtitle" on-click="onHelpLinkClicked"
      hidden="[[!helpLinkText]]" class="oobe-local-link" is="action-link"
      aria-describedby="subtitle">
    [[helpLinkText]]
  </a>
  <div slot="bottom-buttons">
    <oobe-text-button id="actionButton" inverse class="focus-on-show"
        text-key="[[computeButtonKey(errorState)]]" on-click="onClick">
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`;
}
