import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2017 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles cros-color-overrides">.overview-list-item{border-top:1px solid var(--cros-sys-separator);padding:16px}.overview-list-item:last-of-type{border-bottom:1px solid var(--cros-sys-separator);margin-bottom:0}.overview-list-item-title{font-size:var(--oobe-sync-consent-list-item-title-font-size);font-weight:var(--oobe-sync-consent-list-item-title-font-weight);line-height:var(--oobe-sync-consent-list-item-title-line-height);margin-bottom:4px}.overview-list-item-icon{padding-inline-end:16px;--iron-icon-fill-color:var(--cros-icon-color-blue);--iron-icon-height:24px;--iron-icon-width:24px}:host-context(.jelly-enabled) .overview-list-item-icon{--iron-icon-fill-color:var(--cros-sys-primary)}.overview-list-item-description{padding-inline-end:16px}cr-checkbox{align-self:start;margin-top:16px;padding-inline-start:8px;--cr-checkbox-label-padding-start:12px}img[slot='subtitle']{padding-top:20px}@media screen and (max-height:610px){:host-context([screen=gaia-signin]) img[slot='subtitle']{display:none}}@media screen and (max-height:740px){:host-context([screen=oobe]) img[slot='subtitle']{display:none}}@media (orientation:portrait){#syncConsentOverviewDialog{--oobe-adaptive-dialog-content-top-padding:20px}}cr-toggle{align-self:center;margin-inline-end:12px;margin-inline-start:auto}.card{align-items:center;display:flex;padding:16px 10px 16px 0}.card:not(:last-child){box-shadow:0 1px 0 var(--cros-separator-color)}.card-icon{align-items:center;align-self:center;border-radius:20px;display:flex;flex-direction:row;justify-content:center;margin-inline-end:16px;--iron-icon-fill-color:var(--cros-icon-color-blue);--iron-icon-height:32px;--iron-icon-width:32px}#tooltip-icon{--iron-icon-height:32px;--iron-icon-width:32px}:host-context(.jelly-enabled) .card-icon{--iron-icon-fill-color:var(--cros-sys-primary)}.card-title{color:var(--cros-text-color-primary);font:var(--oobe-sync-consent-card-title-font)}:host-context(.jelly-enabled) .card-title{color:var(--oobe-text-color)}.card-subtitle{color:var(--cros-text-color-secondary);font:var(--oobe-sync-consent-card-subtitle-font)}:host-context(.jelly-enabled) .card-subtitle{color:var(--oobe-subheader-text-color)}.tooltip-text{font:var(--oobe-sync-consent-tooltip-text-font)}#tooltip-element{--paper-tooltip-background:var(--cros-bg-color);--paper-tooltip-text-color:var(--cros-text-color-primary);border-radius:6px;box-shadow:0 1px 3px var(--cros-shadow-color-key),0 4px 8px var(--cros-separator-color);width:444px}:host-context(.jelly-enabled) #tooltip-element{--paper-tooltip-background:var(--cros-sys-base_elevated);--paper-tooltip-text-color:var(--oobe-text-color)}.bottom-buttons{display:flex;justify-content:space-between;width:100%}#rightButtons{display:flex}</style>

<oobe-adaptive-dialog id="syncConsentOverviewDialog" role="dialog"
    aria-label$="[[i18nDynamic(locale, 'syncConsentScreenTitle')]]"
    for-step="ash-sync">
  <iron-icon slot="icon" icon="sync-consent-32:googleg"></iron-icon>
  <h1 slot="title" consent-description>
    [[i18nDynamic(locale, 'syncConsentScreenTitle')]]
  </h1>
  <div slot="subtitle" consent-description>
    [[i18nDynamic(locale, 'syncConsentScreenSubtitle')]]
  </div>
  <iron-icon slot="subtitle-illustration" icon="oobe-illos:sync-consent-illo"
      class="illustration-jelly">
  </iron-icon>
  </div>
  <div slot="content" class="landscape-header-aligned">
    <div class="overview-list-item layout horizontal">
      <iron-icon icon="oobe-24:settings-gear" class="overview-list-item-icon"
          aria-hidden="true"></iron-icon>
      <div class="flex layout vertical center-justified">
        <div role="heading" aria-level="2" class="overview-list-item-title"
            consent-description>
          [[i18nDynamic(locale, 'syncConsentScreenOsSyncTitle')]]
        </div>
      </div>
    </div>
    <div class="overview-list-item layout horizontal">
      <iron-icon icon="oobe-24:browser-sync" class="overview-list-item-icon"
          aria-hidden="true"></iron-icon>
      <div class="flex layout vertical center-justified">
        <div role="heading" aria-level="2" class="overview-list-item-title"
            consent-description>
          [[i18nDynamic(locale, 'syncConsentScreenChromeBrowserSyncTitle')]]
        </div>
        <div class="overview-list-item-description" consent-description>
          [[i18nDynamic(locale,
              'syncConsentScreenChromeBrowserSyncDescription')]]
        </div>
      </div>
    </div>

    <cr-checkbox id="reviewSettingsBox" hidden="[[isMinorMode]]"
        consent-description>
      [[getReviewSettingText(locale)]]
    </cr-checkbox>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="declineButton"
        on-click="onDeclined" hidden="[[!isMinorMode]]"
        label-for-aria="[[i18nDynamic(locale,
                                      'syncConsentScreenDecline')]]">
      <div slot="text" consent-description consent-confirmation>
        [[i18nDynamic(locale, 'syncConsentScreenDecline')]]
      </div>
    </oobe-text-button>
    <oobe-text-button class="focus-on-show" inverse="[[!isMinorMode]]"
        id="acceptButton"
        on-click="onAccepted"
        label-for-aria="[[i18nDynamic(locale, optInButtonTextKey)]]">
      <div slot="text" consent-description consent-confirmation>
        [[i18nDynamic(locale, optInButtonTextKey)]]
      </div>
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<oobe-loading-dialog id="sync-loading" role="dialog" for-step="loading"
    title-key="gaiaLoading">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
</oobe-loading-dialog>

<!--_html_template_end_-->`;
}
