import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2022 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->
<style include="oobe-dialog-host-styles cr-card-radio-group-styles
    cros-color-overrides">.card-container{padding-inline-start:16px}@media screen and (max-width:920px){.oobe-illustration{height:50%}cr-card-radio-button:not(:last-child){margin-bottom:10px}.card-container{padding-inline-start:24px}}:host-context(html:not([tablet])) #theme-selection-subtitle-tablet{display:none}:host-context(html[tablet]) #theme-selection-subtitle-clamshell{display:none}</style>
<oobe-adaptive-dialog id="themeSelectionDialog" role="presentation"
    for-step="overview" aria-live="polite"
    aria-label$="[[i18nDynamic(locale, 'themeSelectionScreenTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:theme-light"></iron-icon>
  <h1 slot="title" id="theme-selection-title">
    [[i18nDynamic(locale, 'themeSelectionScreenTitle')]]
  </h1>
  <div slot="subtitle">
    <div id="theme-selection-subtitle-clamshell">
      [[i18nDynamic(locale, 'themeSelectionScreenDescriptionClamshell')]]
    </div>
    <div id="theme-selection-subtitle-tablet">
      [[i18nDynamic(locale, 'themeSelectionScreenDescriptionTablet')]]
    </div>
  </div>
  <div slot="content" class="layout vertical landscape-vertical-centered">
    <cr-radio-group id="theme" selected="{{selectedTheme}}">
      <cr-card-radio-button id="lightThemeButton" class="flex" name="light">
        <div class="card-container">
          <img srcset="images/1x/thumbnail-theme-light-1x.png,
              images/2x/thumbnail-theme-light-2x.png"
              class="oobe-illustration">
          <div class="card-content">
            <div class="card-label">
              [[i18nDynamic(locale, 'lightThemeLabel')]]
            </div>
            <div class="card-text">
              [[i18nDynamic(locale, 'lightThemeDescription')]]
            </div>
          </div>
        </div>
      </cr-card-radio-button>
      <cr-card-radio-button id="darkThemeButton" class="flex"
          name="dark">
        <div class="card-container">
          <img srcset="images/1x/thumbnail-theme-dark-1x.png,
              images/2x/thumbnail-theme-dark-2x.png"
              class="oobe-illustration">
          <div class="card-content">
            <div class="card-label">
              [[i18nDynamic(locale, 'darkThemeLabel')]]
            </div>
            <div class="card-text">
              [[i18nDynamic(locale, 'darkThemeDescription')]]
            </div>
          </div>
        </div>
      </cr-card-radio-button>
      <cr-card-radio-button id="autoThemeButton" class="flex"
          name="auto">
        <div class="card-container">
          <img srcset="images/1x/thumbnail-theme-auto-1x.png,
              images/2x/thumbnail-theme-auto-2x.png"
              class="oobe-illustration">
          <div class="card-content">
            <div class="card-label">
              [[i18nDynamic(locale, 'autoThemeLabel')]]
            </div>
            <div class="card-text">
              [[i18nDynamic(locale, 'autoThemeDescription')]]
            </div>
          </div>
        </div>
      </cr-card-radio-button>
    </cr-radio-group>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="returnButton" text-key="choobeReturnButton"
      hidden="[[!shouldShowReturn_]]" on-click="onReturnClicked_">
    </oobe-text-button>
    <oobe-next-button id="nextButton" class="focus-on-show"
      on-click="onNextClicked_">
    </oobe-next-button>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`;
}
