import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2023 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->
<style include="oobe-dialog-host-styles cros-color-overrides">#scrollArea{display:flex;max-height:324px;height:1290px;overflow-y:scroll;overflow-x:hidden;position:relative;box-sizing:border-box;border:1px solid rgba(var(--cros-icon-color-secondary-rgb),0.3);border-radius:16px}#toggleElementBox{align-items:center;display:flex;flex-direction:row;margin-top:25px}#areaText{color:var(--cros-text-color-primary);font-size:14px;font-weight:500;left:20px;line-height:20px;padding-top:20px;position:sticky;top:0px;z-index:1}:host-context(.jelly-enabled) #areaText{color:var(--oobe-text-color);font-size:var(--oobe-touchpad-scroll-font-size);font-weight:var(--oobe-touchpad-scroll-font-weight);line-height:var(--oobe-touchpad-scroll-line-height)}#toggleTitle{color:var(--cros-text-color-primary)}:host-context(.jelly-enabled) #toggleTitle{color:var(--oobe-text-color)}.illustration-jelly{width:100%;height:auto;position:absolute}@media screen and (max-width:700px){#scrollArea{max-height:250px}}
</style>
<oobe-adaptive-dialog id="touchpadScrolDialogue" role="presentation"
    for-step="overview">
  <iron-icon slot="icon" icon="oobe-32:scroll-direction"></iron-icon>
  <h1 slot="title" id="touchpad-scroll-title" aria-live="polite">
    [[i18nDynamic(locale, 'TouchpadScrollScreenTitle')]]
  </h1>
  <div slot="subtitle" id="touchpad-scroll-subtitle">
    [[i18nDynamic(locale, 'TouchpadScrollScreenDescription')]]
  </div>
  <div slot="content" class="layout vertical center-justified">
    <div id="scrollArea" aria-hidden="true">
      <div id="areaText">
        [[i18nDynamic(locale, 'TouchpadScrollAreaDescription')]]
      </div>
      <iron-icon id="iconArea" icon="oobe-illos:touchpad-scroll-illo"
        class="illustration-jelly">
      </iron-icon>
    </div>
    <div id="toggleElementBox" class="layout horizontal">
        <div class="flex layout vertical center-justified">
          <div id="toggleTitle" aria-hidden="true">
            [[i18nDynamic(locale, 'TouchpadScrollToggleTitle')]]
          </div>
          <div id="toggleDesc" aria-hidden="true">
            [[i18nDynamic(locale, 'TouchpadScrollToggleDescription')]]
          </div>
        </div>
        <cr-toggle id="updateToggle" checked="{{isReverseScrolling}}"
            role="checkbox"
            aria-checked="[[isReverseScrolling]]"
            aria-label$="[[getAriaLabelToggleButtons(locale,
                'TouchpadScrollToggleTitle' ,
                'TouchpadScrollToggleDescription')]]">
        </cr-toggle>
    </div>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="returnButton" text-key="choobeReturnButton"
      hidden="[[!shouldShowReturn]]" on-click="onReturnClicked">
    </oobe-text-button>
    <oobe-next-button id="nextButton" class="focus-on-show"
      on-click="onNextClicked">
    </oobe-next-button>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`;
}
