import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2020 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->


<style include="oobe-dialog-host-styles"></style>
<oobe-adaptive-dialog id="errorDialog" role="dialog"
    aria-label$="[[i18nDynamic(locale, 'errorTpmFailureTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:warning"></iron-icon>
  <h1 slot="title" for-step="default">
    [[i18nDynamic(locale, 'errorTpmFailureTitle')]]
  </h1>
  <h1 slot="title" for-step="dbus-error">
    [[i18nDynamic(locale, 'errorTpmDbusErrorTitle')]]
  </h1>
  <p slot="subtitle" for-step="default,dbus-error">
    [[i18nDynamic(locale, 'errorTpmFailureReboot')]]
  </p>
  <div slot="content" for-step="default,dbus-error" class="flex layout
      vertical center center-justified">
    <iron-icon icon="oobe-illos:error-illo" class="illustration-jelly">
    </iron-icon>
  </div>
  <h1 slot="title" for-step="tpm-owned">
    [[i18nDynamic(locale, 'errorTPMOwnedTitle')]]
  </h1>
  <p slot="subtitle" for-step="tpm-owned">
    [[i18nDynamic(locale, 'errorTPMOwnedSubtitle')]]
  </p>
  <span slot="content" for-step="tpm-owned" class="flex layout
      vertical center center-justified"
      inner-h-t-m-l="[[i18nAdvancedDynamic(locale,
                          'errorTPMOwnedContent')]]"></span>
  <div slot="bottom-buttons">
    <oobe-text-button id="restartButton" inverse class="focus-on-show"
        text-key="errorTpmFailureRebootButton" on-click="onRestartClicked">
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`;
}
