import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2020 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->
<style include="oobe-dialog-host-styles">.progress-message{color:var(--oobe-subheader-text-color);margin-top:8px}.update-illustration{height:264px;width:264px}#checkingAnimation{height:300px;width:334px}</style>
<oobe-adaptive-dialog
  hidden="[[!checkingForUpdate]]"
  aria-live="polite"
  id="checking-for-updates-dialog"
  footer-shrinkable
>
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">[[i18nDynamic(locale, 'checkingForUpdates')]]</h1>
  <div slot="subtitle" class="update-subtitle" id="checkingForUpdatesMsg">
    [[i18nDynamic(locale, checkingForUpdatesKey)]]
  </div>
  <div
    slot="subtitle"
    class="update-subtitle"
    hidden="[[!cancelAllowed]]"
    id="checkingForUpdateCancelHint"
  >
    [[i18nDynamic(locale, 'cancelUpdateHint')]]
  </div>
  <paper-progress
    slot="progress"
    id="checking-progress"
    indeterminate="[[checkingForUpdate]]"
  >
  </paper-progress>
  <div slot="content" class="flex layout vertical center-justified center">
    <oobe-cr-lottie
      id="checkingAnimation"
      animation-url="animations/checking_for_update.json"
    >
    </oobe-cr-lottie>
  </div>
</oobe-adaptive-dialog>

<oobe-adaptive-dialog
  footer-shrinkable
  id="updating-dialog"
  hidden="[[isCheckingOrUpdateCompleted(checkingForUpdate,
                                               updateCompleted)]]"
  aria-live="polite"
>
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">[[i18nDynamic(locale, 'updatingTitle')]]</h1>
  <div slot="subtitle">
    <div>[[i18nDynamic(locale, downloadingUpdatesKey)]]</div>
    <div hidden="[[!cancelAllowed]]">
      [[i18nDynamic(locale, 'cancelUpdateHint')]]
    </div>
    <div id="progress-message" class="progress-message">
      [[progressMessage]]
    </div>
  </div>
  <paper-progress
    id="updating-progress"
    slot="progress"
    min="0"
    max="100"
    value="[[progressValue]]"
  >
  </paper-progress>
  <div slot="content" class="flex layout vertical">
    <div class="flex layout vertical center-justified center">
      <iron-icon icon="oobe-illos:updating-illo"
          class="illustration-jelly">
      </iron-icon>
    </div>
  </div>
</oobe-adaptive-dialog>

<oobe-adaptive-dialog
  footer-shrinkable
  id="update-complete-dialog"
  hidden="[[!updateCompleted]]"
  aria-live="polite"
>
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">[[i18nDynamic(locale, 'updateCompeletedMsg')]]</h1>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`;
}
