import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2015 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<!--
  Offline UI for the Login flow.
  Contains two cards with a slide transition between them:
    1. Email input form.
    2. Password input form.

  Example:
    <offline-login-element></offline-login-element>

  Attributes:
    'showEnterpriseMessage' - If the "manged by" message should be shown.
    'manager' - The entity (email or domain) the device is managed by.
    'emailDomain' - autocomplete domain for the email input.

  Events:
    'authCompleted' - fired when user enters login and password. Fires with an
                      argument |credentials| which contains.
                      |credentials| = { 'useOffline': true,
                                        'email': <email>,
                                        'password': <typed password> }
                      If user did not type domain |email| will be added by
                      "@gmail.com" or by 'emailDomain' if it is set.
  Methods:
    'focus' - focuses current screen (email input or password input);
    'setEmail' - accepts an argument |email|. If |email| is empty it sets
                 current screen to the email input, otherwise it sets current
                 screen to password input and shows error that previously
                 entered password is incorrect.
-->
<style include="cr-shared-style oobe-dialog-host-styles cros-color-overrides">:host{--offline-login-dialog-width:100%;--offline-login-animation-margin:50%;display:flex;flex-direction:column;min-height:0;overflow:hidden;position:relative}#forgotPasswordDlg::part(dialog){color:var(--oobe-text-color);font-family:var(--oobe-default-font-family);font-size:var(--oobe-default-font-size);font-weight:var(--oobe-default-font-weight);line-height:var(--oobe-default-line-height);width:384px}cr-input{--cr-input-padding-start:0px}:host-context(.jelly-enabled) cr-input#emailInput,cr-input#passwordInput{--cr-input-background-color:var(--cros-sys-input_field_on_shaded)}#icon{height:32px;margin:60px 64px 0 64px}.title-container{padding-bottom:8px;padding-top:20px}h1{color:var(--oobe-header-text-color);font-family:var(--oobe-header-font-family);font-size:var(--oobe-header-font-size);font-weight:var(--oobe-header-font-weight);line-height:var(--oobe-header-line-height);margin:0}.enterprise-info{color:var(--oobe-subheader-text-color);line-height:var(--subtitle-line-height);margin:0}#passwordInput{margin-bottom:20px}#passwordSectionEmailHeader{font-family:var(--oobe-subheader-font-family);font-size:var(--oobe-subheader-font-size);font-weight:var(--oobe-subheader-font-weight);line-height:var(--oobe-subheader-line-height);margin-top:5px}#animation-outer-container{overflow:hidden;width:var(--offline-login-dialog-width)}#animation-inner-container{width:calc(2 * var(--offline-login-dialog-width))}.section{--section-padding:var(--oobe-dialog-content-padding);--section-width:var(--offline-login-animation-margin);animation-duration:700ms;box-sizing:border-box;display:none;max-width:var(--section-width);min-width:var(--section-width);padding:0 var(--section-padding)}@keyframes show-from-left{from{transform:translateX(-100%)}to{transform:translateX(0)}}@keyframes show-from-right{from{transform:translateX(100%)}to{transform:translateX(0)}}@keyframes hide-to-left{from{transform:translateX(0)}to{transform:translateX(-100%)}}@keyframes hide-to-right{from{transform:translateX(0)}to{transform:translateX(100%)}}oobe-content-dialog[selected='emailSection'] #email-section,oobe-content-dialog[selected='passwordSection'] #password-section{display:block}oobe-content-dialog[animation-in-progress] .section{animation-name:show-from-left}oobe-content-dialog[selected='passwordSection'] .section{animation-name:hide-to-left}:host([rtl]) oobe-content-dialog[animation-in-progress] .section{animation-name:show-from-right}:host([rtl]) oobe-content-dialog[selected='passwordSection'] .section{animation-name:hide-to-right}oobe-content-dialog[animation-in-progress] .section{display:block}#forgotPasswordDlg cr-button.action-button{border-radius:var(--oobe-button-radius);font-family:var(--oobe-button-font-family);font-size:var(--oobe-button-font-size);font-weight:var(--oobe-button-font-weight);line-height:var(--oobe-button-line-height)}</style>
<oobe-content-dialog role="dialog" selected$="[[activeSection]]"
    id="dialog" no-footer-padding
    animation-in-progress$="[[animationInProgress]]">
  <div slot="content">
    <img id="icon" src="chrome://theme/IDR_LOGO_GOOGLE_COLOR_90" alt="">
  </div>
  <div id="animation-outer-container" slot="content">
    <div id="animation-inner-container" class="flex layout horizontal">
      <div id="email-section" class="section"
          on-animationend="onSlideAnimationEnd">
        <div class="title-container layout vertical end-justified">
          <h1>[[i18nDynamic(locale, 'loginWelcomeMessage')]]</h1>
        </div>
        <div id="managedBy" class="enterprise-info" hidden$="[[!manager]]">
          [[i18nDynamic(locale, 'enterpriseInfoMessage', manager)]]
        </div>
        <cr-input id="emailInput" value="{{email}}"
            on-keydown="onKeyDown" disabled="[[disabled]]"
            required error-message="[[i18nDynamic(
                locale, 'offlineLoginInvalidEmail')]]"
            placeholder="[[i18nDynamic(locale, 'offlineLoginEmail')]]">
          <span slot="inline-suffix">[[displayDomain]]</span>
        </cr-input>
      </div>
      <div id="password-section" class="section">
        <div class="title-container layout vertical">
          <img src="chrome://theme/IDR_LOGO_AVATAR_CIRCLE_BLUE_COLOR" alt
              class="self-start">
          <div id="passwordSectionEmailHeader">[[fullEmail]]</div>
        </div>
        <cr-input id="passwordInput" value="{{password}}"
            on-keydown="onKeyDown" disabled="[[disabled]]"
            type="password" required
            error-message="[[passwordErrorText(locale, authenticateByPin)]]"
            placeholder=
                "[[passwordPlaceholderText(locale,authenticateByPin)]]">
        </cr-input>
        <div class="layout horizontal-reverse">
          <gaia-button on-click="onForgotPasswordClicked" link
              disabled="[[disabled]]">
            [[i18nDynamic(locale, 'offlineLoginForgotPasswordBtn')]]
          </gaia-button>
        </div>
      </div>
    </div>
  </div>
  <div slot="back-navigation">
    <oobe-back-button id="backButton" disabled="[[disabled]]"
        on-click="onBackButtonClicked"></oobe-back-button>
  </div>
  <div slot="bottom-buttons">
    <oobe-next-button id="nextButton" disabled="[[disabled]]"
        on-click="onNextButtonClicked"></oobe-next-button>
  </div>
</oobe-content-dialog>
<cr-dialog id="forgotPasswordDlg"
    on-close="onDialogOverlayClosed">
  <div slot="body">
    [[i18nDynamic(locale, 'offlineLoginForgotPasswordDlg')]]
  </div>
  <div slot="button-container">
    <cr-button autofocus on-click="onForgotPasswordCloseClicked"
        class="action-button">
      [[i18nDynamic(locale, 'offlineLoginCloseBtn')]]
    </cr-button>
  </div>
</cr-dialog>
<cr-dialog id="onlineRequiredDialog"
    on-close="onDialogOverlayClosed">
  <div slot="title">
    [[i18nDynamic(locale, 'offlineLoginWarningTitle')]]
  </div>
  <div slot="body">
    [[i18nDynamic(locale, 'offlineLoginWarning', manager, email)]]
  </div>
  <div slot="button-container">
    <cr-button autofocus on-click="onOnlineRequiredDialogCloseClicked"
        id="offlineWarningBackButton" class="action-button">
      [[i18nDynamic(locale, 'offlineLoginOkBtn')]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
