import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2016 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->
<!--
  Update required card that informs user that current chromeos version does not
  satisfy policy requirements.

  Events: none
-->
<style include="oobe-dialog-host-styles">:host .content{padding:24px 24px 16px}:host .message{margin-bottom:25px;margin-top:20px}#adminMessageContainer{color:var(--oobe-subheader-text-color)}.bold{font-weight:bold}.update-illustration{height:264px;width:264px}</style>
<oobe-adaptive-dialog
  for-step="update-required-message"
  role="dialog"
  id="update-required-dialog"
  aria-label$="[[i18nDynamic(locale, 'updateRequiredTitle')]]"
>
  <iron-icon slot="icon" icon="oobe-32:enterprise"></iron-icon>
  <h1 slot="title">[[i18nDynamic(locale, 'updateRequiredTitle')]]</h1>
  <div id="update-subtitle" slot="subtitle">
    [[i18nDynamic(locale,'updateRequiredMessage', enterpriseManager,
    deviceName)]]
  </div>
  <div slot="content" class="flex layout vertical center-justified center">
    <iron-icon icon="oobe-illos:updating-illo"
        class="update-illustration illustration-jelly">
    </iron-icon>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button
      inverse
      on-click="onUpdateClicked"
      class="focus-on-show"
      text-key="updateButtonCaption"
    >
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<oobe-adaptive-dialog
  for-step="update-error"
  id="update-required-error-dialog"
  role="dialog"
  aria-label$="[[i18nDynamic(locale, 'updateRequiredTitle')]]"
>
  <iron-icon slot="icon" icon="oobe-32:enterprise"></iron-icon>
  <h1 slot="title">[[i18nDynamic(locale, 'updateRequiredTitle')]]</h1>
  <p slot="subtitle">[[i18nDynamic(locale, 'errorMessage')]]</p>
  <div slot="bottom-buttons">
    <oobe-text-button
      inverse
      on-click="onSelectNetworkClicked"
      class="focus-on-show"
      text-key="selectNetworkButtonCaption"
    >
    </oobe-text-button>
    <oobe-text-button
      inverse
      on-click="onUpdateClicked"
      id="update-button"
      text-key="updateButtonCaption"
    >
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<checking-downloading-update
  id="downloadingUpdate"
  aria-label$="[[i18nDynamic(locale, 'updateScreenAccessibleTitle')]]"
  for-step="update-process, update-completed-need-reboot"
  checking-for-update="[[updateProgressUnavailable]]"
  update-completed="[[eq(uiStep, 'update-completed-need-reboot')]]"
  progress-value="[[updateProgressValue]]"
  has-estimate="[[estimatedTimeLeftVisible]]"
  estimated-time-left="[[estimatedTimeLeft]]"
  default-progress-message="[[updateProgressMessage]]"
  checking-for-updates-key="updatingMessage"
  downloading-updates-key="updatingMessage"
>
</checking-downloading-update>

<oobe-adaptive-dialog
  for-step="update-need-permission"
  role="dialog"
  id="update-need-permission-dialog"
  aria-label$="[[i18nDynamic(locale, 'updateRequiredTitle')]]"
>
  <iron-icon slot="icon" icon="oobe-32:enterprise"></iron-icon>
  <h1 slot="title">[[i18nDynamic(locale, 'updateRequiredTitle')]]</h1>
  <div slot="subtitle" class="update-subtitle">
    [[i18nDynamic(locale,'updateOverMeteredNetworkMessage', enterpriseManager)]]
  </div>
  <div slot="content" class="flex layout vertical center-justified center">
    <iron-icon icon="oobe-illos:updating-illo"
        class="update-illustration illustration-jelly">
    </iron-icon>
  </div>
  <div slot="bottom-buttons" class="layout horizontal end-justified">
    <oobe-text-button
      inverse
      on-click="onCellularPermissionAccepted"
      class="focus-on-show"
      text-key="AcceptUpdateOverCellularButton"
      id="cellular-permission-accept-button"
    >
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<oobe-adaptive-dialog
  for-step="update-no-network"
  role="dialog"
  id="update-required-no-network-dialog"
  aria-label$="[[i18nDynamic(locale, 'updateRequiredTitle')]]"
>
  <iron-icon slot="icon" icon="oobe-32:enterprise"></iron-icon>
  <h1 slot="title">[[i18nDynamic(locale, 'updateRequiredTitle')]]</h1>
  <div slot="subtitle" class="update-subtitle" id="no-network-message">
    [[i18nDynamic(locale,'noNetworkMessage', enterpriseManager)]]
  </div>
  <div slot="content" class="flex layout vertical center-justified center">
    <iron-icon icon="oobe-illos:updating-illo"
        class="update-illustration illustration-jelly">
    </iron-icon>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button
      inverse
      on-click="onSelectNetworkClicked"
      id="select-network-button"
      text-key="selectNetworkButtonCaption"
      class="focus-on-show"
    >
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<oobe-adaptive-dialog
  for-step="eol"
  id="eolDialog"
  role="dialog"
  aria-labelledby="eolTitle"
>
  <iron-icon slot="icon" icon="oobe-32:warning"></iron-icon>
  <h1 id="eolTitle" slot="title">
    [[i18nDynamic(locale, 'eolTitle', deviceName)]]
  </h1>
  <div slot="subtitle">
    <div>[[i18nDynamic(locale, 'eolMessage', deviceName)]]</div>
    <div id="deleteDataMessageContainer" hidden="[[!usersDataPresent]]">
      <span id="deleteUsersDataMessage"></span>
    </div>
    <div id="noUsersDataMessage" hidden="[[usersDataPresent]]">
      [[i18nDynamic(locale, 'eolNoUsersDataMessage', deviceName)]]
    </div>
  </div>
  <div slot="content" class="flex layout vertical">
    <div id="adminMessageContainer" hidden="[[isEmpty(eolAdminMessage)]]">
      <div class="bold">[[i18nDynamic(locale, 'eolAdminMessageTitle')]]</div>
      <div id="adminMessage">[[eolAdminMessage]]</div>
    </div>
    <div class="flex layout vertical center-justified center">
      <!-- Use lock image indicating that end-of-life has been reached and
             the device is disabled for further use  -->
      <iron-icon icon="oobe-illos:device-disable-illo"
          class="update-illustration illustration-jelly">
      </iron-icon>
    </div>
  </div>
</oobe-adaptive-dialog>

<!-- Delete users data confirmation dialog (shown when EOL reached) -->
<oobe-modal-dialog
  id="confirmationDialog"
  title-key="eolDeleteUsersDataPopupTitle"
>
  <div slot="content">
    [[i18nDynamic(locale, 'eolDeleteUsersDataPopupMessage', deviceName)]]
  </div>
  <div slot="buttons">
    <oobe-text-button
      id="cancelDelete"
      class="focus-on-show"
    on-click="hideConfirmationDialog"
      text-key="eolDeleteUsersDataCancel"
    >
    </oobe-text-button>
    <oobe-text-button
      inverse
      on-click="onDeleteUsersConfirmed"
      id="confirmDelete"
      text-key="eolDeleteUsersDataConfirm"
    >
    </oobe-text-button>
  </div>
</oobe-modal-dialog>
<!--_html_template_end_-->`;
}
