import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="oobe-dialog-host-styles cros-color-overrides">cr-input{--cr-input-width:240px}#demoPreferencesDialog .language-selection-entry{border-top:1px solid var(--cros-sys-separator);min-height:60px}#demoPreferencesDialog .language-selection-title{color:var(--cros-text-color-primary);font-size:var(--oobe-demo-preferences-selection-title-font-size)}:host-context(.jelly-enabled) #demoPreferencesDialog .language-selection-title{color:var(--oobe-text-color)}#store-number-input-display-text{color:var(--cros-text-color-secondary);display:var(--cr-input-error-display,block);font-size:var(--oobe-demo-preferences-number-input-font-size);height:var(--cr-form-field-label-height);line-height:var(--cr-form-field-label-line-height);margin-inline-start:55%;visibility:visible;white-space:var(--cr-input-error-white-space)}:host-context(.jelly-enabled) #store-number-input-display-text{color:var(--oobe-subheader-text-color)}:host([store-number-input-invalid]) #store-number-input-display-text{color:var(--cros-textfield-label-color-error)}:host-context(.jelly-enabled):host([store-number-input-invalid]) #store-number-input-display-text{color:var(--cros-sys-error)}:host-context(.jelly-enabled) cr-input.language-selection-title{--cr-input-background-color:var(--cros-sys-input_field_on_shaded)}
</style>
<oobe-adaptive-dialog id="demoPreferencesDialog" role="dialog"
    aria-label$="[[i18nDynamic(locale, 'demoPreferencesScreenTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:gear"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'demoPreferencesScreenTitle')]]
  </h1>
  <span inner-h-t-m-l=
      "[[i18nAdvancedDynamic(locale, 'retailerPrivacyDisclaimer')]]"
    slot="subtitle">
  </span>
  <div slot="content" class="landscape-header-aligned">
    <div id="countryDropdownContainer" class="flex layout center horizontal
        justified language-selection-entry">
      <div class="language-selection-title layout vertical
          center-justified">
        [[i18nDynamic(locale, 'countryDropdownTitle')]]
      </div>
      <oobe-i18n-dropdown id="countrySelect" items="[[countries]]"
          label-for-aria="[[i18nDynamic(locale, 'countryDropdownLabel')]]"
          on-select-item="onCountrySelected_">
      </oobe-i18n-dropdown>
    </div>
    <div class="flex layout center horizontal
        justified language-selection-entry">
      <div class="language-selection-title layout vertical
          center-justified">
        <span>[[i18nDynamic(locale, 'retailerNameInputLabel')]]</span>
      </div>
      <cr-input class="language-selection-title layout horizontal
          center-justified"
          slot="input" id="retailerNameInput"
          value="{{retailerNameInput}}"
          on-keydown="onInputKeyDown_"
          placeholder=
              "[[i18nDynamic(locale, 'retailerNameInputPlaceholder')]]"
          aria-label=
              "[[i18nDynamic(locale, 'retailerNameInputPlaceholder')]]">
      </cr-input>
    </div>
    <div class="flex layout center horizontal justified
        language-selection-entry">
      <div class="language-selection-title layout vertical
          center-justified">
        <span>[[i18nDynamic(locale, 'storeNumberInputLabel')]]</span>
      </div>
      <cr-input class="language-selection-title layout horizontal
          center-justified"
                slot="input" id="storeNumberInput"
                value="{{storeNumberInput}}"
                on-keydown="onInputKeyDown_"
                placeholder=
                    "[[i18nDynamic(locale, 'storeNumberInputPlaceholder')]]"
                aria-label=
                    "[[i18nDynamic(locale, 'storeNumberInputPlaceholder')]]">
      </cr-input>
    </div>
    <div id="store-number-input-display-text">
      [[i18nDynamic(locale, 'storeNumberInputHelpText')]]
    </div>
  </div>
  <div slot="back-navigation">
    <oobe-back-button on-click="onBackClicked_"></oobe-back-button>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="nextButton" inverse on-click="onNextClicked_"
        disabled="[[!userCanContinue]]"
        text-key="demoPreferencesNextButtonLabel">
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`;
}
