import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="oobe-dialog-host-styles"></style>
<oobe-adaptive-dialog id="demoSetupProgressDialog" role="dialog"
  aria-label$="[[i18nDynamic(locale, 'demoSetupProgressScreenTitle')]]"
  for-step="progress">
  <iron-icon slot="icon" icon="oobe-32:computer"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'demoSetupProgressScreenTitle')]]
  </h1>
  <div slot="content" class="landscape-header-aligned">
    <div id="demo-setup-steps" role="list">
      <progress-list-item text-key="demoSetupProgressStepDownload"
          hidden="[[!shouldShowStep_('downloadResources', setupSteps_)]]"
          active="[[stepIsActive_(
              'downloadResources', setupSteps_, currentStepIndex_)]]"
          completed="[[stepIsCompleted_(
              'downloadResources', setupSteps_, currentStepIndex_)]]">
      </progress-list-item>
      <progress-list-item text-key="demoSetupProgressStepEnroll"
          hidden="[[!shouldShowStep_('enrollment', setupSteps_)]]"
          active="[[stepIsActive_(
              'enrollment', setupSteps_, currentStepIndex_)]]"
          completed="[[stepIsCompleted_(
              'enrollment', setupSteps_, currentStepIndex_)]]">
      </progress-list-item>
    </div>
  </div>
</oobe-adaptive-dialog>

<oobe-adaptive-dialog id="demoSetupErrorDialog" role="dialog"
    aria-label$="[[i18nDynamic(locale, 'demoSetupErrorScreenTitle')]]"
    for-step="error">
  <iron-icon slot="icon" icon="oobe-32:warning"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'demoSetupErrorScreenTitle')]]
  </h1>
  <div slot="subtitle" id="errorMessage">[[errorMessage_]]</div>
  <div slot="content" class="flex layout vertical center center-justified">
    <iron-icon icon="oobe-illos:error-illo" class="illustration-jelly">
    </iron-icon>
  </div>
  <div slot="back-navigation">
    <oobe-back-button inverse on-click="onCloseClicked_" id="back"
        disabled="[[isPowerwashRequired_]]"></oobe-back-button>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="retryButton" class="focus-on-show" inverse
        text-key="demoSetupErrorScreenRetryButtonLabel"
        on-click="onRetryClicked_" hidden="[[isPowerwashRequired_]]">
    </oobe-text-button>
    <oobe-text-button id="powerwashButton" class="focus-on-show" inverse
        text-key="demoSetupErrorScreenPowerwashButtonLabel"
        on-click="onPowerwashClicked_" hidden="[[!isPowerwashRequired_]]">
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog><!--_html_template_end_-->`;
}
