import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="oobe-dialog-host-styles">network-select-login{--cr-network-row-height:var(--oobe-network-row-height)}#quickStartWifiRow{padding-top:16px}#quickStartWifiName{padding-inline-start:16px;font-size:16px}</style>
<oobe-adaptive-dialog id="networkDialog" role="dialog"
    on-show-dialog="onShown" for-step="default"
    aria-label$="[[i18nDynamic(locale, 'networkSectionTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:wifi">
  </iron-icon>
  <h1 slot="title" id="titleText">
    <div hidden="[[useQuickStartWiFiErrorStrings]]">
      [[i18nDynamic(locale, 'networkSectionTitle')]]
    </div>
    <div hidden="[[!useQuickStartWiFiErrorStrings]]">
      [[i18nDynamic(locale, 'networkScreenQuickStartWiFiErrorTitle')]]
    </div>
  </h1>
  <div slot="subtitle" id="subtitleText">
    [[getSubtitleMessage(locale, errorMessage, useQuickStartSubtitle, useQuickStartWiFiErrorStrings)]]
  </div>
  <div slot="content" class="layout vertical">
    <network-select-login id="networkSelectLogin"
        enable-wifi-scans="[[enableWifiScans]]"
        on-selected-network-connected="onContinue"
        is-network-connected="{{isNetworkConnected}}"
        on-quick-start-clicked="onQuickStartClicked"
        is-quick-start-visible="[[isQuickStartVisible]]">
    </network-select-login>
  </div>
  <div slot="back-navigation">
    <oobe-back-button id="backButton" on-click="onBackClicked">
    </oobe-back-button>
  </div>
  <div slot="bottom-buttons" class="flex layout horizontal end-justified">
    <oobe-next-button
      id="nextButton"
      disabled="[[!isNetworkConnected]]"
      on-click="onContinue">
    </oobe-next-button>
  </div>
</oobe-adaptive-dialog>

<oobe-loading-dialog id="connectingDialog" for-step="quick-start-connecting"
    title-key="networkScreenConnectingToWifiTitle"
    subtitle-key="networkScreenQuickStartTransferWifiSubtitle">
  <iron-icon slot="icon" icon="oobe-20:quick-start-wifi">
  </iron-icon>
  <div slot="subtitle">
    [[i18nDynamic(locale, 'networkScreenQuickStartTransferWifiSubtitle')]]
    <div id="quickStartWifiRow" class="flex layout horizontal">
      <iron-icon icon="oobe-20:quick-start-wifi-bars"
              class="content-icon">
      </iron-icon>
      <div id="quickStartWifiName">[[ssid]]</div>
    </div>
  </div>
  <div slot="cancel-button">
    <oobe-text-button id="cancelButton" on-click="onCancelClicked"
        text-key="cancelButton" hidden="[[!quickStartCancelButtonVisible]]">
    </oobe-text-button>
  </div>
</oobe-loading-dialog>
<!--_html_template_end_-->`;
}
