import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2016 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles">.progress-message{color:var(--oobe-subheader-text-color);margin-top:32px}.update-illustration{height:264px;width:264px}.slide-view{border:1px solid var(--google-grey-200);border-radius:16px;height:380px;margin:auto;overflow:hidden;width:380px}:host-context(.jelly-enabled) .slide-view{border:none;border-radius:20px;height:360px}#checkingAnimation{height:300px;width:334px}</style>
<oobe-adaptive-dialog for-step="cellular" tabindex="0"
    aria-live="polite" footer-shrinkable
    id="cellular-permission-dialog">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">
    [[i18nRecursive(locale, 'updateOverCellularPromptTitle',
                    'productName')]]
  </h1>
  <p slot="subtitle">
    [[i18nDynamic(locale, 'updateOverCellularPromptMessage')]]
  </p>
  <div slot="content" class="flex layout vertical center-justified center">
    <iron-icon icon="oobe-illos:updating-illo"
        class="update-illustration  illustration-jelly">
    </iron-icon>
  </div>
  <div slot="back-navigation">
    <oobe-back-button id="cellular-permission-back" inverse
        on-click="onBackClicked"></oobe-back-button>
  </div>
  <div slot="bottom-buttons">
    <oobe-next-button id="cellular-permission-next" inverse
        on-click="onNextClicked"></oobe-next-button>
  </div>
</oobe-adaptive-dialog>
<oobe-adaptive-dialog footer-shrinkable id="checking-for-updates-dialog"
    for-step="checking" aria-live="polite">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'checkingForUpdates')]]
  </h1>
  <paper-progress slot="progress" id="checking-progress" aria-hidden="true"
    indeterminate>
  </paper-progress>
  <div slot="content" class="flex layout vertical center-justified center">
    <oobe-cr-lottie id="checkingAnimation"
        animation-url="animations/checking_for_update.json">
    </oobe-cr-lottie>
  </div>
</oobe-adaptive-dialog>
<oobe-loading-dialog id="checking-update" for-step="checking-software"
    title-key="gettingDeviceReadyTitle">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
</oobe-loading-dialog>
<oobe-adaptive-dialog footer-shrinkable id="update-in-progress-dialog"
    for-step="update" aria-live="polite">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'updateStatusTitle')]]
  </h1>
  <div slot="subtitle">
    <span id="betterUpdatePercent">[[updateStatusMessagePercent]]</span>
    <span> | </span>
    <span id="betterUpdateTimeleft">
      [[updateStatusMessageTimeLeft]]
    </span>
  </div>
  <paper-progress slot="progress" id="update-progress"
      value="[[betterUpdateProgressValue]]">
  </paper-progress>
  <div hidden="[[!showLowBatteryWarning]]" id="battery-warning"
      class="slide-view" slot="content">
    <oobe-slide is-warning>
      <iron-icon slot="slide-img" icon="oobe-illos:update-charge-illo"
          class="illustration-jelly">
      </iron-icon>
      <div slot="title">
        [[i18nDynamic(locale, 'batteryWarningTitle')]]
      </div>
      <div slot="text">
        [[i18nDynamic(locale, 'batteryWarningText')]]
      </div>
    </oobe-slide>
  </div>
  <div hidden="[[showLowBatteryWarning]]" id="carousel" class="slide-view"
      slot="content">
    <oobe-carousel
        auto-transition="[[getAutoTransition(uiStep, autoTransition)]]"
        slide-label="slideLabel"
        selected-button-label="slideSelectedButtonLabel"
        unselected-button-label="slideUnselectedButtonLabel">
      <oobe-slide slot="slides">
        <iron-icon slot="slide-img" icon="oobe-illos:update-no-waiting-illo"
            class="illustration-jelly">
        </iron-icon>
        <div slot="title">[[getUpdateSlideTitle(locale, isOptOutEnabled)]]
        </div>
        <div slot="text">[[getUpdateSlideText(locale, isOptOutEnabled)]]
        </div>
      </oobe-slide>
      <oobe-slide slot="slides">
        <iron-icon slot="slide-img" icon="oobe-illos:update-antivirus-illo"
            class="illustration-jelly">
        </iron-icon>
        <div slot="title">
          [[i18nDynamic(locale, 'slideAntivirusTitle')]]
        </div>
        <div slot="text">
          [[i18nDynamic(locale, 'slideAntivirusText')]]
        </div>
      </oobe-slide>
      <oobe-slide slot="slides">
        <iron-icon slot="slide-img" icon="oobe-illos:update-apps-illo"
            class="illustration-jelly">
        </iron-icon>
        <div slot="title">[[i18nDynamic(locale, 'slideAppsTitle')]]</div>
        <div slot="text">[[i18nDynamic(locale, 'slideAppsText')]]</div>
      </oobe-slide>
      <oobe-slide slot="slides">
        <iron-icon slot="slide-img" icon="oobe-illos:google-account-illo"
            class="illustration-jelly">
        </iron-icon>
        <div slot="title">
          [[i18nDynamic(locale, 'slideAccountTitle')]]
        </div>
        <div slot="text">
          [[i18nDynamic(locale, 'slideAccountText')]]
        </div>
      </oobe-slide>
    </oobe-carousel>
  </div>
</oobe-adaptive-dialog>
<oobe-loading-dialog id="restarting-dialog"
    title-key="updateCompeletedRebootingMsg" for-step="restart">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
</oobe-loading-dialog>
<oobe-adaptive-dialog footer-shrinkable id="better-update-complete-dialog"
    for-step="reboot" aria-live="polite">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'updateCompeletedMsg')]]
  </h1>
</oobe-adaptive-dialog>
<oobe-adaptive-dialog footer-shrinkable id="opt-out-info-dialog"
    for-step="opt-out-info" aria-live="polite">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'noUpdateAvailableTitle')]]
  </h1>
  <div slot="subtitle">
    [[i18nRecursive(locale, 'noUpdateAvailableText', 'productName')]]
  </div>
  <div slot="content" class="flex layout vertical center-justified center">
    <iron-icon icon="oobe-illos:update-not-needed-illo"
        class="illustration-jelly">
    </iron-icon>
  </div>
  <div slot="bottom-buttons">
    <oobe-next-button id="opt-out-info-next" class="focus-on-show" inverse
        on-click="onOptOutInfoNext"></oobe-next-button>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`;
}
