import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2016 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles cros-color-overrides">:host{--oobe-dialog-list-item-border:1px solid var(--cros-sys-separator);--oobe-a11y-dialog-list-item-border:1px solid var(--cros-sys-separator);color:var(--oobe-text-color);font-family:var(--oobe-default-font-family);font-size:var(--oobe-default-font-size);font-weight:var(--oobe-default-font-weight);line-height:var(--oobe-default-line-height)}:host-context(.jelly-enabled) cr-input#editRequisitionInput{--cr-input-background-color:var(--cros-sys-input_field_on_shaded)}#languageScreen .language-selection-entry{border-top:var(--oobe-dialog-list-item-border);min-height:var(--selection-entry-height)}#languageScreen .language-selection-entry:last-of-type{border-bottom:var(--oobe-dialog-list-item-border)}#accessibilityScreen oobe-a11y-option{border-top:var(--oobe-a11y-dialog-list-item-border);min-height:var(--a11y-option-height)}#accessibilityScreen oobe-a11y-option:last-of-type{border-bottom:var(--oobe-a11y-dialog-list-item-border)}#timezoneScreen .timezone-selection-entry{border-top:var(--oobe-dialog-list-item-border);min-height:var(--selection-entry-height)}#timezoneScreen .timezone-selection-entry:last-of-type{border-bottom:var(--oobe-dialog-list-item-border)}#oobeAdvancedOptionsScreen .advanced-options-entry{border-top:var(--oobe-dialog-list-item-border);min-height:64px}#oobeAdvancedOptionsScreen .advanced-options-entry:last-of-type{border-bottom:var(--oobe-dialog-list-item-border)}#oobeAdvancedOptionsScreen .advanced-option-subtitle{color:var(--google-grey-700)}</style>
<oobe-welcome-dialog
  id="welcomeScreen"
  role="dialog"
  for-step="greeting"
  aria-label$="[[i18nDynamic(locale, 'welcomeScreenGreeting')]]"
  current-language="[[currentLanguage]]"
  on-language-button-clicked="onWelcomeSelectLanguageButtonClicked"
  on-accessibility-button-clicked="onWelcomeAccessibilityButtonClicked"
  on-timezone-button-clicked="onWelcomeTimezoneButtonClicked"
  on-next-button-clicked="onWelcomeNextButtonClicked"
  on-activate-quick-start="onActivateQuickStart"
  on-enable-debugging-clicked="onEnableDebuggingClicked"
  on-launch-advanced-options="onWelcomeLaunchAdvancedOptions"
  on-chromevox-hint-accepted="onChromeVoxHintAccepted"
  on-chromevox-hint-dismissed="onChromeVoxHintDismissed"
  timezone-button-visible="[[isTimezoneButtonVisible(highlightStrength)]]"
  debugging-link-visible="[[debuggingLinkVisible]]"
>
</oobe-welcome-dialog>
<oobe-adaptive-dialog
  id="languageScreen"
  role="dialog"
  for-step="language"
  aria-label$="[[i18nDynamic(locale, 'languageSectionTitle')]]"
>
  <iron-icon slot="icon" icon="oobe-32:language"></iron-icon>
  <h1 slot="title">[[i18nDynamic(locale, 'languageSectionTitle')]]</h1>
  <p slot="subtitle" id="languageSectionHintSubtitle">
    [[i18nDynamic(locale, 'languageSectionHint')]]
    <a
      id="languagesLearnMore"
      class="oobe-local-link"
      is="action-link"
      on-click="onLanguageLearnMoreLinkClicked"
      aria-describedby="languageSectionHintSubtitle"
    >
      [[i18nDynamic(locale, 'learnMore')]]
    </a>
  </p>
  <div id="setup-container" slot="content" class="landscape-header-aligned">
    <div
      id="languageDropdownContainer"
      class="flex layout center horizontal justified language-selection-entry"
    >
      <div id="language-dropdown">
        [[i18nDynamic(locale, 'languageDropdownTitle')]]
      </div>
      <oobe-i18n-dropdown
        id="languageSelect"
        items="[[languages]]"
        on-select-item="onLanguageSelected"
        class="focus-on-show"
        label-for-aria="[[i18nDynamic(locale, 'languageDropdownLabel')]]"
      >
      </oobe-i18n-dropdown>
    </div>
    <div
      id="keyboardDropdownContainer"
      class="flex layout center horizontal justified language-selection-entry"
    >
      <div id="keyboard-dropdown">
        [[i18nDynamic(locale, 'keyboardDropdownTitle')]]
      </div>
      <oobe-i18n-dropdown
        id="keyboardSelect"
        items="[[keyboards]]"
        on-select-item="onKeyboardSelected"
        label-for-aria="[[i18nDynamic(locale, 'keyboardDropdownLabel')]]"
      >
      </oobe-i18n-dropdown>
    </div>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button
      id="ok-button-language"
      text-key="oobeOKButtonText"
      inverse
      on-click="closeLanguageSection"
    ></oobe-text-button>
  </div>
</oobe-adaptive-dialog>
<oobe-adaptive-dialog
  id="accessibilityScreen"
  role="dialog"
  for-step="accessibility"
  aria-label$="[[i18nDynamic(locale, 'accessibilitySectionTitle')]]"
>
  <iron-icon slot="icon" icon="oobe-32:accessibility"></iron-icon>
  <h1 slot="title">[[i18nDynamic(locale, 'accessibilitySectionTitle')]]</h1>
  <p slot="subtitle">[[i18nDynamic(locale, 'accessibilitySectionHint')]]</p>
  <div slot="content" class="layout vertical">
    <oobe-a11y-option
      id="accessibility-spoken-feedback"
      checked="[[a11yStatus.spokenFeedbackEnabled]]"
      on-change="onA11yOptionChanged"
      label-for-aria="[[i18nDynamic(locale, 'spokenFeedbackOption')]]"
      class="focus-on-show"
    >
      <span slot="title">
        [[i18nDynamic(locale, 'spokenFeedbackOption')]]
      </span>
      <span slot="checked-value">
        [[i18nDynamic(locale, 'a11ySettingToggleOptionOn')]]
      </span>
      <span slot="unchecked-value">
        [[i18nDynamic(locale, 'a11ySettingToggleOptionOff')]]
      </span>
    </oobe-a11y-option>
    <oobe-a11y-option
      id="accessibility-large-cursor"
      checked="[[a11yStatus.largeCursorEnabled]]"
      on-change="onA11yOptionChanged"
      label-for-aria="[[i18nDynamic(locale, 'largeCursorOption')]]"
    >
      <span slot="title"> [[i18nDynamic(locale, 'largeCursorOption')]] </span>
      <span slot="checked-value">
        [[i18nDynamic(locale, 'largeCursorOptionOn')]]
      </span>
      <span slot="unchecked-value">
        [[i18nDynamic(locale, 'largeCursorOptionOff')]]
      </span>
    </oobe-a11y-option>
    <oobe-a11y-option
      id="accessibility-high-contrast"
      checked="[[a11yStatus.highContrastEnabled]]"
      on-change="onA11yOptionChanged"
      label-for-aria="[[i18nDynamic(locale, 'highContrastOption')]]"
    >
      <span slot="title"> [[i18nDynamic(locale, 'highContrastOption')]] </span>
      <span slot="checked-value">
        [[i18nDynamic(locale, 'a11ySettingToggleOptionOn')]]
      </span>
      <span slot="unchecked-value">
        [[i18nDynamic(locale, 'a11ySettingToggleOptionOff')]]
      </span>
    </oobe-a11y-option>
    <oobe-a11y-option
      id="accessibility-screen-magnifier"
      checked="[[a11yStatus.screenMagnifierEnabled]]"
      on-change="onA11yOptionChanged"
      label-for-aria="[[i18nDynamic(locale, 'screenMagnifierOption')]]"
    >
      <span slot="title">
        [[i18nDynamic(locale, 'screenMagnifierOption')]]
      </span>
      <span slot="checked-value">
        [[i18nDynamic(locale, 'a11ySettingToggleOptionOn')]]
      </span>
      <span slot="unchecked-value">
        [[i18nDynamic(locale, 'a11ySettingToggleOptionOff')]]
      </span>
    </oobe-a11y-option>
    <oobe-a11y-option
      id="accessibility-select-to-speak"
      checked="[[a11yStatus.selectToSpeakEnabled]]"
      on-change="onA11yOptionChanged"
      label-for-aria="[[i18nDynamic(locale, 'selectToSpeakOption')]]"
      id="selectToSpeakOobeOption"
    >
      <span slot="title"> [[i18nDynamic(locale, 'selectToSpeakOption')]] </span>
      <span slot="checked-value">
        [[i18nDynamic(locale, 'a11ySettingToggleOptionOn')]]
      </span>
      <span slot="unchecked-value">
        [[i18nDynamic(locale, 'a11ySettingToggleOptionOff')]]
      </span>
    </oobe-a11y-option>
    <oobe-a11y-option
      id="accessibility-docked-magnifier"
      checked="[[a11yStatus.dockedMagnifierEnabled]]"
      on-change="onA11yOptionChanged"
      label-for-aria="[[i18nDynamic(locale, 'dockedMagnifierOption')]]"
    >
      <span slot="title">
        [[i18nDynamic(locale, 'dockedMagnifierOption')]]
      </span>
      <span slot="checked-value">
        [[i18nDynamic(locale, 'a11ySettingToggleOptionOn')]]
      </span>
      <span slot="unchecked-value">
        [[i18nDynamic(locale, 'a11ySettingToggleOptionOff')]]
      </span>
    </oobe-a11y-option>
    <oobe-a11y-option
      id="accessibility-virtual-keyboard"
      checked="[[a11yStatus.virtualKeyboardEnabled]]"
      on-change="onA11yOptionChanged"
      label-for-aria="[[i18nDynamic(locale, 'virtualKeyboardOption')]]"
    >
      <span slot="title">
        [[i18nDynamic(locale, 'virtualKeyboardOption')]]
      </span>
      <span slot="checked-value">
        [[i18nDynamic(locale, 'a11ySettingToggleOptionOn')]]
      </span>
      <span slot="unchecked-value">
        [[i18nDynamic(locale, 'a11ySettingToggleOptionOff')]]
      </span>
    </oobe-a11y-option>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button
      id="ok-button-accessibility"
      text-key="oobeOKButtonText"
      inverse
      on-click="closeAccessibilitySection"
    ></oobe-text-button>
  </div>
</oobe-adaptive-dialog>
<oobe-adaptive-dialog
  id="timezoneScreen"
  role="dialog"
  for-step="timezone"
  aria-label$="[[i18nDynamic(locale, 'timezoneSectionTitle')]]"
>
  <iron-icon slot="icon" icon="oobe-32:timezone"></iron-icon>
  <h1 slot="title">[[i18nDynamic(locale, 'timezoneSectionTitle')]]</h1>
  <div slot="content" class="landscape-header-aligned">
    <div
      class="flex layout center horizontal justified timezone-selection-entry"
    >
      <div>[[i18nDynamic(locale, 'timezoneDropdownTitle')]]</div>
      <oobe-i18n-dropdown
        id="timezoneSelect"
        items="[[timezones]]"
        on-select-item="onTimezoneSelected"
        label-for-aria="[[i18nDynamic(locale, 'timezoneDropdownLabel')]]"
        class="focus-on-show"
      >
      </oobe-i18n-dropdown>
    </div>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button
      id="ok-button-timezone"
      text-key="oobeOKButtonText"
      inverse
      on-click="closeTimezoneSection"
    ></oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<!-- Advanced options dialog -->
<oobe-adaptive-dialog
  id="oobeAdvancedOptionsScreen"
  role="dialog"
  for-step="advanced-options"
  aria-label$="[[i18nDynamic(locale, 'advancedOptionsSectionTitle')]]"
>
  <iron-icon slot="icon" icon="oobe-32:gear"></iron-icon>
  <h1 slot="title">[[i18nDynamic(locale, 'advancedOptionsSectionTitle')]]</h1>
  <div slot="content" class="landscape-header-aligned">
    <div class="flex layout vertical center-justified advanced-options-entry"
        hidden="[[hideCfmSetupButton(isDeviceRequisitionConfigurable,
                                     isMeet)]]">
      <button on-click="onCfmBootstrappingClicked">
        <div>[[i18nDynamic(locale, 'advancedOptionsCFMSetupTitle')]]</div>
        <div class="advanced-option-subtitle">
          [[i18nDynamic(locale, 'advancedOptionsCFMSetupSubtitle')]]
        </div>
      </button>
    </div>
    <div class="flex layout vertical center-justified advanced-options-entry"
        hidden="[[!isDeviceRequisitionConfigurable]]">
      <button on-click="onDeviceRequisitionClicked">
        <div>
          [[i18nDynamic(locale, 'advancedOptionsDeviceRequisitionTitle')]]
        </div>
        <div class="advanced-option-subtitle">
          [[i18nDynamic(locale, 'advancedOptionsDeviceRequisitionSubtitle')]]
        </div>
      </button>
    </div>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button
      id="ok-button-advanced-options"
      text-key="oobeOKButtonText"
      inverse
      on-click="closeAdvancedOptionsSection"
    ></oobe-text-button>
  </div>
</oobe-adaptive-dialog>

<!-- Demo Mode confirmation dialog -->
<oobe-modal-dialog id="demoModeConfirmationDialog">
  <div slot="title">[[i18nDynamic(locale, 'enableDemoModeDialogTitle')]]</div>
  <div slot="content">[[i18nDynamic(locale, 'enableDemoModeDialogText')]]</div>
  <div slot="buttons">
    <oobe-text-button
      id="cancelButton"
      border
      on-click="onDemoModeDialogCancel"
      text-key="enableDemoModeDialogCancel"
    ></oobe-text-button>
    <oobe-text-button
      inverse
      id="okButton"
      class="focus-on-show"
      on-click="onDemoModeDialogConfirm"
      text-key="enableDemoModeDialogConfirm"
    ></oobe-text-button>
  </div>
</oobe-modal-dialog>

<!-- Remora requisition dialog -->
<oobe-modal-dialog id="remoraRequisitionDialog">
  <div slot="title">
    [[i18nDynamic(locale, 'deviceRequisitionRemoraPromptText')]]
  </div>
  <div slot="buttons">
    <oobe-text-button
      border
      on-click="onRemoraCancel"
      text-key="deviceRequisitionRemoraPromptCancel"
    ></oobe-text-button>
    <oobe-text-button
      inverse
      class="focus-on-show"
      on-click="onRemoraConfirm"
      text-key="deviceRequisitionRemoraPromptOk"
    ></oobe-text-button>
  </div>
</oobe-modal-dialog>

<!-- Edit requisition dialog -->
<oobe-modal-dialog id="editRequisitionDialog">
  <div slot="title">[[i18nDynamic(locale, 'deviceRequisitionPromptText')]]</div>
  <cr-input
    id="editRequisitionInput"
    slot="content"
    placeholder="[[i18nDynamic(locale,
              'advancedOptionsDeviceRequisitionTitle')]]"
  >
  </cr-input>
  <div slot="buttons">
    <oobe-text-button
      border
      on-click="onEditRequisitionCancel"
      text-key="deviceRequisitionPromptCancel"
    ></oobe-text-button>
    <oobe-text-button
      inverse
      class="focus-on-show"
      on-click="onEditRequisitionConfirm"
      text-key="deviceRequisitionPromptOk"
    ></oobe-text-button>
  </div>
</oobe-modal-dialog>
<!--_html_template_end_-->`;
}
