import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2016 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="cr-shared-style oobe-dialog-host-styles">:host{--oobe-welcome-dialog-horizontal-padding:40px;box-sizing:border-box;height:var(--oobe-adaptive-dialog-height);padding-bottom:var(--oobe-adaptive-dialog-buttons-vertical-padding);padding-inline-end:var(--oobe-welcome-dialog-horizontal-padding);padding-inline-start:var(--oobe-welcome-dialog-horizontal-padding);padding-top:var(--oobe-adaptive-dialog-back-button-vertical-padding);width:var(--oobe-adaptive-dialog-width)}@media (orientation:portrait){:host(:host-context(.boot-animation-enabled)){padding-inline-start:calc(var(--oobe-adaptive-dialog-width) / 3)}}@media (orientation:landscape){:host(:host-context(.boot-animation-enabled)){padding-inline-start:calc(var(--oobe-welcome-dialog-horizontal-padding) + var(--oobe-adaptive-dialog-width) / 2)}}#dialog{box-sizing:border-box;height:100%}#content{display:grid;flex-grow:1;min-height:0}:host-context(.boot-animation-enabled) #content{flex-grow:0}@media (orientation:portrait){#content{grid-template-columns:auto;grid-template-rows:min-content auto min-content}}@media (orientation:landscape){#content{grid-template-columns:auto minmax(0,1fr);grid-template-rows:minmax(0,1fr) minmax(0,1fr)}:host-context(.boot-animation-enabled) #content{grid-template-columns:auto}}#getStarted[disabled]{opacity:0}#getStarted{transition:opacity 250ms linear 0ms}#buttons{grid-column:1/span 1;grid-row:1/span 1}@media (orientation:portrait){#buttons{align-items:center;align-self:center;justify-self:center}:host-context(.boot-animation-enabled) #buttons{align-items:normal;align-self:start;justify-self:start}}@media (orientation:landscape){#buttons{align-self:start;justify-self:start}}@media (orientation:portrait){#bottomButtons{align-self:end;grid-column:1/span 1;grid-row:3/span 1;justify-self:center}}@media (orientation:landscape){#bottomButtons{align-self:end;grid-column:1/span 1;grid-row:2/span 1;justify-self:start}}:host-context(.boot-animation-enabled) #bottomButtons{justify-self:end;margin-top:72px}#welcomeAnimation{min-height:0;min-width:0}@media (orientation:portrait){#welcomeAnimationSlot{grid-column:1/span 1;grid-row:2/span 1;place-self:stretch}}@media (orientation:landscape){#welcomeAnimationSlot{align-self:stretch;grid-column:2/span 1;grid-row:1/span 2}}#welcomeAnimationSlot{position:relative}.stacked-animations{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%)}#accessibilitySettingsButton,#timezoneSettingsButton,#enableDebuggingButton{margin-top:16px}#title{color:var(--oobe-header-text-color);font-family:var(--oobe-header-font-family);font-size:var(--oobe-welcome-header-font-size);line-height:var(--oobe-welcome-header-line-height);margin-bottom:0}@media (orientation:landscape){#title{margin-top:48px}}@media (orientation:portrait){#title{margin-top:40px}}:host-context(.boot-animation-enabled) #title{font-size:var(--oobe-welcome-header-font-size);line-height:var(--oobe-welcome-header-line-height);margin-bottom:48px;margin-top:auto}#subtitle{color:var(--oobe-subheader-text-color);font-family:var(--oobe-header-font-family);font-size:var(--oobe-welcome-subheader-font-size);line-height:var(--oobe-welcome-subheader-line-height);margin-top:16px}@media (orientation:landscape){#subtitle{margin-bottom:64px}}@media (orientation:portrait){#subtitle{margin-bottom:40px}}:host-context(.jelly-enabled) .welcome-left-buttons{--oobe-button-font-family:var(--oobe-welcome-left-button-font-family);--oobe-button-font-size:var(--oobe-welcome-left-button-font-size);--oobe-button-font-weight:var(--oobe-welcome-left-button-font-weight);line-height:var(--cros-body-0-line-height)}.welcome-header-text{font-weight:var(--oobe-welcome-header-font-weight)}@media (orientation:portrait){.welcome-header-text{align-self:center;text-align:center}:host-context(.boot-animation-enabled) .welcome-header-text{align-self:auto;text-align:start}}@media (orientation:landscape){.welcome-header-text{text-align:start}}:host-context(.jelly-enabled) oobe-icon-button.bg-transparent{--oobe-button-icon-fill-color:var(--oobe-button-icon-fill-color-bg-transparent);--oobe-icon-button-text-color:var(--oobe-icon-button-text-color-bg-transparent)}.illustration-jelly{width:100%;height:100%}:host-context(html:not([tablet])) #chromeVoxHintContentTablet{display:none}:host-context(html[tablet]) #chromeVoxHintContentClamshell{display:none}
</style>
<div id="dialog" class="layout vertical">
  <h1 id="title" class="welcome-header-text">
    [[i18nDynamic(locale, 'welcomeScreenGreeting')]]
  </h1>
  <template is="dom-if" if="[[!isBootAnimation]]">
    <div id="subtitle" class="welcome-header-text">
      [[i18nDynamic(locale, 'welcomeScreenGreetingSubtitle')]]
    </div>
  </template>
  <div id="content">
    <div id="buttons" class="layout vertical welcome-left-buttons">
      <oobe-icon-button
        class="bg-transparent"
        id="languageSelectionButton"
        icon1x="oobe-20:welcome-language"
        icon2x="oobe-40:welcome-language"
        on-click="onLanguageClicked"
        label-for-aria="[[i18nDynamic(locale, 'languageButtonLabel',
                  currentLanguage)]]"
      >
        <div slot="text">[[currentLanguage]]</div>
      </oobe-icon-button>
      <template is="dom-if" if="[[!isFjord]]">
        <oobe-icon-button
          class="bg-transparent"
          id="accessibilitySettingsButton"
          text-key="accessibilityLink"
          icon1x="oobe-20:welcome-accessibility"
          icon2x="oobe-40:welcome-accessibility"
          on-click="onAccessibilityClicked"
        >
        </oobe-icon-button>
      </template>
      <oobe-icon-button
        class="bg-transparent"
        id="timezoneSettingsButton"
        text-key="timezoneButtonText"
        icon1x="oobe-32:timezone"
        icon2x="oobe-32:timezone"
        on-click="onTimezoneClicked"
        hidden="[[!timezoneButtonVisible]]"
      >
      </oobe-icon-button>
      <oobe-icon-button
        class="bg-transparent"
        id="enableDebuggingButton"
        text-key="debuggingFeaturesLink"
        icon1x="oobe-32:chromebook"
        icon2x="oobe-32:chromebook"
        on-click="onDebuggingLinkClicked"
        hidden="[[!debuggingLinkVisible]]"
      >
      </oobe-icon-button>
    </div>
    <div id="bottomButtons" class="layout horizontal">
      <quick-start-entry-point
        id="quickStartWelcomeEntryPoint"
        quick-start-text-key="welcomeScreenQuickStart"
        hidden="[[!isQuickStartEnabled]]"
      >
      </quick-start-entry-point>
      <oobe-text-button
        id="getStarted"
        inverse
        on-click="onNextClicked"
        text-key="welcomeScreenGetStarted"
      >
      </oobe-text-button>
    </div>
    <template is="dom-if" if="[[showAnimationSlot()]]">
      <div id="welcomeAnimationSlot">
        <template is="dom-if" if="[[!isMeet]]">
          <iron-icon id="welcomeAnimationFirstFrame" icon="oobe-illos:connect-illo"
              class="illustration-jelly stacked-animations" hidden="[[isOobeLoaded]]">
          </iron-icon>
          <oobe-cr-lottie
            id="welcomeAnimation" preload
            animation-url="animations/welcome_screen_animation.json"
            class="stacked-animations"
          >
          </oobe-cr-lottie>
        </template>
        <template is="dom-if" if="[[isMeet]]">
          <img
            src="/images/cfm/welcome.svg"
            class="oobe-illustration"
            id="remoraWelcomeImage"
            aria-hidden="true"
          >
        </template>
      </div>
    </template>
  </div>
</div>
<oobe-modal-dialog id="chromeVoxHint">
  <div id="chromeVoxHintTitle"
    slot="title">
    <hd-iron-icon icon1x="oobe-20:welcome-accessibility"
      icon2x="oobe-40:welcome-accessibility"></hd-iron-icon>
    <p>[[i18nDynamic(locale, 'chromevoxHintTitle')]]</p>
  </div>
  <div slot="content">
    <div id="chromeVoxHintContentClamshell">[[i18nDynamic(locale,
        'chromeVoxHintAnnouncementTextLaptopExpanded')]]</div>
    <div id="chromeVoxHintContentTablet">[[i18nDynamic(locale,
        'chromeVoxHintAnnouncementTextTabletExpanded')]]</div>
  </div>
  <div slot="buttons">
    <oobe-text-button
      id="dismissChromeVoxButton"
      on-click="dismissChromeVoxHint"
      text-key="chromevoxHintClose"
    >
    </oobe-text-button>
  </div>
</oobe-modal-dialog>
<!--_html_template_end_-->`;
}
