import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!-- Copyright 2022 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file. -->

<style include="oobe-dialog-host-styles"></style>
<oobe-loading-dialog id="loadingDialog" role="dialog" for-step="loading"
    title-key="gaiaLoading">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
</oobe-loading-dialog>

<oobe-adaptive-dialog id="reauthNotificationDialog"
    role="dialog" for-step="reauth-notification"
    aria-label$="[[i18nDynamic(locale,
        'cryptohomeRecoveryReauthNotificationTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'cryptohomeRecoveryReauthNotificationTitle')]]
  </h1>
  <div slot="subtitle">
    [[i18nDynamic(locale, 'cryptohomeRecoveryReauthNotificationSubtitle')]]
  </div>
  <div slot="content" class="flex layout vertical center center-justified">
    <iron-icon icon="oobe-illos:smart-lock-illo"
        class="illustration-jelly">
    </iron-icon>
  </div>
  <div slot="bottom-buttons">
    <oobe-next-button id="reauthButton" class="focus-on-show"
        on-click="onReauthButtonClicked">
    </oobe-next-button>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`;
}
