// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/polymer/v3_0/iron-icon/iron-icon.js';
import '../../components/oobe_icons.html.js';
import '../../components/common_styles/oobe_common_styles.css.js';
import '../../components/common_styles/oobe_dialog_host_styles.css.js';
import '../../components/dialogs/oobe_adaptive_dialog.js';
import '../../components/dialogs/oobe_loading_dialog.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { LoginScreenMixin } from '../../components/mixins/login_screen_mixin.js';
import { MultiStepMixin } from '../../components/mixins/multi_step_mixin.js';
import { OobeI18nMixin } from '../../components/mixins/oobe_i18n_mixin.js';
import { getTemplate } from './cryptohome_recovery_setup.html.js';
/**
 * UI mode for the dialog.
 */
// eslint-disable-next-line @typescript-eslint/naming-convention
var CryptohomeRecoverySetupUIState;
(function (CryptohomeRecoverySetupUIState) {
    CryptohomeRecoverySetupUIState["LOADING"] = "loading";
    CryptohomeRecoverySetupUIState["ERROR"] = "error";
})(CryptohomeRecoverySetupUIState || (CryptohomeRecoverySetupUIState = {}));
const CryptohomeRecoverySetupBase = LoginScreenMixin(MultiStepMixin(OobeI18nMixin(PolymerElement)));
class CryptohomeRecoverySetup extends CryptohomeRecoverySetupBase {
    static get is() {
        return 'cryptohome-recovery-setup-element';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {};
    }
    // eslint-disable-next-line @typescript-eslint/naming-convention
    defaultUIStep() {
        return CryptohomeRecoverySetupUIState.LOADING;
    }
    get UI_STEPS() {
        return CryptohomeRecoverySetupUIState;
    }
    get EXTERNAL_API() {
        return [
            'setLoadingState',
            'onSetupFailed',
        ];
    }
    ready() {
        super.ready();
        this.initializeLoginScreen('CryptohomeRecoverySetupScreen');
    }
    reset() {
        this.setUIStep(CryptohomeRecoverySetupUIState.LOADING);
    }
    /**
     * Called to show the spinner in the UI.
     */
    setLoadingState() {
        this.setUIStep(CryptohomeRecoverySetupUIState.LOADING);
    }
    /**
     * Called when Cryptohome recovery setup failed.
     */
    onSetupFailed() {
        this.setUIStep(CryptohomeRecoverySetupUIState.ERROR);
    }
    /**
     * Skip button click handler.
     */
    onSkip() {
        this.userActed('skip');
    }
    /**
     * Retry button click handler.
     */
    onRetry() {
        this.userActed('retry');
    }
}
customElements.define(CryptohomeRecoverySetup.is, CryptohomeRecoverySetup);
