import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2023 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles cros-color-overrides">#oldPasswordInput{padding-top:16px}@media (orientation:portrait){#oldPasswordInput{padding-top:24px;text-align:initial;width:calc(var(--oobe-adaptive-dialog-width) - 48px - 2 * var(--oobe-adaptive-dialog-content-padding))}}:host-context(.jelly-enabled) cr-input#oldPasswordInput{--cr-input-background-color:var(--cros-sys-input_field_on_shaded)}</style>

<oobe-adaptive-dialog role="dialog" for-step="password" id="passwordStep"
    single-column>
  <iron-icon slot="icon" icon="oobe-32:lock"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale,'recoverLocalDataTitle')]]
  </h1>
  <div slot="subtitle">
    [[i18nDynamic(locale, 'recoverLocalDataSubtitle')]]
  </div>
  <cr-input slot="subtitle" type="password" id="oldPasswordInput"
      value="{{password}}" invalid="{{passwordInvalid}}"
      required class="focus-on-show"
      placeholder="[[i18nDynamic(locale, 'oldPasswordHint')]]"
      error-message="[[i18nDynamic(locale, 'oldPasswordIncorrect')]]">
  </cr-input>
  <div slot="bottom-buttons">
    <oobe-text-button id="forgotPasswordButton"
        on-click="onForgotPasswordClicked"
        text-key="forgotOldPasswordButton">
    </oobe-text-button>
    <oobe-next-button id="next" on-click="submit" inverse>
    </oobe-next-button>
  </div>
</oobe-adaptive-dialog>

<oobe-loading-dialog id="progress" role="dialog" for-step="progress"
    title-key="gaiaLoading">
  <iron-icon slot="icon" icon="oobe-32:googleg"></iron-icon>
</oobe-loading-dialog>
<!--_html_template_end_-->`;
}
