import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2018 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->


<style include="oobe-dialog-host-styles">#sensorLocationContainer{height:100%;overflow-y:hidden;width:100%}</style>
<oobe-adaptive-dialog id="setupFingerprint" role="dialog" for-step="start"
    footer-shrinkable>
  <h1 slot="title" hidden="[[isChildAccount]]" aria-live="polite">
    [[i18nDynamic(locale, 'setupFingerprintScreenTitle')]]
  </h1>
  <h1 slot="title" hidden="[[!isChildAccount]]" aria-live="polite">
    [[i18nDynamic(locale, 'setupFingerprintScreenTitleForChild')]]
  </h1>
  <p slot="subtitle" hidden="[[isChildAccount]]" aria-live="polite">
    [[i18nDynamic(locale, 'setupFingerprintScreenDescription')]]
  </p>
  <p slot="subtitle" hidden="[[!isChildAccount]]" aria-live="polite">
    [[i18nDynamic(locale, 'setupFingerprintScreenDescriptionForChild')]]
  </p>
  <iron-icon slot="icon" icon="oobe-32:fingerprint"></iron-icon>
  <div slot="content" class="flex layout vertical center center-justified">
    <div id="sensorLocationContainer" class="oobe-illustration">
      <oobe-cr-lottie id="scannerLocationLottie"
          animation-url="fingerprint_scanner_animation.json">
      </oobe-cr-lottie>
    </div>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="skipStart"
        text-key="skipFingerprintSetup"
        on-click="onSkipOnStart" class="focus-on-show">
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>
<oobe-adaptive-dialog id="startFingerprintEnroll" role="dialog"
    for-step="progress" footer-shrinkable
    aria-label$="[[i18nDynamic(locale, 'enrollmentProgressScreenTitle')]]">
  <iron-icon slot="icon" icon="oobe-32:fingerprint"></iron-icon>
  <h1 slot="title" hidden="[[complete]]">
    [[i18nDynamic(locale, 'enrollmentProgressScreenTitle')]]
  </h1>
  <h1 slot="title" hidden="[[!complete]]">
    [[i18nDynamic(locale, 'setupFingerprintEnrollmentSuccessTitle')]]
  </h1>
  <div slot="subtitle" hidden="[[!complete]]">
    <div hidden="[[isChildAccount]]">
      [[i18nDynamic(locale,
          'setupFingerprintEnrollmentSuccessDescription')]]
    </div>
    <div hidden="[[!isChildAccount]]">
      [[i18nDynamic(locale,
          'setupFingerprintEnrollmentSuccessDescriptionForChild')]]
    </div>
  </div>
  <div slot="subtitle" hidden="[[!isProblemImmobile(scanResult)]]">
    <div hidden="[[isChildAccount]]">
      [[i18nDynamic(locale, 'setupFingerprintScanMoveFinger')]]
    </div>
    <div hidden="[[!isChildAccount]]">
      [[i18nDynamic(locale, 'setupFingerprintScanMoveFingerForChild')]]
    </div>
  </div>
  <div slot="subtitle" hidden="[[!isProblemOther(scanResult)]]">
    [[i18nDynamic(locale, 'setupFingerprintScanTryAgain')]]
  </div>
  <div slot="content" class="flex layout vertical center center-justified">
    <fingerprint-progress id="arc" dynamic="[[isDynamicColor]]">
    </fingerprint-progress>
  </div>
  <div slot="bottom-buttons">
    <oobe-text-button id="skipProgress"
        on-click="onSkipInProgress" class="focus-on-show"
        text-key="skipFingerprintSetup"
        hidden="[[complete]]">
    </oobe-text-button>
    <oobe-text-button id="addAnotherFinger"
        text-key="fingerprintSetupAddAnother"
        hidden="[[!isAnotherButtonVisible(percentComplete,
            canAddFinger)]]"
        on-click="onAddAnother">
    </oobe-text-button>
    <oobe-text-button id="done"
        hidden="[[!complete]]"
        text-key="fingerprintSetupDone"
        on-click="onDone" class="focus-on-show" inverse>
    </oobe-text-button>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`;
}
