import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!-- Copyright 2023 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file. -->

<style include="oobe-dialog-host-styles cr-card-radio-group-styles
    cros-color-overrides">@media screen and (max-width:920px){:host{--radio-button-height:155px}}.card-icon{height:32px;width:32px}</style>

<oobe-adaptive-dialog role="presentation" aria-live="polite"
    for-step="selection">
  <iron-icon slot="icon" icon="oobe-32:lock"></iron-icon>
  <h1 slot="title">
    [[i18nDynamic(locale, 'passwordSelectionTitle')]]
  </h1>
  <div slot="subtitle">
    [[i18nDynamic(locale, 'passwordSelectionSubtitile')]]
  </div>
  <div slot="content" class="layout vertical landscape-vertical-centered">
    <cr-radio-group id="userType" selected="{{selectedPasswordType}}">
      <cr-card-radio-button id="localPasswordButton" class="focus-on-show"
          name="[[passwordTypeEnum.LOCAL_PASSWORD]]">
        <div class="card-container">
          <iron-icon icon="oobe-32:password" class="card-icon">
          </iron-icon>
          <div class="card-content">
            <div class="card-label">
              [[i18nDynamic(locale, 'localPasswordSelectionLabel')]]
            </div>
          </div>
        </div>
      </cr-card-radio-button>
      <cr-card-radio-button id="gaiaPasswordButton" class="flex"
          name="[[passwordTypeEnum.GAIA_PASSWORD]]">
        <div class="card-container">
          <iron-icon icon="oobe-32:google-g" class="card-icon">
          </iron-icon>
          <div class="card-content">
            <div class="card-label">
              [[i18nDynamic(locale, 'gaiaPasswordSelectionLabel')]]
            </div>
          </div>
        </div>
      </cr-card-radio-button>
    </cr-radio-group>
  </div>
  <div slot="back-navigation">
    <oobe-back-button id="backButton" on-click="onBackClicked"
        hidden="[[!backButtonVisible]]">
    </oobe-back-button>
  </div>
  <div slot="bottom-buttons">
    <oobe-next-button id="nextButton"
        on-click="onNextClicked" disabled="[[!selectedPasswordType]]">
    </oobe-next-button>
  </div>
</oobe-adaptive-dialog>

<oobe-loading-dialog id="password-selection-progress" role="dialog"
    for-step="progress" title-key="gaiaLoading">
  <iron-icon slot="icon" icon="oobe-32:lock"></iron-icon>
</oobe-loading-dialog>
<!--_html_template_end_-->`;
}
