// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { PageHandlerFactory, PageHandlerRemote } from './manage_mirrorsync.mojom-webui.js';
export class BrowserProxy {
    handler = new PageHandlerRemote();
    constructor() {
        const factory = PageHandlerFactory.getRemote();
        factory.createPageHandler(this.handler.$.bindNewPipeAndPassReceiver());
    }
    static getInstance() {
        return instance || (instance = new BrowserProxy());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
let instance = null;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYnJvd3Nlcl9wcm94eS5qcyIsInNvdXJjZVJvb3QiOiIvYi9zL3cvaXIvY2FjaGUvYnVpbGRlci9zcmMvb3V0LzUwMTgtQ2hyb21pdW1PU19BU0FOL2dlbi9jaHJvbWUvYnJvd3Nlci9yZXNvdXJjZXMvY2hyb21lb3MvbWFuYWdlX21pcnJvcnN5bmMvIiwic291cmNlcyI6WyJicm93c2VyX3Byb3h5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLHNDQUFzQztBQUN0Qyx5RUFBeUU7QUFDekUsNkJBQTZCO0FBRTdCLE9BQU8sRUFBQyxrQkFBa0IsRUFBRSxpQkFBaUIsRUFBQyxNQUFNLG9DQUFvQyxDQUFDO0FBRXpGLE1BQU0sT0FBTyxZQUFZO0lBQ3ZCLE9BQU8sR0FBc0IsSUFBSSxpQkFBaUIsRUFBRSxDQUFDO0lBRXJEO1FBQ0UsTUFBTSxPQUFPLEdBQUcsa0JBQWtCLENBQUMsU0FBUyxFQUFFLENBQUM7UUFDL0MsT0FBTyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLDBCQUEwQixFQUFFLENBQUMsQ0FBQztJQUN6RSxDQUFDO0lBRUQsTUFBTSxDQUFDLFdBQVc7UUFDaEIsT0FBTyxRQUFRLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxZQUFZLEVBQUUsQ0FBQyxDQUFDO0lBQ3JELENBQUM7SUFFRCxNQUFNLENBQUMsV0FBVyxDQUFDLEdBQWlCO1FBQ2xDLFFBQVEsR0FBRyxHQUFHLENBQUM7SUFDakIsQ0FBQztDQUNGO0FBRUQsSUFBSSxRQUFRLEdBQXNCLElBQUksQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAyMDIyIFRoZSBDaHJvbWl1bSBBdXRob3JzXG4vLyBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhIEJTRC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4vLyBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlLlxuXG5pbXBvcnQge1BhZ2VIYW5kbGVyRmFjdG9yeSwgUGFnZUhhbmRsZXJSZW1vdGV9IGZyb20gJy4vbWFuYWdlX21pcnJvcnN5bmMubW9qb20td2VidWkuanMnO1xuXG5leHBvcnQgY2xhc3MgQnJvd3NlclByb3h5IHtcbiAgaGFuZGxlcjogUGFnZUhhbmRsZXJSZW1vdGUgPSBuZXcgUGFnZUhhbmRsZXJSZW1vdGUoKTtcblxuICBjb25zdHJ1Y3RvcigpIHtcbiAgICBjb25zdCBmYWN0b3J5ID0gUGFnZUhhbmRsZXJGYWN0b3J5LmdldFJlbW90ZSgpO1xuICAgIGZhY3RvcnkuY3JlYXRlUGFnZUhhbmRsZXIodGhpcy5oYW5kbGVyLiQuYmluZE5ld1BpcGVBbmRQYXNzUmVjZWl2ZXIoKSk7XG4gIH1cblxuICBzdGF0aWMgZ2V0SW5zdGFuY2UoKTogQnJvd3NlclByb3h5IHtcbiAgICByZXR1cm4gaW5zdGFuY2UgfHwgKGluc3RhbmNlID0gbmV3IEJyb3dzZXJQcm94eSgpKTtcbiAgfVxuXG4gIHN0YXRpYyBzZXRJbnN0YW5jZShvYmo6IEJyb3dzZXJQcm94eSkge1xuICAgIGluc3RhbmNlID0gb2JqO1xuICB9XG59XG5cbmxldCBpbnN0YW5jZTogQnJvd3NlclByb3h5fG51bGwgPSBudWxsOyJdfQ==