// chrome/browser/ui/webui/ash/manage_mirrorsync/manage_mirrorsync.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { FilePathSpec as mojoBase_mojom_FilePathSpec } from '//resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js';
export class PageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.manage_mirrorsync.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "ash.manage_mirrorsync.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPageHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.manage_mirrorsync.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getChildFolders(path) {
        return this.proxy.sendMessage(0, PageHandler_GetChildFolders_ParamsSpec.$, PageHandler_GetChildFolders_ResponseParamsSpec.$, [
            path
        ], false);
    }
    getSyncingPaths() {
        return this.proxy.sendMessage(1, PageHandler_GetSyncingPaths_ParamsSpec.$, PageHandler_GetSyncingPaths_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_GetChildFolders_ParamsSpec.$, PageHandler_GetChildFolders_ResponseParamsSpec.$, impl.getChildFolders.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_GetSyncingPaths_ParamsSpec.$, PageHandler_GetSyncingPaths_ResponseParamsSpec.$, impl.getSyncingPaths.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "ash.manage_mirrorsync.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
export const PageHandler_GetSyncPathErrorSpec = { $: mojo.internal.Enum() };
export var PageHandler_GetSyncPathError;
(function (PageHandler_GetSyncPathError) {
    PageHandler_GetSyncPathError[PageHandler_GetSyncPathError["MIN_VALUE"] = 0] = "MIN_VALUE";
    PageHandler_GetSyncPathError[PageHandler_GetSyncPathError["MAX_VALUE"] = 2] = "MAX_VALUE";
    PageHandler_GetSyncPathError[PageHandler_GetSyncPathError["kServiceUnavailable"] = 0] = "kServiceUnavailable";
    PageHandler_GetSyncPathError[PageHandler_GetSyncPathError["kSuccess"] = 1] = "kSuccess";
    PageHandler_GetSyncPathError[PageHandler_GetSyncPathError["kFailed"] = 2] = "kFailed";
})(PageHandler_GetSyncPathError || (PageHandler_GetSyncPathError = {}));
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    getChildFolders;
    getSyncingPaths;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getChildFolders =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_GetChildFolders_ParamsSpec.$, PageHandler_GetChildFolders_ResponseParamsSpec.$, this.getChildFolders.createReceiverHandler(true /* expectsResponse */), false);
        this.getSyncingPaths =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_GetSyncingPaths_ParamsSpec.$, PageHandler_GetSyncingPaths_ResponseParamsSpec.$, this.getSyncingPaths.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_GetChildFolders_ParamsSpec = { $: {} };
export const PageHandler_GetChildFolders_ResponseParamsSpec = { $: {} };
export const PageHandler_GetSyncingPaths_ParamsSpec = { $: {} };
export const PageHandler_GetSyncingPaths_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('handler', 0, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetChildFolders_ParamsSpec.$, 'PageHandler_GetChildFolders_Params', [
    mojo.internal.StructField('path', 0, 0, mojoBase_mojom_FilePathSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetChildFolders_ResponseParamsSpec.$, 'PageHandler_GetChildFolders_ResponseParams', [
    mojo.internal.StructField('paths', 0, 0, mojo.internal.Array(mojoBase_mojom_FilePathSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetSyncingPaths_ParamsSpec.$, 'PageHandler_GetSyncingPaths_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetSyncingPaths_ResponseParamsSpec.$, 'PageHandler_GetSyncingPaths_ResponseParams', [
    mojo.internal.StructField('error', 0, 0, PageHandler_GetSyncPathErrorSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('syncingPaths', 8, 0, mojo.internal.Array(mojoBase_mojom_FilePathSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
//# sourceMappingURL=data:application/json;base64,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