import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-shared-style shared-style">
  :host {
    display: flex;
    justify-content: center;
  }

  .cr-row {
    display: flex;
    flex: 0 1 100%;
  }

  #flagDisabledContainer {
    align-items: center;
    display: flex;
    flex-direction: column;
  }
</style>

<template is="dom-if" if="[[isPhoneHubEnabled_]]" restamp>
  <div class="cr-row">
    <div class="cr-padded-text">
      Toggle on to use fake PhoneHub
    </div>
    <cr-toggle checked="{{shouldEnableFakePhoneHubManager_}}">
    </cr-toggle>
  </div>
  <template is="dom-if" if="[[!shouldEnableFakePhoneHubManager_]]" restamp>
    <div class="cr-row">
      <div class="cr-padded-text">
        Click to undo Notification Setup UI user dismissal. Note that
        Notification access must already be revoked for Google Play services on
        the phone (Toggle "Allow notification access" to off in Settings >
        Notifications > Device & app notifications > Google Play services OR
        Settings > Apps > Special app access > Device & app notifications >
        Google Play services). This will restart the Notification access
        onboarding flow.
      </div>
      <cr-button class="internals-button" on-click="onResetHasMultideviceFeatureSetupUiBeenDismissedButtonClick_">
        Reset
      </cr-button>
    </div>
    <div class="cr-row">
      <div class="cr-padded-text">
        Click to undo hiding of onboaring UI. The oboarding UI is hidden when
        the user has enabled the phonehub feature or if the user dismisses
        onboarding UI. Note that the user must have not started the opt-in flow
        yet.
      </div>
      <cr-button class="internals-button" on-click="onResetShouldShowOnboardingUiButtonClick_">
        Reset
      </cr-button>
    </div>
    <div class="cr-row">
      <div class="cr-padded-text">
        Click to make the Recent Photos onboarding UI appear when the feature
        becomes disabled by the user if it has been dismissed by the user
        previously. Note that this should be done before disabling Recent
        Photos from the Chromebook settings page in order for the onboarding UI
        to reappear.
      </div>
      <cr-button class="internals-button" on-click="onResetCameraRollOnboardingUiDismissedButtonClick_">
        Reset
      </cr-button>
    </div>
  </template>
  <template is="dom-if" if="[[shouldEnableFakePhoneHubManager_]]" restamp>
    <div class="cr-row">
      <div class="cr-padded-text">
        Select feature status
      </div>
      <select id="featureStatusList" class="md-select" on-change="onFeatureStatusSelected_">
        <template is="dom-repeat" items="[[featureStatusList_]]">
          <option selected="[[isEqual_(item, featureStatus_)]]">
            [[getFeatureStatusName_(item)]]
          </option>
        </template>
      </select>
      <div class="cr-padded-text" hidden="[[isFeatureEnabledAndConnected_]]">
        More controls will appear if the feature status is set to
        <span class="emphasize">ENABLED_AND_CONNECTED</span>.
      </div>
    </div>
    <template is="dom-if" if="[[canOnboardingFlowBeShown_]]" restamp>
      <div class="cr-row">
        <div class="cr-padded-text">
          Toggle on to show Onboarding flow.
        </div>
        <cr-toggle checked="{{shouldShowOnboardingFlow_}}">
        </cr-toggle>
      </div>
    </template>
    <template is="dom-if" if="[[isPhoneSetUp_]]" restamp>
      <div class="cr-row">
        <phone-name-form></phone-name-form>
      </div>
    </template>
    <template is="dom-if" if="[[isFeatureEnabledAndConnected_]]" restamp>
      <div class="cr-row">
        <quick-action-controller-form></quick-action-controller-form>
      </div>
      <div class="cr-row">
        <phone-status-model-form></phone-status-model-form>
      </div>
      <div class="cr-row">
        <browser-tabs-model-form></browser-tabs-model-form>
      </div>
      <div class="cr-row">
        <notification-manager></notification-manager>
      </div>
      <div class="cr-row">
        <camera-roll-manager-form></camera-roll-manager-form>
      </div>
    </template>
  </template>
</template>
<template is="dom-if" if="[[!isPhoneHubEnabled_]]" restamp>
  <div id="flagDisabledContainer">
    <p>Phone Hub flag is disabled.</p>
    <cr-button on-click="onPhoneHubFlagButtonClick_">
      Enable
    </cr-button>
  </div>
</template>
<!--_html_template_end_-->`;
}