import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style include="shared-style"></style>

<div id='controlsPanel'>
  <div class="control">
    <div id='logControlSplit'>
      <div id="logType">
        <div class='control-title'>Log Type</div>
        <div class="input-div">
          <input aria-labelledby="nearbyPresenceLabel" type="checkbox">
          <label id="nearbyPresenceLabel">Nearby Presence</label>
        </div>
        <div class="input-div">
          <input aria-labelledby="nearbyShareLabel" type="checkbox">
          <label id="nearbyShareLabel">Nearby Share</label>
        </div>
        <div class="input-div">
          <input aria-labelledby="nearbyConnectionsLabel" type="checkbox">
          <label id="nearbyConnectionsLabel">Nearby Connections</label>
        </div>
        <div class="input-div">
          <input aria-labelledby="fastPairLabel" type="checkbox">
          <label id="fastPairLabel">Fast Pair</label>
        </div>
      </div>
      <div id="logFilters">
        <div class="input-div">
          <label id="logSearchLabel">Search</label>
          <input aria-labelledby="logSearchLabel" id="logSearch" type="text">
        </div>
        <label id="logLevelLabel">Min Log Level</label>
        <select aria-labelledby="logLevelLabel" id="logLevelSelector">
          <template is="dom-repeat" items="[[logLevelList_]]">
            <option
                value="[[item.value]]">
              [[item.name]]
            </option>
          </template>
        </select>
        <div id="filterApplyDiv">
          <cr-button class="internals-button" id="filterApply"
              on-click="addLogFilter_">Apply Filters</cr-button>
        </div>
      </div>
    </div>
  </div>
</div>
<div id="buttons">
  <cr-button disabled="[[!logList_.length]]" class="internals-button"
      on-click="onSaveUnfilteredLogsButtonClicked_">
    Save All Logs
  </cr-button>
  <cr-button disabled="[[!filteredLogList_.length]]" class="internals-button"
      on-click="onSaveFilteredLogsButtonClicked_">
    Save Filtered Logs
  </cr-button>
  <cr-button disabled="[[!logList_.length]]" class="internals-button"
      on-click="onClearLogsButtonClicked_">
    Clear Logs
  </cr-button>
</div>
<iron-list id="logIronList" items="[[filteredLogList_]]" as="log">
  <template>
    <log-object log-message="[[log]]">
    </log-object>
  </template>
</iron-list>
<!--_html_template_end_-->`}