import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
  TODO(b/276319002): The <cross-device-internals> element will eventually
  replace the <nearby-internals> object as main page. However
  cross-device-internals needs to be built out first which is low priority.
  Until it is complete, cross-device-internals will be used as a part of the
  ui-triggers-tab.
-->
<style include="shared-style md-select cros-color-overrides"></style>

<body>
  <section id='controls'>
    <header>
      <div class='title'>Cross Device Internals</div>
    </header>
    <div class='controls-panel'>
      <div class="control">
        <div id='logControlSplit'>
          <log-types id="logType"></log-types>
          <div id="logFilters">
            <div class="input-div">
              <label id="logSearchLabel">Search</label>
              <input aria-labelledby="logSearchLabel" id="logSearch"
                  type="text">
            </div>
            <label id="logLevelLabel">Min Log Level</label>
            <select aria-labelledby="logLevelLabel" id="logLevelSelector">
              <template is="dom-repeat" items="[[logLevelList_]]">
                <option
                    value="[[item.value]]">
                  [[item.name]]
                </option>
              </template>
            </select>
            <div id="filterApplyDiv">
              <cr-button class="internals-button" id="filterApply"
                  on-click="addLogFilter_">Apply Filters</cr-button>
            </div>
          </div>
        </div>

        <div id="buttons">
          <cr-button disabled="[[!logList_.length]]" class="internals-button"
              on-click="onSaveUnfilteredLogsButtonClicked_">
            Save All Logs
          </cr-button>
          <cr-button disabled="[[!logList_.length]]" class="internals-button"
              on-click="onSaveFilteredLogsButtonClicked_">
            Save Filtered Logs
          </cr-button>
          <cr-button disabled="[[!logList_.length]]" class="internals-button"
              on-click="onClearLogsButtonClicked_">
            Clear Logs
          </cr-button>
        </div>
      </div>
    </div>

    <div class='controls-panel'>
      <div class='control'>
        <div id="actions">
          <div class="select-div">
            <label id="ActionGroupLabel">Feature: </label>
            <select aria-labelledby="ActionGroupLabel" name="ActionGroup"
                id="actionGroup" class="md-select"
                on-change="updateActionsSelect_">
              <template is="dom-repeat" items="[[featuresList_]]">
                <option
                    value="[[item.value]]">
                  [[item.name]]
                </option>
              </template>
            </select>
          </div>

          <div class="select-div">
            <label id="ActionSelectLabel">Action: </label>
            <select aria-labelledby="ActionSelectLabel" name="Action"
                id="actionSelect" class="md-select">
              <template is="dom-repeat" items="{{actionsSelectList_}}"
                  as="action">
                <option value="{{action.value}}">
                  {{action.name}}
                </option>
              </template>
            </select>
          </div>
          <cr-button id="executeButton" class="internals-button"
              on-click="performAction_">Execute
          </cr-button>
        </div>
      </div>
    </div>

    <div class='control' id='remoteDevicesControl'>
      <div class='control-title'>Returned Objects</div>
      <iron-list items="[[npDiscoveredDevicesList_]]" as="generic-object"
        id="devicesSection">
        <template>
          <np-object device="[[generic-object]]">
          </np-object>
        </template>
      </iron-list>
    </div>
  </section>

  <div id="logsPanel">
    <iron-list id="log-iron-list" items="[[filteredLogList_]]" as="log">
      <template>
        <log-object log-message="[[log]]">
        </log-object>
      </template>
    </iron-list>
  </div>
</body>
<!--_html_template_end_-->`;
}
