import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="shared-style">:host{--standard-border:1px solid black}ui-trigger-object:last-child{border-bottom:var(--standard-border)}ui-trigger-object{border-inline-end:var(--standard-border);border-inline-start:var(--standard-border);border-top:var(--standard-border)}.buttons{display:flex}#logging-section{display:flex;flex-direction:column;height:100%;white-space:pre-wrap}#share-select{padding-inline-end:10px}#flex{flex:1}cr-button{height:35px;padding:5px;width:150px}</style>
<div>
  <div class="buttons">
    <cr-button class="internals-button"
        on-click="onRegisterSendSurfaceBackgroundClicked_">
      Register Background SendSurface
    </cr-button>
    <cr-button class="internals-button"
        on-click="onRegisterSendSurfaceForegroundClicked_">
      Register Foreground SendSurface
    </cr-button>
    <cr-button class="internals-button"
        on-click="onUnregisterSendSurfaceClicked_">
      Unregister Current SendSurface
    </cr-button>
    <cr-button class="internals-button" on-click="onClearPrefsButtonClicked_">
      Reset Nearby
    </cr-button>
    <span id="flex"></span>
    <cr-button on-click="onAcceptClicked_" class="internals-button"
        class="trigger-button"
        disabled="[[!shareTargetSelectOptionList_.length]]">
      Accept
    </cr-button>
    <cr-button on-click="onRejectClicked_" class="internals-button"
        class="trigger-button"
        disabled="[[!shareTargetSelectOptionList_.length]]">
      Reject
    </cr-button>
    <cr-button on-click="onOpenClicked_" class="internals-button"
        class="trigger-button"
        disabled="[[!shareTargetSelectOptionList_.length]]">
      Open
    </cr-button>
  </div>
  <div class="buttons">
    <cr-button class="internals-button"
        on-click="onRegisterReceiveSurfaceBackgroundClicked_">
      Register Background ReceiveSurface
    </cr-button>
    <cr-button class="internals-button"
        on-click="onRegisterReceiveSurfaceForegroundClicked_">
      Register Foreground ReceiveSurface
    </cr-button>
    <cr-button class="internals-button"
        on-click="onUnregisterReceiveSurfaceClicked_">
      Unregister Current ReceiveSurface
    </cr-button>
    <cr-button class="internals-button" on-click="onGetStatesClicked_">
      Get States
    </cr-button>
    <span id="flex"></span>
    <select id="share-select" on-change="onSelectChange_">
      <template is="dom-repeat" items="[[shareTargetSelectOptionList_]]">
        <option value="[[item.value]]" selected="[[item.selected]]">
          [[item.name]]
        </option>
      </template>
    </select>
    <cr-button on-click="onSendTextClicked_" class="internals-button"
        class="trigger-button"
        disabled="[[!shareTargetSelectOptionList_.length]]">
      Send Text
    </cr-button>
    <cr-button on-click="onCancelClicked_" class="internals-button"
        class="trigger-button"
        disabled="[[!shareTargetSelectOptionList_.length]]">
      Cancel
    </cr-button>
  </div>
  <div class="buttons">
    <cr-button class="internals-button"
        on-click="onNearbyShareReceivedNotificationClicked_">
      Nearby Share Received Notification
    </cr-button>
  </div>
  <div class="buttons">
    <cr-button class="internals-button"
        on-click="onFastPairErrorNotificationClicked_">
      Fast Pair Error Notification
    </cr-button>
    <cr-button class="internals-button"
        on-click="onFastPairDiscoveryNotificationClicked_">
      Fast Pair Discovery Notification
    </cr-button>
    <cr-button class="internals-button"
        on-click="onFastPairDeviceApplicationAvailableNotificationClicked_">
      Fast Pair Device Application Available Notification
    </cr-button>
    <cr-button class="internals-button"
        on-click="onFastPairDeviceApplicationInstalledNotificationClicked_">
        Fast Pair Device Application Installed Notification
    </cr-button>
    <cr-button class="internals-button"
        on-click="onFastPairPairingNotificationClicked_">
      Fast Pair Pairing Notification
    </cr-button>
    <cr-button class="internals-button"
        on-click="onFastPairAssociateAccountNotificationClicked_">
      Fast Pair Save Account Notification
    </cr-button>
  </div>
</div>
<div class="buttons">
  <cross-device-internals></cross-device-internals>
</div>
<iron-list items="[[uiTriggerObjectList_]]" as="generic-object"
    id="logging-section">
  <template>
    <ui-trigger-object item="[[generic-object]]">
    </ui-trigger-object>
  </template>
</iron-list>
<!--_html_template_end_-->`;
}
