// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/shared/nearby_onboarding_one_page.js";import"/shared/nearby_visibility_page.js";import"./nearby_confirmation_page.js";import"./nearby_discovery_page.js";import"chrome://resources/ash/common/cr_elements/cr_view_manager/cr_view_manager.js";import{NearbyShareSettingsMixin}from"/shared/nearby_share_settings_mixin.js";import{CloseReason}from"/shared/types.js";import{ColorChangeUpdater}from"chrome://resources/cr_components/color_change_listener/colors_css_updater.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./app.html.js";var Page;(function(Page){Page["CONFIRMATION"]="confirmation";Page["DISCOVERY"]="discovery";Page["ONEPAGE_ONBOARDING"]="onboarding-one";Page["VISIBILITY"]="visibility"})(Page||(Page={}));const NearbyShareAppElementBase=NearbyShareSettingsMixin(PolymerElement);export class NearbyShareAppElement extends NearbyShareAppElementBase{static get is(){return"nearby-share-app"}static get template(){return getTemplate()}static get properties(){return{pageEnum_:{type:Object,value:Page},confirmationManager_:{type:Object,value:null},transferUpdateListener_:{type:Object,value:null},selectedShareTarget_:{type:Object,value:null},payloadPreview_:{type:Object,value:null}}}ready(){super.ready();this.addEventListener("change-page",(e=>this.onChangePage_(e)));this.addEventListener("close",(e=>this.onClose_(e)));this.addEventListener("onboarding-complete",this.onOnboardingComplete_);ColorChangeUpdater.forDocument().start()}focusOnPageContainer_(page){this.shadowRoot.querySelector(`nearby-${page}-page`).shadowRoot.querySelector("nearby-page-template").shadowRoot.querySelector("#pageContainer").focus()}onSettingsRetrieved(){if(this.settings.isOnboardingComplete){if(!this.settings.enabled){this.set("settings.enabled",true)}this.$.viewManager.switchView(Page.DISCOVERY);this.focusOnPageContainer_(Page.DISCOVERY);return}const onboardingPage=Page.ONEPAGE_ONBOARDING;this.$.viewManager.switchView(onboardingPage);this.focusOnPageContainer_(onboardingPage)}onChangePage_(event){this.$.viewManager.switchView(event.detail.page);this.focusOnPageContainer_(event.detail.page)}onClose_(event){const reason=event.detail.reason==null?CloseReason.UNKNOWN:event.detail.reason;chrome.send("close",[reason])}onOnboardingComplete_(){this.$.viewManager.switchView(Page.DISCOVERY);this.focusOnPageContainer_(Page.DISCOVERY)}}customElements.define(NearbyShareAppElement.is,NearbyShareAppElement);